/*
 * cover.java
 *
 * Created on 4. Maerz 2006, 21:42
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package cover;


import java.io.File;

import java.util.*;
import java.net.URLEncoder;

import org.jdom.Document;
import org.jdom.*;
import org.jdom.input.SAXBuilder;

/**
 *
 * @author jarny
 */
public class cover
{
  static private final int CONST_MAX_ENTRIES = 30;
  
  public static void main(String[] args)
  {
    String url;
    String sKeyword;
    String sOutputFilename = "";
    int iParamMaxDownloads = 0;
    
    String sArtist = "";
    String sAlbum = "";
    
//    String[] args = new String[4];
//    args[0] = "ac/dc";
//    args[1] = "back in black";
//    args[2] = "acdc";
//    args[3] = "50";
    
        
    if (args.length <= 1)
    {
      System.out.println("Usage: cover.cover artist album outputfilename [maxDownloads]\n");
      System.exit(0);
    }
    
    if( args.length > 1 )
    {
      sArtist = args[0];
      sAlbum = args[1];
    }
    
    sOutputFilename = "";
    if( args.length > 2 )
    {
      sOutputFilename = args[2];
    }

    try
    {
      String sMaxAnz = "";
      if( args.length > 3 )
      {
        sMaxAnz = args[3];
        iParamMaxDownloads = Integer.parseInt(sMaxAnz);
      }
    }
    catch(Exception e)
    {
      e.printStackTrace();
      System.out.println("Setting maxDownload parameter to '1'\n");
      iParamMaxDownloads = 1;
    }
    
    
    
    System.out.println("Searching Artist:" + sArtist + " Album:" + sAlbum);
    
    SAXBuilder builder = new SAXBuilder();
    HashMap hmSearchCoverEntry = new HashMap();
    ArrayList alSearchCoverEntry = new ArrayList();
    
    loadcover(sArtist, sAlbum, sOutputFilename, iParamMaxDownloads);
  }
  
  
  
  
  static boolean loadcover(String sArtist_, String sAlbum_, String sFilename, int iMaxDownloads)
  {
    String sURL = "";
    String sUnifyArtist = unifyString(sArtist_);
    String sUnifyAlbum  = unifyString(sAlbum_);
    
    try
    {
      String sArtist = URLEncoder.encode(sUnifyArtist, "UTF-8");
      String sAlbum  = URLEncoder.encode(sUnifyAlbum, "UTF-8");
      
//      sURL = "http://webservices.amazon.de/onca/xml?Service=AWSECommerceService&SearchIndex=Music&SubscriptionId=0X1CM51JYED03CW9MJR2&Artist=" + sArtist + 
//            "&Title=" + sAlbum + "&Version=2005-10-05&ResponseGroup=Tracks,Images,ItemAttributes,Reviews&Operation=ItemSearch&ItemPage=";
      sURL = "http://webservices.amazon.de/onca/xml?Service=AWSECommerceService&SearchIndex=Music&SubscriptionId=0X1CM51JYED03CW9MJR2&Keywords=" + sArtist + "+" + sAlbum + "&Version=2005-10-05&ResponseGroup=Tracks,Images,ItemAttributes,Reviews&Operation=ItemSearch&ItemPage=";
    }
    catch( Exception e)
    {
      e.printStackTrace();
    }
    
    SAXBuilder builder = new SAXBuilder();
    HashMap hmCoverEntry = new HashMap();
    ArrayList alCoverEntry = new ArrayList();
    
    int iCount = 0;
    int iPage = 1;
    int iMaxPage = 5;
    
    while (iPage <= iMaxPage)
    {
      Document doc = null;
      CoverEntry ce = null;
      
      try
      {
        doc = builder.build(sURL + iPage); // Seitennummer an die URL haengen
        System.out.println("URL: " + sURL + iPage);
      }
      catch(Exception e)
      {
        System.err.print("Fehler beim Parsen des XML-Documents:");
        e.printStackTrace();
        return false;
      }
      
      
      Element elRootNew = doc.getRootElement();
      Namespace ns = Namespace.getNamespace("http://webservices.amazon.com/AWSECommerceService/2005-10-05");
      
      //System.out.println("elRootNew=" + elRootNew.getName() );
      Element elItems = elRootNew.getChild("Items",ns);
      
      try
      {
        int iXMLMaxPage = Integer.parseInt( elItems.getChild("TotalPages", ns).getText() );
        
        if( iXMLMaxPage < iMaxPage)
          iMaxPage = iXMLMaxPage;  // Die MaxPage knnte man immer setzen (iMaxPage = iXMLMaxPage) weil die Maximale Zahl an Eintrgen unten durch iCount > CONST_MAX_ENTRIES begrenzt wird
        
        //System.out.println("Resultpage: " + iPage + " of " + iMaxPage);
      }
      catch(Exception e)
      {
        e.printStackTrace();
      }
      
      
      List li = elItems.getChildren("Item",ns);
      for ( int i = 0; i < li.size(); i++)
      {
        try
        {
          //String s = null;
          Element elTmp = null;
          List liTmp = null;
          
          Element el = (Element) li.get(i);
          Element el2 = (Element) el.getChild("ItemAttributes",ns);
          
          ce = new CoverEntry();
          
          elTmp = el2.getChild("Title",ns);
          if(elTmp != null) ce.sProductName = elTmp.getText();
          elTmp = el2.getChild("ReleaseDate",ns);
          if(elTmp != null) ce.sReleaseDate = elTmp.getText();
          elTmp = el2.getChild("Artist",ns); // Meistens heisst es Artist, manchmal aber auch Author
          if(elTmp != null) 
          {
            ce.addArtist( elTmp.getText() );
          }
          else
          {
            elTmp = el2.getChild("Author",ns);
            if(elTmp != null) ce.addArtist( elTmp.getText() );
          }
          elTmp = el2.getChild("Format",ns);
          if(elTmp != null) ce.sFormat = elTmp.getText();
          elTmp = el2.getChild("Binding",ns);
          if(elTmp != null) ce.sBinding = elTmp.getText();
          
          // Das grte Coverbild ermitteln
          elTmp = el.getChild("LargeImage",ns);
          if( (elTmp != null) )
          {
            ce.sImageURL = elTmp.getChildTextTrim("URL",ns).trim();
            ce.bHasImages = true;
          }
          
          if(ce.sImageURL.equals("") )
          {
            elTmp = el.getChild("MediumImage",ns);
            if( (elTmp != null) )
            {
              ce.sImageURL = elTmp.getChildTextTrim("URL",ns).trim();
              ce.bHasImages = true;
            }
          }
          
          if(ce.sImageURL.equals("") )
          {
            elTmp = el.getChild("SmallImage",ns);
            if( (elTmp != null) )
            {
              ce.sImageURL = elTmp.getChildTextTrim("URL",ns).trim();
              ce.bHasImages = true;
            }
          }
          
          
          // Trackliste holen
          String sTracklist = "";
          try
          {
            el2 = (Element) el.getChild("Tracks",ns);
            List liDiscs = el2.getChildren("Disc",ns);

            for( int h = 0; h < liDiscs.size(); h++)
            {
              Element elDisc = (Element)liDiscs.get(h); 
              
              String sDisc = elDisc.getAttributeValue("Number");
              List liTracks = elDisc.getChildren("Track",ns);
            
              for( int j = 0; j < liTracks.size(); j++)
              {
                Element elTrack = (Element) liTracks.get(j);
                sTracklist = sTracklist + "Disc " + sDisc + " - Track " + elTrack.getAttributeValue("Number") + " - " + elTrack.getTextTrim() + "\n" ;
              }
            }
            
            ce.sTracklist = sTracklist;
          }
          catch(Exception e)
          {
            System.out.println("No tracks available");
          }


          // Reviews holen
          try
          {
            el2 = (Element) el.getChild("CustomerReviews",ns);
            List liReviews = el2.getChildren("Review",ns);
            
            String sReviews = "";
            for( int k = 0; k < liReviews.size(); k++)
            {
              Element elReview = (Element) liReviews.get(k);
              String sRevDate = elReview.getChildTextTrim("Date", ns);
              String sSummary = elReview.getChildTextTrim("Summary", ns);
              String sContent = elReview.getChildTextTrim("Content", ns);
              
              sReviews = sReviews + sSummary + "  (vom " + sRevDate + ")" + "\n" + sContent + "\n\n";
            }
            ce.sReviews = sReviews;
          }
          catch(Exception e)
          {
            System.out.println("No Revies available");
          }
        }
        catch(Exception e)
        {
          System.out.println("Fehler: " + e.getMessage());
        }
        

        
        System.out.println ( iCount + ". Eintrag gefunden: " + ce.sArtist + " " + ce.sProductName );
        String sKey = ce.asKey() ;
        
        // Datensatz speichern und prfen ob er doppelt vorhanden ist
        if( !hmCoverEntry.containsKey(sKey ) )
        {
          hmCoverEntry.put(sKey, ce);
          alCoverEntry.add(ce);
          //System.out.println ( iCount + " " + ce.toString() );
        }
        else
        {
          //System.out.println ( iCount + " " + sKey + " <<<<<<<<<--------------- Doppelt!!!!!!!!!!");
        }
        
        iCount++;
      }
      iPage++;
      
      if( iCount > CONST_MAX_ENTRIES)
        break;
      
    }// end while()
    
    
    if( iCount == 0 )
    {
      System.out.println( "Kein passendes Cover gefunden" );
      return false;
    }
    
    //       System.out.println ("Insgesamt: " + iCount + " Gespeichert:" + alCoverEntry.size() );
    
    // Liste bewerten
    Iterator it = alCoverEntry.iterator();
    while(it.hasNext())
    {
      ((CoverEntry)it.next()).evaluate(sUnifyArtist, sUnifyAlbum);
    }
    
    // Liste sortieren
    Collections.sort(alCoverEntry, (Comparator) new CoverEntry() );
    
    it = alCoverEntry.iterator();
    while(it.hasNext())
    {
      System.out.println( "MatchVal: " + ((CoverEntry)it.next()).toString() );
    }

    
//    // Pfad zusammenbauen
//    String sFullPath = "";
//    if( sFilename == null || sFilename.equals(""))
//    {
//      sFullPath = "cover_" + sUnifyArtist + "_" + sUnifyAlbum + ".jpg";
//    }
//    else if( new File(sFilename).isDirectory() ) 
//    {
//      sFullPath = sFilename;
//      if( !sFullPath.endsWith("\\") && !sFullPath.endsWith("/"))
//      {
//        sFullPath += "/";
//      }
//      sFullPath = sFullPath + "cover_" + sUnifyArtist + "_" + sUnifyAlbum + ".jpg";
//    }
//    else
//    {
//      sFullPath = sFilename;
//    }

//    int iMaxDownloads = iParamMaxDownloads;
    if(iMaxDownloads < 0 )
      iMaxDownloads = 0;
    
    if(iMaxDownloads > 50 )
      iMaxDownloads = 50;
    
    System.out.println( "MaxDownloads = " + iMaxDownloads);
    
    int iActDownload = 0;
    
    boolean bDownloadOk = false;
    for( int i = 0; i < alCoverEntry.size(); i++)
    {
      if( iActDownload >= iMaxDownloads )
      {
        break;
      }
      
      CoverEntry ce = (CoverEntry)alCoverEntry.get(i);

      // Bild downloaden
      download dl = new download();
      if( ce.bHasImages == true && ce.fEval > .5)
      {
        try
        {
          // Pfad zusammenbauen
          String sFullPath = "";
          String sCounter = "_" + iActDownload;
          
          // Ausnahme wenn man eine 1 als MaxDownload eingestellt hat, dann keine Nummer hinter den Dateinamen hngen
          if( iMaxDownloads==1)
            sCounter = "";
          
          if( sFilename == null || sFilename.equals(""))
          {
            sFullPath = "cover_" + sUnifyArtist + "_" + sUnifyAlbum + sCounter + ".jpg";
          }
          else if( new File(sFilename).isDirectory() ) 
          {
            sFullPath = sFilename;
            if( !sFullPath.endsWith("\\") && !sFullPath.endsWith("/"))
            {
              sFullPath += "/";
            }
            sFullPath = sFullPath + "cover" + sCounter + ".jpg";
          }
          else
          {
            sFullPath = sFilename + sCounter + ".jpg";
          }
          
          int iDownloadsize = dl.callHttp(ce.sImageURL, sFullPath );
          
          if( iDownloadsize > 0 )
            bDownloadOk = true;
          
          System.out.println( "Download Nummer:" + iActDownload );
          System.out.println( ce.toString() + " DownloadStatus:" + dl.getHttpReturnStatus() + " DownloadLength:" + dl.getHttpReturnString().length() );
          System.out.println( "Trackliste");
          System.out.println( ce.sTracklist);
          System.out.println( "Reviews");
          System.out.println( ce.sReviews);
          System.out.println( "Verffentlichung am " + ce.sReleaseDate);
          iActDownload++;
          //break;
        }
        catch(Exception e)
        {
          e.printStackTrace();
        }
      }
      else
      {
        //System.out.println(ce.toString() + " has no coverentry! Trying next entry");
      }
      
      
    }
    
    return bDownloadOk;
  }
  


  
  
  
  static private String unifyString(String sInput)
  {
    String sOutput = sInput.trim().toLowerCase();
    
    sOutput = sOutput.replaceAll("((^der)|(^die)|(^das)|(^the))( |,)", "");   // der, die, das am Anfang des Satzes lschen
    sOutput = sOutput.replaceAll("( |,)((der$)|(die$)|(das$)|(the$))", "");   // der, die, das am Ende des Satzes lschen
   // sOutput = sOutput.replaceAll("[^(\\p{Alnum})| |||||||]", "");   // Alle Sonderzeichen entfernen (ausser Umlaute und Acente)
    sOutput = sOutput.replaceAll("[^(\\p{Alnum})| |'|`||||||||]", " ");   // Alle Sonderzeichen entfernen (ausser Umlaute und Acente)
    sOutput = sOutput.replaceAll(" +", " ");   // Leerzeichen zusammenschieben
    
    sOutput.trim();
    
    if( sOutput.equals(""))
      return sInput.trim().toLowerCase();
    else
      return sOutput;
  }
  
  
  
  
}
