/*
 * font.c: 'EnigmaNG' skin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * Taken from GraphTFT 
 */

#include "common.h"

#include "font.h"
#include <iconv.h>
#include <stdio.h>

cGraphtftFont::cGraphtftFont()
{
}

cGraphtftFont::~cGraphtftFont()
{
	Clear();
}

bool cGraphtftFont::Load(string Filename, string CacheName, int Size, int /* Language */, int Width, int /* format */)
{
	if ( _cache.find(CacheName) != _cache.end() )
		return true;	
	
	cFont *newFont = cFont::CreateFont(Filename.c_str(), Size, Width > 0 ? (Size * Width / 100) : 0);
	if (newFont) {
		_cache[CacheName] = newFont;
		return true;
	}

	// Something went wrong!
	return false;
}

const cFont* cGraphtftFont::GetFont(string CacheName){
	if (CacheName == "Sml") return cFont::GetFont(fontSml);
	else if (CacheName == "Fix") return cFont::GetFont(fontFix);
	else if ( _cache.find(CacheName) != _cache.end() ){
		return _cache[CacheName];
	}
	return cFont::GetFont(fontOsd);
}

void cGraphtftFont::Clear(string /* CacheName */)
{
	Clear();	
}

void cGraphtftFont::Clear()
{
	cache_map::iterator it = _cache.begin();
	for (; it != _cache.end(); ++it)
		delete((*it).second);
	_cache.clear();
}
