/*
 * FreeboxTv : A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: freeboxtv.h 9 2007-06-05 12:16:44Z odj $
 */

#ifndef __freeboxtv_h__
#define __freeboxtv_h__

namespace FreeboxTv {

  class cFreeboxClient : cThread {

  public:
    cFreeboxClient();
    virtual ~cFreeboxClient();
    void Action(void);
    void init_session (UsageEnvironment* env);
    void play_session (void);
    void shutdown();
  };

  class cFreeboxEpg {
  private:
    time_t last_xmltv_grab;
    time_t last_epg_update;
    bool epg_available;
  public:
    cFreeboxEpg();
    virtual ~cFreeboxEpg();
    bool Parse (const char* filename);
    time_t GetLastGrab() { return last_xmltv_grab; }
    time_t GetLastEpgUpdate() { return last_epg_update; }
    void SetLastGrab() { last_xmltv_grab = time(NULL); }
    void SetLastGrab(int) { last_xmltv_grab = (time_t) 0; }
    void SetLastEpgUpdate() { last_epg_update = time(NULL); }
    void SetLastEpgUpdate(int) { last_epg_update = (time_t) 0; }
  };
}

#endif
