/*
 * trayopen.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 */
#include <getopt.h>
#include <stdlib.h>
#include <vdr/plugin.h>
#include <vdr/interface.h>

#include "i18n.h"


static const char *VERSION 	 = "0.0.2-dev";
static const char *DESCRIPTION   = trNOOP("Open/Close CD/DVD-Rom");
static const char *MAINMENUENTRY = trNOOP("Trayopen");

// --------------- Setup menu -------------------
#include <vdr/menuitems.h>

class cPluginTrayopen;

class cMenuSetupTrayopen : public cMenuSetupPage {
private:
  cPluginTrayopen *m_Plugin;

  int   m_HideMainMenuEntry;
  char  m_Device[1024];

protected:
  virtual void Store(void);

public:
  cMenuSetupTrayopen(cPluginTrayopen *Plugin);
}; 


//----------------- Plugin ----------------------

class cPluginTrayopen : public cPlugin {
private:

protected:
  bool m_HideMainMenuEntry;
  char *m_Device;
  void SaveSetup(void);
  bool m_HaveSetup;
  int  m_isOpen;

public:
  cPluginTrayopen(void);
  virtual ~cPluginTrayopen();
  virtual const char *Version(void) {return VERSION; }
  virtual const char *Description(void) { return tr(DESCRIPTION); }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void); 
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void) { return m_HideMainMenuEntry ? NULL : tr(MAINMENUENTRY); } 
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);

  friend class cMenuSetupTrayopen; 
};

// --- cPluginTrayopen ----------------------------------------------------------

cPluginTrayopen::cPluginTrayopen(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
  m_HideMainMenuEntry = false;
  m_Device = strdup("/dev/dvd");
}

cPluginTrayopen::~cPluginTrayopen()
{
  // Clean up after yourself!
}


const char *cPluginTrayopen::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginTrayopen::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginTrayopen::Initialize(void)
{
  // Initialize any background activities the plugin shall perform.
  return true;
} 


bool cPluginTrayopen::Start(void)
{
  // Start any background activities the plugin shall perform.
  SaveSetup(); 
  return true;
}


void cPluginTrayopen::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

cOsdObject *cPluginTrayopen::MainMenuAction(void)
{
  // Perform the action when selected from the main VDR menu.
FILE *file;
char *buffer;

 if (m_isOpen == true)
{
	asprintf(&buffer, "eject -t %s &",m_Device);
	m_isOpen = false;
}
else
{
	asprintf(&buffer, "eject %s &",m_Device);
	m_isOpen = true;
}
	file = popen(buffer, "r");
	dsyslog("Trayopen: Executing '%s'",buffer);
	free(buffer);
	pclose(file);

  return NULL;
}


cMenuSetupPage *cPluginTrayopen::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cMenuSetupTrayopen(this);
} 


bool cPluginTrayopen::SetupParse(const char *Name, const char *Value)
{
  m_HaveSetup = true;

  // Parse your own setup parameters and store their values.
  if(!strcmp(Name,"HideMainMenuEntry")) { m_HideMainMenuEntry = atoi(Value) ? true : false; return true; }
  else if(!strcmp(Name,"Device")) {
    if(m_Device)
      free(m_Device);
    m_Device = strdup(Value);
    return true;
  }

  return false;
}

void cPluginTrayopen::SaveSetup(void)
{
  SetupStore("HideMainMenuEntry", m_HideMainMenuEntry);
  SetupStore("Device", m_Device);
} 

VDRPLUGINCREATOR(cPluginTrayopen); // Don't touch this!


static inline const char * int_to_str(int i)
{
  static char buf[64];
  sprintf(buf, "%d", i);
  return buf;
} 

void cMenuSetupTrayopen::Store(void)
{
  m_Plugin->SetupParse("HideMainMenuEntry", int_to_str(m_HideMainMenuEntry ? 0 : 1));
  m_Plugin->SetupParse("Device", m_Device);
  m_Plugin->SaveSetup();
} 

cMenuSetupTrayopen::cMenuSetupTrayopen(cPluginTrayopen *Plugin)
{
  m_Plugin = Plugin;

  m_HideMainMenuEntry = m_Plugin->m_HideMainMenuEntry ? 0 : 1;
  strcpy(m_Device, m_Plugin->m_Device);

  Add(new cMenuEditBoolItem(tr("Show in main menu"),     &m_HideMainMenuEntry));
  Add(new cMenuEditStrItem( tr("Device"),        m_Device, 255, tr(" abcdefghijklmnopqrstuvmxyz0123456789-./")));
} 
        
