#!/usr/bin/perl -X

# EDIT only! ENV and path2java


$ENV{PATH}="/bin:/sbin:/usr/bin:/usr/local/bin:/opt/blackdown-jre-1.4.2.03/bin";


$artist    = "$ARGV[0]";
$album     = "\L$ARGV[1]";
$coverdir  = "$ARGV[2]";
$tmpdir    = "$ARGV[3]";
$maxdl     = "$ARGV[4]";
$basedir   = "$ARGV[5]";
$filename  = "$ARGV[6]";
$logger    = "$tmpdir/cover.log";
$path2java = "/opt/blackdown-jre-1.4.2.03/bin";


print "\n
----------------------------------------------------------------------------------------------\n
NAME:
          music_getcover.pl - Perl Script um Coverbilder von Amazons Webservice herunterzuladen.
\n       
SYNOPSIS:       
          music_getcover.pl 'artist' 'album' 'coverdir' 'tempdir' 'maxdownloads' 'basedir' 'filename'
\n
DESCRIPTION:
          Dieses Perlscript macht es einem leichter seine Musiksammlung mit entsprechenden
	  Coverbildern zu versehen.
\n
OPTIONS:
          artist       = Name des Interpreten
	  album        = Name des Album
          coverdir     = Pfad zu ArtistCover (aus Setup von vdr-music)
	  tempdir      = Pfad zum Verzeichnis wo die Cover temporr gespeichert werden
	  maxdownloads = Anzahl der Cover die heruntergeladen werden sollen , wenn vorhanden.
	  basedir      = Pfad zum Musiktrack
	  filename     = Kompletter Pfad des Musiktrack ohne Dateiendung
\n
----------------------------------------------------------------------------------------------\n
\n";

# START.......

system("echo 'Download von Cover gestartet !\n' > $logger");

# DON'T CHANGE ANYTHING HERE
system("echo 'Interpret          : $artist
Album              : $album
ArtistCover        : $coverdir
Tempdir            : $tmpdir
Maximale Downloads : $maxdl
Logdatei           : $logger
Pfad zu Java bin   : $path2java
\n
<value> ARTIST    =$artist
<value> ALBUM     =$album
<value> COVERDIR  =$coverdir
<value> BASEDIR   =$basedir
<value> FILENAME  =$filename
\n' >> $logger");




if(!$artist) {
    system("echo '\nInterpret nicht angegeben. Breche Ausfhrung ab !' >> $logger");
    die;
}    


if(-r "$tmpdir/cover_0.jpg") {
    system("echo '\nEntferne vorhandene Bilddateien\n' >> $logger");
    system("rm -f $tmpdir/*.jpg");
}

system("echo 'Befehl: $path2java/java -cp jdom.jar:coverdownload.jar:. cover.cover \"$artist\" \"$album\" \"cover\" $maxdl' >> $logger");
system("cd $tmpdir; $path2java/java -cp jdom.jar:coverdownload.jar:. cover.cover \"$artist\"  \"$album\" \"cover\" $maxdl >/dev/null");

if(-r "$tmpdir/cover_0.jpg") {
    system("echo '\nDownload von Cover erfolgreich !\n' >> $logger");

#    $artist =~ s/\//-/g;
#    $artist =~ s/\'/ /g;
#    $artist =~ s/\"/ /g;

#    if(-r "$coverdir/$artist.jpg") {
#      system("echo 'Entferne altes Cover\n' >> $logger");
#      system("rm -f \"$coverdir/$artist.jpg\"");
#    }


#    $cmd = "cp -f \"$tmpdir/cover_1.jpg\" \"$coverdir/$artist.jpg\"";

#    system("echo 'Kopiere: $cmd\n' >> $logger");
#    system("$cmd");

#    if(-r "$coverdir/$artist.jpg") {
#        system("echo '\nCover erfolgreich kopiert !\n' >> $logger");
#        }
#      else {
#        system("echo '\nERROR: Cover wurde NICHT kopiert !\n' >> $logger");
#      }

    }
else {
    system("echo '\nFEHLER: Download von Cover NICHT erfolgreich !\n' >> $logger");
}

system("cat '$logger'");
