#ifndef __MUSIC_H
#define __MUSIC_H

#include <string.h>

#include <vdr/plugin.h>

#include "mp3control.h"
//#include "version.h"
//#include "i18n.h"
#include "service.h"
#include "config.h"
#include "common.h"
#include "setup-mp3.h"
#include "setup.h"
#include "menubrowse.h"


class cMenuSetupMP3 : public cMenuSetupPage {
private:
  cMusicConfig data;
  //
  const char *userlevel[3];
  const char *cddb[3], *scan[3], *coversize[4];
  const char *aout[AUDIOOUTMODES];
  int amode, amodes[AUDIOOUTMODES];
protected:
  virtual eOSState ProcessKey(eKeys Key);
  virtual void Store(void);
public:
  cMenuSetupMP3(void);
};


class cMenuSetupSubMenu : public cOsdMenu {
protected:
  cMusicConfig *data;
  virtual eOSState ProcessKey(eKeys Key);
  virtual void Set(void) = 0;
public:
  cMenuSetupSubMenu(const char *Title, cMusicConfig *Data);
};    

#ifdef HAVE_FREETYPE
class cMenuSetupTTF : public cOsdMenu {
private:
  FontInfo *data;
  int nFont;
  int nWidth;
  int nSize;
#if VDRVERSNUM < 10504
  int nMaxTTFs;
  const char **availTTFs;
#else // VDRVERSNUM >= 10504
  cStringList *fontList;
#endif // VDRVERSNUM < 10504    
protected:
  virtual eOSState ProcessKey(eKeys Key);
  void Set(void);
  void Store(void);
public:
#if VDRVERSNUM < 10504
  cMenuSetupTTF(FontInfo *fontinfo);
#else // VDRVERSNUM >= 10504
  cMenuSetupTTF(FontInfo *fontinfo, cStringList* fontList);
#endif // VDRVERSNUM < 10504
};

#endif      


class cMenuSetupFonts : public cMenuSetupSubMenu {
private:
#ifdef HAVE_FREETYPE
#if VDRVERSNUM >= 10504
  cStringList fontNames;
  cStringList fontMonoNames;
#endif
#endif

protected:
  virtual eOSState ProcessKey(eKeys Key);
  void Set(void);
public:
  cMenuSetupFonts(cMusicConfig *Data);
  virtual ~cMenuSetupFonts(void);
};        

#endif // __MUSIC_H
