/*
 * pilot.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#include "config.h"
#include "mosaicosd.h"
#include "mosaicsetup.h"
#include <vdr/device.h>
#include <vdr/plugin.h>
#include <stdio.h>


#if VDRVERSNUM < 10507
#include "i18n.h"
#define trNOOP(s) (s)
#endif

static const char *VERSION        = "0.1.0";
static const char *DESCRIPTION    = trNOOP("Browse mosaic channel");
static const char *MAINMENUENTRY  = trNOOP("Mosaic");

class cPluginMosaic : public cPlugin {
private:
  // Add any member variables or functions you may need here.
public:
  cPluginMosaic(void);
  virtual ~cPluginMosaic();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return DESCRIPTION; }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void);
  virtual bool Start(void);
  virtual void Stop(void);
  virtual void Housekeeping(void);
  virtual void MainThreadHook(void);
  virtual cString Active(void);
  virtual const char *MainMenuEntry(void) { return config.hidemenu ? NULL : tr(MAINMENUENTRY); }
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  virtual bool Service(const char *Id, void *Data = NULL);
  virtual const char **SVDRPHelpPages(void);
  virtual cString SVDRPCommand(const char *Command, const char *Option, int &ReplyCode);
  };


int MosaicChannelNumber;

cPluginMosaic::cPluginMosaic(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
  config.width=580;
  config.height=455;
  config.top=14;
  config.left=3;
  config.right=15;
  config.bottom=15;
  config.originx=80;
  config.originy=87;
  config.showlogos=0;
  config.mosaic1=1;
  config.mosaic2=0;
  config.mosaic3=0;
  config.mosaic4=0;
  config.mosaic5=0;
  config.hidemenu=0;
}

cPluginMosaic::~cPluginMosaic()
{
  // Clean up after yourself!
}

const char *cPluginMosaic::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginMosaic::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginMosaic::Initialize(void)
{
  // Initialize any background activities the plugin shall perform.
  FILE *f = fopen(AddDirectory(cPlugin::ConfigDirectory(), "mosaic.conf"), "r");
  if (f != NULL) {
     fclose(f);
     return true;
     }
  else {
     fprintf(stderr, "\nMOSAIC: Check if the mosaic.conf file is present\n");
     esyslog("MOSAIC: Check if the mosaic.conf file is present");
     return false;
     }
}

bool cPluginMosaic::Start(void)
{
  // Start any background activities the plugin shall perform.
  return true;
}

void cPluginMosaic::Stop(void)
{
  // Stop any background activities the plugin shall perform.
}

void cPluginMosaic::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

void cPluginMosaic::MainThreadHook(void)
{
  // Perform actions in the context of the main program thread.
  // WARNING: Use with great care - see PLUGINS.html!
}

cString cPluginMosaic::Active(void)
{
  // Return a message string if shutdown should be postponed
  return NULL;
}

cOsdObject *cPluginMosaic::MainMenuAction(void)
{
  // Perform the action when selected from the main VDR menu.
  return new cMosaicOsd;
}

cMenuSetupPage *cPluginMosaic::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cMosaicSetup;
}

bool cPluginMosaic::SetupParse(const char *Name, const char *Value)
{
  // Parse your own setup parameters and store their values.
  if (!strcasecmp(Name, "IsMosaicNumber"))
     return (config.mosaic1 == atoi(Value));

  if      (!strcasecmp(Name, "Width"))         config.width = atoi(Value);
  else if (!strcasecmp(Name, "Height"))        config.height = atoi(Value);
  else if (!strcasecmp(Name, "Top"))           config.top = atoi(Value);
  else if (!strcasecmp(Name, "Left"))          config.left = atoi(Value);
  else if (!strcasecmp(Name, "Right"))         config.right = atoi(Value);
  else if (!strcasecmp(Name, "Bottom"))        config.bottom = atoi(Value);
  else if (!strcasecmp(Name, "OriginX"))       config.originx = atoi(Value);
  else if (!strcasecmp(Name, "OriginY"))       config.originy = atoi(Value);
  else if (!strcasecmp(Name, "Showlogos"))     config.showlogos = atoi(Value);
  else if (!strcasecmp(Name, "Mosaic1"))       config.mosaic1 = atoi(Value);
  else if (!strcasecmp(Name, "Mosaic2"))       config.mosaic2 = atoi(Value);
  else if (!strcasecmp(Name, "Mosaic3"))       config.mosaic3 = atoi(Value);
  else if (!strcasecmp(Name, "Mosaic4"))       config.mosaic4 = atoi(Value);
  else if (!strcasecmp(Name, "Mosaic5"))       config.mosaic5 = atoi(Value);
  else if (!strcasecmp(Name, "HideMenu"))      config.hidemenu = atoi(Value);
  else
     return false;
  
  return true;
}

bool cPluginMosaic::Service(const char *Id, void *Data)
{
  // Handle custom service requests from other plugins
  return false;
}

const char **cPluginMosaic::SVDRPHelpPages(void)
{
  // Return help text for SVDRP commands this plugin implements
  return NULL;
}

cString cPluginMosaic::SVDRPCommand(const char *Command, const char *Option, int &ReplyCode)
{
  // Process SVDRP commands this plugin implements
  return NULL;
}

sMosaicConfig config;

VDRPLUGINCREATOR(cPluginMosaic); // Don't touch this!
