/*
 * CoverEntry.java
 *
 * Created on 9. Mrz 2006, 16:59
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package cover;

import java.util.*;

/**
 *
 * @author jarny
 */
public class CoverEntry implements Comparator
{
  
  public String sProductName = "";
  public String sArtist = "";

  public String sReleaseDate = "";
  public String sImageURL = "";
      
  public String sFormat = "";
  public String sBinding = "";
  public double fEval = (double)Math.random() * 10.0;
  
  public boolean bHasImages = false;
  
  public String sTracklist = "";
  public String sReviews = "";
  
  
  /** Creates a new instance of CoverEntry */
  public CoverEntry()
  {
  }
  
      
  void addArtist(String sNewArtist)
  {
    if (!sArtist.equals("") )
    {
      sArtist += ",";
    }

    sArtist += sNewArtist; 
  }
      
  public String toString()
  {
//    return dEval + "|" + sProductName + "|" + sArtist + "|" + sImageURL;
    return (Math.round(fEval*100000))/100000.0 + "|" + bHasImages + "|" + sProductName + "|" + sArtist +  " | " + sFormat + " | " + sBinding;
  }
   
  
  public String asKey() // Eindeutiger Identifizierer
  {
    return sProductName + "|" + sArtist;
  }
   
  
  public String asFilename() // Eindeutiger Identifizierer
  {
    String s = sProductName + " "+ sArtist + ".jpg";
    s = s.replace('|','_');
    s = s.replace('?','_');
    s = s.replace('/','_');
    s = s.replace('\\','_');
    s = s.replace(':','_');
    s = s.replace(';','_');
    s = s.replace('"','_');
    s = s.replace('*','_');
    s = s.replace('&','_');
    //s = s.replace(';','_');
    
    return s;
  }
  

  public void evaluate(String sSearchArtist_, String sSearchAlbum_)
  {
    String sSearchArtist = sSearchArtist_.toLowerCase();
    String sSearchAlbum  = sSearchAlbum_.toLowerCase();
    
    String sOwnArtist = sArtist.toLowerCase();
    String sOwnAlbum  = sProductName.toLowerCase();

    double fArtist = 0.5;
    double fAlbum  = 0.5;
    
    
    // Nicht exakte Matches errechnen
    fAlbum = jarny2Metric(sSearchAlbum, sOwnAlbum);
    fArtist = jarny2Metric(sSearchArtist, sOwnArtist);
    
    if( (fAlbum * fArtist) > .001 ) // Artist und Album bekamen eine Wertung
      fEval = (0.4 * fArtist) + (0.6 * fAlbum);   // Albumname hher bewerten
    else
      fEval = 0.0;
  }
  
  
  
  // Zum Sortieren
  public int compare( Object o1, Object o2)
  {
    double d1 = ((CoverEntry)o1).fEval;
    double d2 = ((CoverEntry)o2).fEval;

    if(Math.abs(d1 - d2) < 0.000001) return 0;
    if(d1 > d2) return -1;
    return 1;
  }

  
  
  // Hilfsfunktionen

  //ist ein String komplett im anderen vorhanden
  private double jarny1Metric(String sStr1, String sStr2)
  {
    if(sStr1 == null)
      return 0.0;
    if(sStr2 == null)
      return 0.0;

    if( sStr1.equals("") || sStr2.equals(""))
      return 0.0;
    
    String s1 = sStr1.toLowerCase();
    String s2 = sStr2.toLowerCase();

    if( s1.indexOf(s2) >= 0) 
      return ((double)s2.length()/s1.length())*.1 + 0.9;
    if( s2.indexOf(s1) >= 0)
      return ((double)s1.length()/s2.length())*.1 + 0.9;
    else
      return 0.0;

  }

  
  
      
    double jarny2Metric(String s1, String s2)
    {
      String[] asS1 = tokenize(s1);
      String[] asS2 = tokenize(s2);
      
      int iSizeX = asS1.length;
      int iSizeY = asS2.length;
      
      
      // Tauschen falls die Y-Achse lnger sein sollte
      if( iSizeX < iSizeY)
      {
        String[] asTemp = asS1;
        asS1 = asS2;
        asS2 = asTemp;
        
        int iTemp = iSizeX;
        iSizeX = iSizeY;
        iSizeY = iTemp;
      }
      
      
      // Max-Array erzeugen
      double[] adMax = new double[iSizeY ]; // hier wird das Maximum einer Zeile ermittelt
      int      iMaximums = 0;
      double   dGlobalMaximum = 1.0; // Gesamtbewertung der Treffer
      
      // Matrix erzeugen
      double[][] adVal = new double[iSizeX][iSizeY];
      
      
      // Jeder mit jedem vergleichen!!! (teuer)
      for( int y = 0; y < iSizeY; y++)
      {
        double dMax = 0.0;
        for( int x = 0; x < iSizeX; x++)
        {
          double dVal = getClipNorm(asS1[x], asS2[y]);
          adVal[x][y] = dVal;
          dMax = Math.max(dVal, dMax);
        }
        adMax[y] = dMax;
        
        if( dMax > 0.0)
        {
          iMaximums++;   // Bei wieviel Tokens wurde eine relevante bereinstimmung gefunden
          dGlobalMaximum = dGlobalMaximum * dMax;
        }
      }
      

      int iAnzTokens = iSizeY;  //Math.min(iSizeX, iSizeY);
      
      
      // Nicht bereinstimmende Tokens (bzgl. der lngeren Achse) wirken ein kleines bisschen abwertend ( 0.5% pro Token = Faktor 0.995)
      dGlobalMaximum = dGlobalMaximum * Math.pow(0.995, (iSizeX - iMaximums)  );
      
      
      // Wenn viele Begriffe bereinstimmen dann kann man die Bewertung zurckgeben
      double dErg = 0.0;
      
      if( iAnzTokens == 1) 
      {
        if( iMaximums == 1) dErg = dGlobalMaximum;
      }
      else if (iAnzTokens == 2)
      {
        if( iMaximums >= 1) dErg = dGlobalMaximum;  // oder 2!!????
      }
      else if (iAnzTokens == 3)
      {
        if( iMaximums >= 2)  dErg = dGlobalMaximum;
      }      
      else if (iAnzTokens >= 4)
      {
        if( iMaximums >= (iAnzTokens-1) )  dErg = dGlobalMaximum;
      }
      else
      {
        dErg = 0.0;
      }
      
      if( dErg > 0.01)
        dErg = dErg;
      
      
      return dErg;
    }
    
    
    private String[] tokenize(String s)
    {
      return s.split("\\s"); 
    }
    
  
  
    // hnlich wie der Levenshtein-Algorithmus
    double getClipNorm(final String string1, final String string2)
    {
      int iDist = (int)getUnNormalisedSimilarity(string1, string2);
      
      int iLength = Math.min(string1.length(), string2.length());
      
      if (iLength <= 2)  // Bei kurzen Worten ist keine Abweichung erlaubt
      {
        if( iDist == 0)
          return 1.0;
        else
          return 0.0;
      }
      
      if( iLength == 3)  // Bei 3buchstabigen Wrter ist eine Abweichung von 1 Buchstaben erlaubt
      {
        if( iDist == 0)
          return 1.0;
        else if (iDist == 1)
          return 0.9;
        else
          return 0.0;
      }
      
      // lngere Wrter
      if (iDist == 0)
        return 1.0;
      else if( iDist == 1)
        return 0.95;
      else if( iDist == 2)
        return 0.9;
      else
        return 0.0;
    }
    
    /**
     * implements the levenstein distance function
     * <p/>
     * Copy character from string1 over to string2 (cost 0)
     * Delete a character in string1 (cost 1)
     * Insert a character in string2 (cost 1)
     * Substitute one character for another (cost 1)
     * <p/>
     * D(i-1,j-1) + d(si,tj) //subst/copy
     * D(i,j) = min D(i-1,j)+1 //insert
     * D(i,j-1)+1 //delete
     * <p/>
     * d(i,j) is a function whereby d(c,d)=0 if c=d, 1 else.
     *
     * @param s
     * @param t
     * @return the levenstein distance between given strings
     */
    public double getUnNormalisedSimilarity(final String s, final String t) {
        final double[][] d; // matrix
        final int n; // length of s
        final int m; // length of t
        int i; // iterates through s
        int j; // iterates through t
        double cost; // cost

        // Step 1
        n = s.length();
        m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        d = new double[n + 1][m + 1];

        // Step 2
        for (i = 0; i <= n; i++) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; j++) {
            d[0][j] = j;
        }

        // Step 3
        for (i = 1; i <= n; i++) {
            // Step 4
            for (j = 1; j <= m; j++) {
                // Step 5
                cost = getCost(s, i - 1, t, j - 1);

                // Step 6
                d[i][j] = min3(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }

        // Step 7
        return d[n][m];
    }
  
  
    
    final public double min3(final double x, final double y, final double z) 
    {
        return Math.min(x, Math.min(y, z));
    }
  
    
    final public double getCost(final String str1, final int string1Index, final String str2, final int string2Index) 
    {
        if (str1.charAt(string1Index) == str2.charAt(string2Index)) 
            return 0.0;
        else
            return 1.0;
    }  
  
}
