/*
 * Music plugin to VDR (C++)
 *
 * (C) 2006 Morone
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>
#include <stdlib.h>
#include <fstream>
#include <vdr/plugin.h>

#include "i18n.h"
#include "visual.h"
#include "setup-mp3.h"
#include "vars.h"

cMP3VisLoader MP3VisLoader;

// --- cMP3VisLoader ---------------------------------------------------------------

cMP3VisLoader::cMP3VisLoader(void)
{

  Visualization = "4";
  ChannelsSA = "2";
  BandsSA = "30";
  ClrCoverBar = "0xFF000000";
  Background ="";
};


cMP3VisLoader::~cMP3VisLoader()
{
}

int cMP3VisLoader::LoadVis(const char *VisName)
{
  using namespace std;
  ifstream filestr;
  std::string line;
  std::string Value;
  std::string datei;
  std::string data;
  std::string visname;

  bool result=false;
  
  visname = VisName;

  Background = "";

  datei = config;
  data  = datei;
  data  = data  + "/visual/data/";
  datei = datei + "/visual/themes/";
  datei = datei + visname;


  dsyslog("music: Load visfile '%s'\n", datei.c_str());

  filestr.open (datei.c_str());
  if(filestr) {
    while (getline(filestr, line, '\n')) {
      int len = line.length();
      string::size_type pos = line.find ("<value>",0);

      if(pos != string::npos) {

        if (strstr(line.c_str(),"ID")) {
          Value   = line.substr(len -1, len);
          Visualization  = Value;
	  printf("music: ID=%s\n",Value.c_str());
	}
        else if (strstr(line.c_str(),"CHANNEL")) {
          Value   = line.substr(len -1, len);
          ChannelsSA  = Value;
	  printf("music: CHANNEL=%s\n",Value.c_str());
	}
        else if (strstr(line.c_str(),"BARS")) {
          pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    BandsSA = Value;
	    printf("music: BARS=%s\n",Value.c_str());
	  }     
        }    
        else if (strstr(line.c_str(),"COLOR")) {
          Value = line.substr(len -10, len);
          ClrCoverBar  = Value;
	  printf("music: COLOR=%s\n",Value.c_str());
	}
        else if (strstr(line.c_str(),"BACKGROUND")) {
          pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    data    = data + Value;
	    Background = data;
  	    printf("music: BACKGROUND=%s\n",data.c_str());
	  }     
        }    

      }
    }

  filestr.close();
  result = true;
  }

  return result;
}

void cMP3VisLoader::SetVis(void)
{
  MP3Setup.Visualization  = atoi(Visualization.c_str());
  MP3Setup.ChannelsSA     = atoi(ChannelsSA.c_str());
  MP3Setup.BandsSA        = atoi(BandsSA.c_str());
  MP3Setup.clrCoverBar    = strtoul(ClrCoverBar.c_str(), NULL, 16);
//  strncpy(coverpicture,Background.c_str(), sizeof(coverpicture));  
}

int cMP3VisLoader::StoreVis(const char *Vis)
{
  using namespace std;
  ifstream filestr;
  std::string line;
  std::string datei;
  std::string dateiout;
  std::string vis;
 
  bool res=false;
  
  vis = Vis;
  
  datei = config;
  datei = datei + "/visual/themes/";
  datei = datei + vis;
  
  dateiout = config;
  dateiout = dateiout + "/visual/themes/current.vis";
  
  if( FILE *f = fopen(dateiout.c_str(), "w")) {
    filestr.open(datei.c_str());
    if(filestr) {
      while (getline(filestr, line, '\n')) {
        line = line + "\n";
	fprintf(f, line.c_str());
      }	
      filestr.close();
    }
    res = true;
    fclose(f);
  }
  else
    res = false;
    
  return res;          
}
