/*
 * Music plugin to VDR (C++)
 *
 * (C) 2006 Morone
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

//#include <string>
#include <string.h>
#include <stdlib.h>
#include <fstream>
#include <vdr/plugin.h>

#include "i18n.h"
#include "skin.h"
#include "vars.h"

cMP3Skin MP3Skin;

// --- cMP3Skin ---------------------------------------------------------------

cMP3Skin::cMP3Skin(void)
{


clrBG               =0xEF2D435A;
clrTopBG            =0xCFF2A00C;
clrTopFG            =0xFFBABBC0;
clrCoverBG          =0xDF303F52;
clrCoverBar         =0xFF000000;
clrArtistBG         =0xDF303F52;
clrArtistFG         =0xFFBABBC0;
clrRatingFG         =0xFFCC0C0C;
clrPlayStatusBG     =0xDF303F52;
clrPlayStatusFG     =0xFFBABBC0;
clrInfoBG           =0xDF303F52;
clrInfoFG           =0xFFBABBC0;
clrProgressbarBG    =0xFFBABBC0; 
clrProgressbarFG    =0xEFA00404;
clrListTitle        =0xFFBABBC0;
clrListBG           =0xDF303F52;
clrListFG           =0xFFBABBC0;
clrSymbolBG         =0xDF303F52;
clrSymbolFG         =0xEF2D435A;
clrSymbolActive     =0xFFBABBC0;
clrRecordingActive  =0xFFBABBC0;
clrStatusBG         =0xCFF2A00C;
clrStatusFG         =0xFF000000;
clrStatusRed        =0xFFC00000;
clrStatusGreen      =0xFF00FF00;
clrStatusYellow     =0xFFE0E222;
clrStatusBlue       =0xFF3B96FD;
// FOR MPEGBACKGROUNDCOVER
  isMpeg                 = 0;
  rows                   = 7;
  osdwidth               = 600;
  osdheight              = 400;
  osdtop                 = 0;
  osdleft                = 0;
  mpgdif                 = 0;
  localbackground        = "";
  streambackground       = "";
  visbackground          = "";
  localcover             = "/music-default-cover.png";
  streamcover            = "/music-default-stream.png";
  reloadmpeg             = true;
  saonly				 = false;
};


cMP3Skin::~cMP3Skin()
{
}

int cMP3Skin::ParseSkin(const char *SkinName, bool ReloadMpeg)
{
  
  using namespace std;
  ifstream filestr;
  std::string line;
  std::string Value;
  std::string datei;
  std::string skinname;

  bool result=false;

  reloadmpeg = ReloadMpeg;
  
  skinname = SkinName;

  isMpeg = 0;
  localbackground = "";
  streambackground = "";
  visbackground = "";

  datei = config;
  datei = datei + "/themes/";
  datei = datei + skinname;

  dsyslog("music: Load themefile '%s'\n", datei.c_str());

  filestr.open (datei.c_str());
  if(filestr) {
    while (getline(filestr, line, '\n')) {
      int len = line.length();
      string::size_type pos = line.find ("<value>",0);

      if(pos != string::npos) {
        Value = line.substr(len -10, len);

        if      (strstr(line.c_str(),"clrBG"))              clrBG                 = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"clrTopBG"))           clrTopBG              = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrTopFG"))           clrTopFG              = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"clrCoverBG"))         clrCoverBG            = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrCoverBar"))        clrCoverBar           = strtoul(Value.c_str(), NULL,16);
         
        else if (strstr(line.c_str(),"clrArtistBG"))        clrArtistBG           = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrArtistFG"))        clrArtistFG           = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrRatingFG"))        clrRatingFG           = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"clrPlayStatusBG"))    clrPlayStatusBG       = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrPlayStatusFG"))    clrPlayStatusFG       = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrInfoBG"))          clrInfoBG             = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrInfoFG"))          clrInfoFG             = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrProgressbarBG"))   clrProgressbarBG      = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrProgressbarFG"))   clrProgressbarFG      = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"clrListTitle"))       clrListTitle          = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrListBG"))          clrListBG             = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrListFG"))          clrListFG             = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"clrSymbolBG"))        clrSymbolBG           = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrSymbolFG"))        clrSymbolFG           = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrSymbolActive"))    clrSymbolActive       = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrRecordingActive")) clrRecordingActive    = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"clrStatusBG"))        clrStatusBG           = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrStatusFG"))        clrStatusFG           = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrStatusRed"))       clrStatusRed          = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrStatusGreen"))     clrStatusGreen        = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrStatusYellow"))    clrStatusYellow       = strtoul(Value.c_str(), NULL,16);
        else if (strstr(line.c_str(),"clrStatusBlue"))      clrStatusBlue         = strtoul(Value.c_str(), NULL,16);

        else if (strstr(line.c_str(),"isMpeg")) {
          Value   = line.substr(len -1, len);
          isMpeg  = atoi(Value.c_str());
	 }
        else if (strstr(line.c_str(),"localcover")) {
          pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          localcover = Value.c_str();
	          }      
          }    
        else if (strstr(line.c_str(),"streamcover")) {
          pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          streamcover = Value.c_str();
	          }     
          }    
        else if (strstr(line.c_str(),"localbackground")) {
          pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          localbackground = Value.c_str();
	          }     
          }    
        else if (strstr(line.c_str(),"streambackground")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          streambackground = Value.c_str();
            }
		  }  
        else if (strstr(line.c_str(),"visbackground")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          visbackground = Value.c_str();
            }
		  }  
	    else if (strstr(line.c_str(),"rows")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          rows = atoi(Value.c_str());
            }
	        }  
        else if (strstr(line.c_str(),"osdwidth")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          osdwidth = atoi(Value.c_str());
            }
	        }  
        else if (strstr(line.c_str(),"osdheight")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          osdheight = atoi(Value.c_str());
            }
	        }  
        else if (strstr(line.c_str(),"osdtop")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          osdtop = atoi(Value.c_str());
            }
	        }  
        else if (strstr(line.c_str(),"osdleft")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          osdleft = atoi(Value.c_str());
            }
	        }  
        else if (strstr(line.c_str(),"mpgdif")) {
	        pos = line.rfind ("=",len);
          if(pos != string::npos) {
	          Value   = line.substr(pos +1,len);
	          mpgdif = atoi(Value.c_str());
          }
	      }  
      }
    }

    filestr.close();
    result = true;
  }

  return result;
}


int cMP3Skin::StoreSkin(const char *ThemeName)
{
  using namespace std;
  ifstream filestr;
  std::string line;
  std::string datei;
  std::string dateiout;
  std::string themename;

  bool res=false;
  
  themename = ThemeName;

  datei = config;
  datei = datei + "/themes/";
  datei = datei + ThemeName;

  dateiout = config;
  dateiout = dateiout + "/themes/current.colors";

  if( FILE *f = fopen(dateiout.c_str(), "w")) {
    filestr.open (datei.c_str());
    if(filestr) {
      while (getline(filestr, line, '\n')) {
        line = line + "\n";
        fprintf(f, line.c_str());
      }
      filestr.close();
    }
    res = true;
    fclose(f);
  }
  else
    res = false;

  return res;
}          
