#include <string.h>
#include <fstream>
#include <stdio.h>

#include <vdr/interface.h>
#include <vdr/menu.h>
#include <vdr/menuitems.h>
#include <vdr/plugin.h>

#include "options.h"
#include "setup-mp3.h"
#include "player-mp3.h"
#include "i18n.h"
#include "common.h"
#include "vars.h"

//#define MODE 0755

//---------------- cMP3Skiptime --------------------------------------------------------------------------------------------------------------------------
cMP3Skiptime::cMP3Skiptime(void)
:cOsdMenu(tr("Music: Change time to skip"),20)
{
  skiptime = MP3Setup.Jumptime;
  ShowDisplay();
}

cMP3Skiptime::~cMP3Skiptime()
{
}

void cMP3Skiptime::ShowDisplay(void)
{
  Clear();
  Add(new cMenuEditIntItem(tr("Seconds to skip"), &skiptime, 1, 120));
  SetHelp();
  Display();
}

void cMP3Skiptime::SetHelp()
{
  cOsdMenu::SetHelp(tr("Parent"), NULL, NULL, NULL);
}

eOSState cMP3Skiptime::Execute()
{
  MP3Setup.Jumptime = skiptime;

  return osBack;
}


eOSState cMP3Skiptime::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);

  if (state == osUnknown) {
    switch (Key) {
        case kOk:
	  state = Execute();
	  break;
        case kBack:
	  state = osBack; 
          break;
        case kRed:
        case kGreen:
	case kYellow:
        case kBlue:
	  break;

        default: state = osContinue;
    }
  }
  return state;
}



//---------------- cMP3AddCopyDir --------------------------------------------------------------------------------------------------------------------------
cMP3AddCopyDir::cMP3AddCopyDir(void)
:cOsdMenu(tr("Music: Add new target directory"),20)
{
  strncpy(AddDir, "/tmp", sizeof(AddDir));
  ShowDisplay();
}

cMP3AddCopyDir::~cMP3AddCopyDir()
{
}

void cMP3AddCopyDir::ShowDisplay(void)
{
  Clear();
  Add(new cMenuEditStrItem(tr("Directory to add"), AddDir, sizeof(AddDir) -1));
  SetHelp();
  Display();
}

void cMP3AddCopyDir::SetHelp()
{
  cOsdMenu::SetHelp(NULL);
}

void cMP3AddCopyDir::Save()
{
  static struct stat FileInfo;
  std::string datei;
  
  datei = config;
  datei = datei + "/" + langdir;
  datei = datei + "/data/copydir.dat";

  if(AddDir) {
    std::ofstream filestr(datei.c_str(), std::ios::app);
    if(filestr) {
      filestr <<AddDir<<std::endl;
      if(mkdir(AddDir, FileInfo.st_mode) == -1) {
        if(errno == EEXIST) esyslog("music: options: '%s' already exist", AddDir);
      }    
    }
    else
      esyslog("music: options: could not open '%s'", datei.c_str());	  
  }
}


eOSState cMP3AddCopyDir::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);

  if (state == osUnknown) {
    switch (Key) {
        case kOk:
	  Save();
	  state = osBack;
	  break;
        case kBack:
	  state = osBack; 
          break;
        case kRed:
        case kGreen:
	case kYellow:
        case kBlue:
	  break;

        default: state = osContinue;
    }
  }
  return state;
}


//---------------- cMP3CopyDir --------------------------------------------------------------------------------------------------------------------------
cMP3CopyDir::cMP3CopyDir(void)
:cOsdMenu(tr("Music: Goal listing"))
{

  GetCopyDirs();
}

cMP3CopyDir::~cMP3CopyDir()
{
}


void cMP3CopyDir::SetHelp()
{
  cOsdMenu::SetHelp(tr("Parent"),tr("Add"),tr("Delete"),tr("Execute"));
}


cOsdItem *cMP3CopyDir::Item(const char *dir, bool selectable)
{
  char *buf=0;
  asprintf(&buf, "%s", dir?dir:"");
  cOsdItem *item = new cOsdItem(buf, osUnknown, selectable);
  free(buf);
  Add(item); return item;
}

void cMP3CopyDir::GetCopyDirs()
{
  std::ifstream filestr;
  std::string datei;
  std::string line;
  std::string dirs;
  std::string buff;

  datei = config;
  datei = datei + "/" + langdir;
  datei = datei +"/data/copydir.dat";

  filestr.open(datei.c_str());
  
  if(filestr) {
    while ((getline(filestr,line,'\n'))) {
      Item(line.c_str(), true);
    }  
    filestr.close();

    Item("", false);
     
    buff = tr("Current goal listing: ");
    buff = buff + MP3Setup.CopyDir;
    Item( buff.c_str(), false);

  }
  else
    esyslog("music: options: ERROR: no directories defined! check '%s'", datei.c_str());

  SetHelp();
  Display();
}


int cMP3CopyDir::DeleteCopyDir()
{

  cOsdItem *item =(cOsdItem*)Get(Current());
  bool res = false;
  
  if(item){
    std::ifstream filestr;
    std::ofstream tfilestr;
    std::string datei;
    std::string tdatei;
    std::string line;
    std::string dline;

    dline = strdup(item->Text());
    datei = config;
    datei = datei + "/" + langdir;
    datei = datei + "/data/copydir.dat";
    tdatei = config; 
    tdatei = tdatei + "/" + langdir;
    tdatei = tdatei + "/data/tmp.dat";
    res = true;

    if(Interface->Confirm(tr("Remove ?"))) {
      filestr.open(datei.c_str(), std::ios::in);
      tfilestr.open(tdatei.c_str(), std::ios::out);

      if(filestr && tfilestr) {
        while(!filestr.eof()) {
          getline(filestr, line);
          if(!(line == dline) && (line > "")) 
            tfilestr << line << std::endl;
        }

        filestr.close();
        tfilestr.close();

        remove(datei.c_str());
        rename(tdatei.c_str(),datei.c_str());

        Clear();
        GetCopyDirs();
      }
      else res = false;
    }
  }
  return res;

}


eOSState cMP3CopyDir::Execute()
{
  cOsdItem *item = (cOsdItem*)Get(Current());
  
  if(item) {
    if(Interface->Confirm(tr("New goal listing ?"))) {
      std::string newdir;
      newdir  = strdup(item->Text());
      strncpy(MP3Setup.CopyDir, newdir.c_str(), sizeof(MP3Setup.CopyDir));

      return osBack;
    }
  }    

  return osContinue;
}


eOSState cMP3CopyDir::ProcessKey(eKeys Key)
{
  bool hadSubmenu = HasSubMenu();
  
  eOSState state = cOsdMenu::ProcessKey(Key);
  
//  if(hadSubmenu && !HasSubMenu()) return osBack; 
  if(hadSubmenu && !HasSubMenu()) { Clear(); GetCopyDirs(); } 
  

  if (state == osUnknown) {
    switch (Key) {
        case kBack:
        case kRed:
	  state = osBack; 
          break;
        case kOk:
	case kBlue:
	  return Execute();
	  break;
	case kYellow:
	  if(!DeleteCopyDir())
            return AddSubMenu(new cMenuText(tr("Error:"), tr("ERROR: Could not remove entry !"), fontFix));
	  break;  
        case kGreen:
          return AddSubMenu(new cMP3AddCopyDir());

        default: state = osContinue;
       
    }
  }
  return state;
}



//---------------- cMP3Options --------------------------------------------------------------------------------------------------------------------------

cMP3Options::cMP3Options(void)
:cOsdMenu(tr("Music: Quick settings"))
{
  SetHelp();

// 0
  if(MP3Setup.EnableShutDown)
    Item(tr("Disable system shutdown after player stopped"));
  else    
    Item(tr("Enable system shutdown after player stopped"));
// 1
  Item("--------------------------------------------------------------------------------");

// 2
  if(!mgr->ShuffleMode())
    Add(new cOsdItem(hk(tr("Activate Shufflemode"))));
  else
    Add(new cOsdItem(hk(tr("Deactivate Shufflemode"))));
// 3
  if(!mgr->LoopMode())
    Add(new cOsdItem(hk(tr("Activate Loopmode"))));
  else
    Add(new cOsdItem(hk(tr("Deactivate Loopmode"))));
// 4
  Item("--------------------------------------------------------------------------------");

// 5
    Add(new cOsdItem(hk(tr("Change directory where to copy tracks"))));
// 6
  Item("--------------------------------------------------------------------------------");
// 7
  Add(new cOsdItem(hk(tr("Change time to skip"))));



  Display();
}

cMP3Options::~cMP3Options()
{
}


cOsdItem *cMP3Options::Item(const char *text)
{
  char *buf=0;
  asprintf(&buf, "%s", text?text:"");
  cOsdItem *item = new cOsdItem(buf, osUnknown, true);
  free(buf);
  Add(item, osUnknown);
  if(strstr(item->Text(), "----------"))
    item->SetSelectable(false);
  else
    item->SetSelectable(true);    
  
  return item;
}

void cMP3Options::SetHelp() {
  cOsdMenu::SetHelp(tr("Parent"),NULL,NULL,NULL);
}


eOSState cMP3Options::Execute() {
  int current = Current();

// 0 // Enable AutoShutdown;;
  if (current==0) { 
    if(MP3Setup.EnableShutDown) {
      if(Interface->Confirm(tr("Disable automatic shutdown ?"))) {
        MP3Setup.EnableShutDown = 0;
        return AddSubMenu(new cMenuText(tr("Music: Automatic shutdown"), tr("Automatic shutdown disabled !"), fontFix));
      }
    }
    else {
      if(Interface->Confirm(tr("Enable automatic shutdown ?"))) {
        MP3Setup.EnableShutDown = 1;  
        return AddSubMenu(new cMenuText(tr("Music: Automatic shutdown"), tr("VDR will shutdown after player stopped !"), fontFix));
      }
    }
  }

// 2 // Shufflemode;;
  if (current == 2) {
    if(mgr->maxIndex <0) 
      return AddSubMenu(new cMenuText(tr("Error:"), tr("ERROR: No track(s) loaded !"), fontFix));
    mgr->ToggleShuffle();
    return osBack;
  }  


// 3 // Loopmode;;
  if (current == 3) {
    if(mgr->maxIndex <0) 
      return AddSubMenu(new cMenuText(tr("Error:"), tr("ERROR: No track(s) loaded !"), fontFix));
    mgr->ToggleLoop();
    return osBack;
  }  


// 5 // CopyDir;;
  if (current == 5) {
    return AddSubMenu(new cMP3CopyDir());
  }  

// 7 // CopyDir;;
  if (current == 7) {
    return AddSubMenu(new cMP3Skiptime());
  }  


  return osContinue;
}
	 

eOSState cMP3Options::ProcessKey(eKeys Key)
{
  bool hadSubmenu = HasSubMenu();
  
  eOSState state = cOsdMenu::ProcessKey(Key);
  
  if(hadSubmenu && !HasSubMenu()) return osBack; 
  
  if (state == osUnknown) {
    switch (Key) {
        case kBack:
        case kRed:
	  state = osBack; 
          break;
        case kOk:
	  return Execute();
	  break;
        default: state = osContinue;
    }
  }
  return state;
}


