/*
 * vdr-menuorg - A plugin for the Linux Video Disk Recorder
 * Copyright (c) 2007 - 2008 Tobias Grimm <vdr@e-tobi.net>
 * Copyright (c) 2007        Thomas Creutz <thomas.creutz@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * $Id: MenuConfigurationRepository.h 6969 2008-03-23 01:15:27Z svntobi $
 *
 */

#ifndef ___MENUCONFIGURARION_H
#define ___MENUCONFIGURATION_H

#include <string>
#include <vector>
#include <glibmm/ustring.h>

namespace xmlpp { class Element; }
class MenuNode;
class SubMenuNode;

class MenuConfigurationRepository
{
    private:
        static const std::string _dtd;
        std::string _configurationFileName;
        time_t _lastConfigFileModificationTime;
        SubMenuNode* _cachedMenuConfiguration;
        std::vector<std::string> _configuredPlugins;

    public:
        MenuConfigurationRepository(std::string menuFileName);
        ~MenuConfigurationRepository();
        SubMenuNode* Load(bool appendUnconfiguredPlugins);
        void Reset();

    private:
        bool ConfigFileHasBeenChange();
        time_t CurrentConfigFileModificationTime();
        void CreateMenuTree(const xmlpp::Element* menuRoot, SubMenuNode* menuNode);
        void AppendUnconfiguredPlugins(SubMenuNode* menuNode);
        std::string UnicodeToLocaleOrIso8859(Glib::ustring unicodeString);
        std::string GetTitle(const xmlpp::Element* node, std::string defaultValue);
        std::string GetAttributeValue(const xmlpp::Element* node, std::string name, std::string defaultValue);
};

#endif 
