/*
 * detector.h: frame size detection and signaling
 *
 * See the source file 'detector.c' for copyright information and
 * how to reach the author.
 *
 * $Id$
 */

#include <float.h>
#include <linux/videodev.h>
#include <vdr/thread.h>
#include <vdr/device.h>
#include "avards_services.h"

#define MAXSTRING 100

class cWSSoverdrive
{
private:
   int fdDevVbi;
   int lastWssData;
   char *szVbiDevice;
public:
   cWSSoverdrive(const char* szDevice);
   ~cWSSoverdrive();
   bool OpenVbiDevice(void);
   void CloseVbiDevice(void);
   bool SetWSS(int);
};

struct buffer {
        void *                  start;
        size_t                  length;
};

class cDetector : public cThread
{
private:
   virtual void Action(void);
   cCondWait Wait;
   char szDevDvbVideo[MAXSTRING];
   char szDevDvbFrontend[MAXSTRING];
   struct video_mmap mmapVideo;
   struct video_mbuf mbufVideo;
   int naAspectInfo;
   int lastAspectInfo;
   int lastHeight, lastWidth;
   int top, height;
   bool wasPAL;
   cWSSoverdrive *wssoverdrive;

   bool InitDevices(const char* DevDvbVideo, const char* DevVideo);
   void UninitDevices(void);
   int AnalyzeFrame(void);
   unsigned char *pbVideo;

   // for v4l2:
   int fdDevVideo;
   int fdDevDvbVideo;
   int xioctl(int fd, int request, void *arg);
   bool init_devices(const char* pszDevVideo, const char* pszDevDvbVideo);
   void uninit_devices(void);
   //tmp:
   bool start_capturing(void);
   bool stop_capturing();
   int read_frame();
   void mainloop();

   buffer * buffers;
   unsigned int n_buffers;

public:
   cDetector(void);
   ~cDetector();
   bool Active() { return Running(); }
   bool StartUp();
   void Stop();
#if APIVERSNUM < 10504
   bool GetMaxOSDSize(avards_MaxOSDsize_v1_0 *);
#endif
   const char *GetWSSModeString();
   void GetVideoFormat(avards_CurrentVideoFormat_v1_0 *);
};
