#ifndef __RECORDING_PATCH_OSD_CONTROLLER_H
#define __RECORDING_PATCH_OSD_CONTROLLER_H

class cDvbPlayer;
namespace RecordingPatch {

  class iRecordingPlugin
  {
  public:
    virtual ~iRecordingPlugin() {};
    virtual void Receive(unsigned char DataIdentifier, unsigned char* Data, int Length) = 0;
  };
  
  class cRecordingController
  {
  public:
    cRecordingController();
    ~cRecordingController();
    void Subscribe(unsigned char DataIdentifier, iRecordingPlugin* plugin);
    void Unsubscribe(unsigned char DataIdentifer, iRecordingPlugin* plugin);
    bool isExtendedPacket(unsigned char* Data, int Length);
    void Receive(unsigned char* Data, int Length);
  private:
    iRecordingPlugin** listeners;
  };
  extern cRecordingController RecordingController;

}
#endif
