/*
 * i18n.c: 'EnigmaNG' skin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 *
 * Translations submitted by:
 *  - English:    Andreas Mair <andreas _@_ vdr-developer.org>
 *  - Deutsch:    Andreas Mair <andreas _@_ vdr-developer.org>
 *  - Italiano:   Gringo <vdr-italian _@_ tiscali.it>
 *  - Nederlands: dorpsgek @vdr-portal.de
 *  - Franais:   Patrice Staudt <pat @vdr-portal.de>
 *  - Finnish:    Rolf Ahrenberg <rofafor @vdr-portal.de>
 *  - Polski:     ???
 *  - Espaol:    ???
 *  - Svenska:    ???
 *  - Russian:    SergArb @vdr-portal.de / neptunvasja @vdr-portal.de
 *  - Eesti:      ???
 *  - Dansk:      ???
 *  - Czech:      ???
 *
 */

#include "common.h"
#include "i18n.h"

const tI18nPhrase Phrases[] = {
  {"en_US",             // English
   "de_DE",             // Deutsch
   "sl_SI",             // Slovenski
   "it_IT",             // Italiano
   "nl_NL",             // Nederlands
   "pt_PT",             // Portugus
   "fr_FR",             // Franais  Patrice Staudt 18.05.2007
   "no_NO",             // Norsk
   "fi_FI",             // suomi (Finnish)
   "pl_PL",             // Polski
   "es_ES",             // Espaol
   "el_GR",             //  (Greek)
   "sv_SE",             // Svenska
   "ro_RO",             // Romn
   "hu_HU",             // Magyar
   "ca_AD",             // Catal
   "ru_RU",             //  (Russian)
   "hr_HR",             // Hrvatski
   "et_EE",             // Eesti
   "da_DK",             // Dansk
   "cs_CZ",             // esky (Czech)
   },
  {"Monday",       // English  Patrice Staudt 21.06.2007 Alle Sprache umgesetzt von LC_TIME
   "Montag",       // Deutsch
   "ponedeljek",   // Slovenski
   "Luned",       // Italiano
   "maandag",      // Nederlands
   "Segunda",      // Portugus
   "Lundi",        // Franais
   "Manday",       // Norsk
   "Maanantai",    // suomi (Finnish)
   "poniedziaek", // Polski
   "Lunes",        // Espaol
   "",      //  (Greek)
   "Mndag",       // Svenska
   "Luni",         // Romn
   "Htf",        // Magyar
   "Dilluns",      // Catal
   "",  //  (Russian)
   "Ponedjeljak",  // Hrvatski
   "Esmaspev",    // Eesti
   "Mandag",       // Dansk
   "Pondl",      // esky (Czech)
   },
  {"Tuesday",      // English
   "Dienstag",     // Deutsch
   "Torek",        // Slovenski
   "Marted",      // Italiano
   "Dinsdag",      // Nederlands
   "Tera",        // Portugus
   "Mardi",        // Franais
   "Tirsday",      // Norsk
   "Tiistai",      // suomi (Finnish)
   "Wtorek",       // Polski
   "Martes",       // Espaol
   "",        //  (Greek)
   "Tisdag",       // Svenska
   "Mari",        // Romn
   "Kedd",         // Magyar
   "Dimarts",      // Catal
   "",      //  (Russian)
   "Utorak",       // Hrvatski
   "Teisipev",    // Eesti
   "Tirsdag",      // Dansk
   "ter",        // esky (Czech)
   },
  {"Wednesday",    // English
   "Mittwoch",     // Deutsch
   "sreda",        // Slovenski
   "mercoled",    // Italiano
   "woensdag",     // Nederlands
   "Quarta",       // Portugus
   "Mercredi",     // Franais
   "Onsday",       // Norsk
   "Keskiviikko",  // suomi (Finnish)
   "roda",        // Polski
   "Mircoles",    // Espaol
   "",      //  (Greek)
   "Onsdag",       // Svenska
   "Miercuri",     // Romn
   "Szerda",       // Magyar
   "Dimecres",     // Catal
   "",        //  (Russian)
   "Srijeda",      // Hrvatski
   "Kolmapev",    // Eesti
   "Onsdag",       // Dansk
   "Steda",       // esky (Czech)
   },
  {"Thursday",     // English
   "Donnerstag",   // Deutsch
   "etrtek",      // Slovenski
   "Gioved",      // Italiano
   "Donderdag",    // Nederlands
   "Quinta",       // Portugus
   "Jeudi",        // Franais
   "Torsdag",      // Norsk
   "Torstai",      // suomi (Finnish)
   "Czwartek",     // Polski
   "Jueves",       // Espaol
   "",       //  (Greek)
   "Torsdag",      // Svenska
   "Joi",          // Romn
   "Cstrtk",    // Magyar
   "Dijous",       // Catal
   "",      //  (Russian)
   "etvrtak",     // Hrvatski
   "Neljapev",    // Eesti
   "Torsdag",      // Dansk
   "tvrtek",      // esky (Czech)
   },
  {"Friday",       // English
   "Freitag",      // Deutsch
   "Petek",        // Slovenski
   "Venerd",      // Italiano
   "Vrijdag",      // Nederlands
   "Sexta",        // Portugus
   "Vendredi",     // Franais
   "Fredag",       // Norsk
   "Perjantai",    // suomi (Finnish)
   "Pitek",       // Polski
   "Viernes",      // Espaol
   "",    //  (Greek)
   "Fredag",       // Svenska
   "Vineri",       // Romn
   "Pntek",       // Magyar
   "Divendres",    // Catal
   "",      //  (Russian)
   "Petak",        // Hrvatski
   "Reede",        // Eesti
   "Fredag",       // Dansk
   "Ptek",        // esky (Czech)
   },
  {"Saturday",     // English
   "Samstag",      // Deutsch
   "Sobota",       // Slovenski
   "Sabato",       // Italiano
   "Zaterdag",     // Nederlands
   "Sbado",       // Portugus
   "Samedi",       // Franais
   "Lrdag",       // Norsk
   "Lauantai",     // suomi (Finnish)
   "Sobota",       // Polski
   "Sbado",       // Espaol
   "",      //  (Greek)
   "Lrdag",       // Svenska
   "Smbt",      // Romn
   "Szombat",      // Magyar
   "Dissabte",     // Catal
   "",      //  (Russian)
   "Subota",       // Hrvatski
   "Laupev",      // Eesti
   "Lrdag",       // Dansk
   "Sobota",       // esky (Czech)
   },
  {"Sunday",       // English
   "Sonntag",      // Deutsch
   "Nedelja",      // Slovenski
   "Domenica",     // Italiano
   "Zondag",       // Nederlands
   "Domingo",      // Portugus
   "Dimanche",     // Franais
   "Sndag",       // Norsk
   "Sunnuntai",    // suomi (Finnish)
   "Niedziela",    // Polski
   "Domingo",      // Espaol
   "",      //  (Greek)
   "Sndag",       // Svenska
   "Duminic",     // Romn
   "Vasrnap",     // Magyar
   "Diumenge",     // Catal
   "",  //  (Russian)
   "Nedjelja",     // Hrvatski
   "Phapev",     // Eesti
   "Sndag",       // Dansk
   "Nedle",       // esky (Czech)
   },
  {"EnigmaNG skin",             // English
   "EnigmaNG Oberflche",       // Deutsch
   "",                          // Slovenski
   "Interfaccia EnigmaNG",      // Italiano
   "EnigmaNG skin",             // Nederlands
   "",                          // Portugus
   "Skin EnigmaNG",             // Franais
   "",                          // Norsk
   "EnigmaNG-ulkoasu",          // suomi (Finnish)
   "Skin EnigmaNG",             // Polski
   "Piel EnigmaNG",             // Espaol
   "",                          //  (Greek)
   "EnigmaNG-temat",            // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "EnigmaNG ",             //  (Russian)
   "",                          // Hrvatski
   "EnigmaNG kest",             // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"EnigmaNG",                  // English
   "EnigmaNG",                  // Deutsch
   "",                          // Slovenski
   "EnigmaNG",                  // Italiano
   "EnigmaNG",                  // Nederlands
   "",                          // Portugus
   "EnigmaNG",                  // Franais
   "",                          // Norsk
   "EnigmaNG",                  // suomi (Finnish)
   "EnigmaNG",                  // Polski
   "EnigmaNG",                  // Espaol
   "",                          //  (Greek)
   "EnigmaNG",                  // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "EnigmaNG",                  //  (Russian)
   "",                          // Hrvatski
   "EnigmaNG",                  // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"min",                       // English
   "min",                       // Deutsch
   "",                          // Slovenski
   "min",                       // Italiano
   "min",                       // Nederlands
   "",                          // Portugus
   "min",                       // Franais
   "",                          // Norsk
   "min",                       // suomi (Finnish)
   "min",                       // Polski
   "min",                       // Espaol
   "",                          //  (Greek)
   "min",                       // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                       //  (Russian)
   "",                          // Hrvatski
   "min",                       // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Stereo",                    // English
   "Stereo",                    // Deutsch
   "",                          // Slovenski
   "Stereo",                    // Italiano
   "Stereo",                    // Nederlands
   "",                          // Portugus
   "Stro",                    // Franais
   "",                          // Norsk
   "Stereo",                    // suomi (Finnish)
   "Stereo",                    // Polski
   "Estereo",                   // Espaol
   "",                          //  (Greek)
   "Stereo",                    // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "Stereo",                    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Left",                      // English
   "Links",                     // Deutsch
   "",                          // Slovenski
   "Sinistra",                  // Italiano
   "Links",                     // Nederlands
   "",                          // Portugus
   "Gauche",                    // Franais
   "",                          // Norsk
   "Vasen",                     // suomi (Finnish)
   "W lewo",                    // Polski
   "Izquierda",                 // Espaol
   "",                          //  (Greek)
   "Vnster",                   // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                     //  (Russian)
   "",                          // Hrvatski
   "Vasak",                     // Eesti
   "",                          // Danske
   "",                          // esky (Czech)
   },
  {"Right",                     // English
   "Rechts",                    // Deutsch
   "",                          // Slovenski
   "Destra",                    // Italiano
   "Rechts",                    // Nederlands
   "",                          // Portugus
   "Droite",                    // Franais
   "",                          // Norsk
   "Oikea",                     // suomi (Finnish)
   "W prawo",                   // Polski
   "Derecha",                   // Espaol
   "",                          //  (Greek)
   "Hger",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "Parem",                     // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Mute",                      // English
   "Stumm",                     // Deutsch
   "",                          // Slovenski
   "Muto",                      // Italiano
   "Geluid uit",                // Nederlands
   "",                          // Portugus
   "Muet",                      // Franais
   "",                          // Norsk
   "Mykistetty",                // suomi (Finnish)
   "Wycisz",                    // Polski
   "Silenciar",                 // Espaol
   "",                          //  (Greek)
   "Dmpa",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ". ",                //  (Russian)
   "",                          // Hrvatski
   "Hletu",                   // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Volume",                    // English
   "Lautstrke",                // Deutsch
   "",                          // Slovenski
   "Volume",                    // Italiano
   "Volume",                    // Nederlands
   "",                          // Portugus
   "Volume",                    // Franais
   "",                          // Norsk
   "nenvoimakkuus",           // suomi (Finnish)
   "Gono",                  // Polski
   "Volumen",                   // Espaol
   "",                          //  (Greek)
   "Volym",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                 //  (Russian)
   "",                          // Hrvatski
   "Helitugevus",               // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show channel logos",        // English
   "Kanal-Logos anzeigen",      // Deutsch
   "",                          // Slovenski
   "Mostra loghi canali",       // Italiano
   "Toon kanaallogo's",         // Nederlands
   "",                          // Portugus
   "Afficher logos des chanes", // Franais
   "",                          // Norsk
   "Nyt kanavalogot",         // suomi (Finnish)
   "Pokazuj logo kanau",       // Polski
   "Mostrar los logos de los canales",  // Espaol
   "",                          //  (Greek)
   "Visa kanallogotyper",       // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "Kanalilogo nitamine",      // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Identify channel by",       // English
   "  Kanal-Identifikation durch",        // Deutsch
   "",                          // Slovenski
   "  Identifica canale per",     // Italiano
   "  Kanaalidentificatie door",  // Nederlands
   "",                          // Portugus
   "  Identifier chane par",     // Franais
   "",                          // Norsk
   "  Tunnista kanava",           // suomi (Finnish)
   "  Rozpoznaj kana po",        // Polski
   "  Identificar el canal por...",       // Espaol
   "",                          //  (Greek)
   "  Identifiera kanal med",     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "    ",       //  (Russian)
   "",                          // Hrvatski
   "  Kanali tuvastamise meetod", // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"name",                      // English
   "Name",                      // Deutsch
   "",                          // Slovenski
   "nome",                      // Italiano
   "naam",                      // Nederlands
   "",                          // Portugus
   "Nom",                       // Franais
   "",                          // Norsk
   "nimest",                   // suomi (Finnish)
   "nazwa",                     // Polski
   "Nombre",                    // Espaol
   "",                          //  (Greek)
   "namn",                      // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                  //  (Russian)
   "",                          // Hrvatski
   "nimi",                      // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"data",                      // English
   "ID",                        // Deutsch
   "",                          // Slovenski
   "dati",                      // Italiano
   "data",                      // Nederlands
   "",                          // Portugus
   "Donne",                    // Franais
   "",                          // Norsk
   "tiedoista",                 // suomi (Finnish)
   "parametry",                 // Polski
   "Datos",                     // Espaol
   "",                          //  (Greek)
   "data",                      // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "andmed",                    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channel logo cache size",   // English
   "Gre des Logo-Caches",     // Deutsch
   "",                          // Slovenski
   "Dimensione cache dei loghi",// Italiano
   "Kanaallogo cache",          // Nederlands
   "",                          // Portugus
   "Taille du cache des logos",  // Franais
   "",                          // Norsk
   "Vlimuistin koko kanavalogoille",   // suomi (Finnish)
   "Rozmiar cache dla logo kanau",     // Polski
   "Tamao de la cache de los logos",   // Espaol
   "",                          //  (Greek)
   "Cachestorlek fr logotyper",        // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  o ",  //  (Russian)
   "",                          // Hrvatski
   "Kanalilogo vahemlu suurus",        // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Button$Flush cache",        // English
   "Cache leeren",              // Deutsch
   "",                          // Slovenski
   "Pulisci cache",             // Italiano
   "Cache legen",               // Nederlands
   "",                          // Portugus
   "Supprimer cache",           // Franais
   "",                          // Norsk
   "Tyhjenn",                  // suomi (Finnish)
   "Oprnij cache",            // Polski
   "Limpiar la cache",          // Espaol
   "",                          //  (Greek)
   "Tm cachen",                // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",              //  (Russian)
   "",                          // Hrvatski
   "Thjenda",                  // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Flushing channel logo cache...",    // English
   "Logo-Cache wird geleert...",        // Deutsch
   "",                          // Slovenski
   "Pulendo la cache...",       // Italiano
   "Kanaallogo cache legen...", // Nederlands
   "",                          // Portugus
   "Suppression du cache...",   // Franais
   "",                          // Norsk
   "Tyhjennetn vlimuistia...",       // suomi (Finnish)
   "Oprniam cache logo kanau...",    // Polski
   "Limpiando la cache...",     // Espaol
   "",                          //  (Greek)
   "Tmmer cachen...",          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ...",                          //  (Russian)
   "",                          // Hrvatski
   "Kanalilogo vahemlu thjendamine...",       // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Languages",                 // English
   "Sprachen",                  // Deutsch
   "",                          // Slovenski
   "Lingue",                    // Italiano
   "Talen",                     // Nederlands
   "",                          // Portugus
   "Langues",                   // Franais
   "",                          // Norsk
   "Kielet",                    // suomi (Finnish)
   "Jzyki",                    // Polski
   "Lenguajes",                 // Espaol
   "",                          //  (Greek)
   "Sprk",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "Keeled",                    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Auxiliary information",     // English
   "Zusatzinformation",         // Deutsch
   "",                          // Slovenski
   "Informazione ausiliare",    // Italiano
   "Hulp informatie",           // Nederlands
   "",                          // Portugus
   "Information auxiliare",     // Franais
   "",                          // Norsk
   "Listiedot",                // suomi (Finnish)
   "Informacje pomocnicze",     // Polski
   "Informacin auxiliar",      // Espaol
   "",                          //  (Greek)
   "Extrainformation",          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ". ",          //  (Russian)
   "",                          // Hrvatski
   "Lisainfo",                  // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show auxiliary information",        // English
   "Zusatzinfo anzeigen",       // Deutsch
   "",                          // Slovenski
   "Mostra informazione ausiliare",     // Italiano
   "Toon hulp informatie",      // Nederlands
   "",                          // Portugus
   "Afficher informations auxiliaires",   // Franais
   "",                          // Norsk
   "Nyt listiedot",          // suomi (Finnish)
   "Pokazuj informacje pomocnicze",     // Polski
   "Mostrar informacin auxiliar",      // Espaol
   "",                          //  (Greek)
   "Visa extrainformation",     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " . ",      //  (Russian)
   "",                          // Hrvatski
   "Lisainfo nitamine",        // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show remaining/elapsed time",          // English
   "Zeige abgel./restl. Zeit",             // Deutsch
   "",                          // Slovenski
   "Mostra tempo rimasto/trascorso",       // Italiano
   "Toon resterend/gedane tijd",  // Nederlands
   "",                          // Portugus
   "Afficher le temps coul/restant", // Franais
   "",                          // Norsk
   "Nyt tapahtuman aika",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ./. ",     //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"remaining",                 // English
   "restliche",                 // Deutsch
   "",                          // Slovenski
   "rimasto",                   // Italiano
   "resterend",                   // Nederlands
   "",                          // Portugus
   "restant",                   // Franais
   "",                          // Norsk
   "jljell oleva",            // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                 //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"elapsed",                   // English
   "abgelaufene",               // Deutsch
   "",                          // Slovenski
   "trascorso",                 // Italiano
   "gedane",                // Nederlands
   "",                          // Portugus
   "coul",                    // Franais
   "",                          // Norsk
   "kulunut",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                  //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show info area in main menu",            // English
   "Infobereich im Hauptmen",               // Deutsch
   "",                          // Slovenski
   "Mostra area info nel menu principale",   // Italiano
   "Info in hoofdmenu",         // Nederlands
   "",                          // Portugus
   "Surface d'infos dans le menu principal",  // Franais
   "",                          // Norsk
   "Nyt infoalue pvalikossa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " .   . ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show marker in lists",            // English
   "Symbol vor Listeneintrgen",      // Deutsch
   "",                          // Slovenski
   "Mostra indicatore negli elenchi", // Italiano
   "Markering in lijsten tonen", // Nederlands
   "",                          // Portugus
   "Marque devant les listes",  // Franais
   "",                          // Norsk
   "Nyt valintasymboli",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show progressbar",          // English
   "Fortschrittbalken anzeigen",        // Deutsch
   "",                          // Slovenski
   "Mostra barra avanzamento",  // Italiano
   "Progressiebalk tonen",      // Nederlands
   "",                          // Portugus
   "Afficher barre de progression",     // Franais
   "",                          // Norsk
   "Nyt aikajana",            // suomi (Finnish)
   "Pokazuj pasek postpu",     // Polski
   "Mostrar barra de progreso", // Espaol
   "",                          //  (Greek)
   "Visa framsteg",             // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "Edenemisriba nitamine",    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show symbols",              // English
   "Symbole anzeigen",          // Deutsch
   "",                          // Slovenski
   "Mostra simboli",            // Italiano
   "Symbolen tonen",            // Nederlands
   "",                          // Portugus
   "Afficher symbole",          // Franais
   "",                          // Norsk
   "Nyt symbolit",            // suomi (Finnish)
   "Pokazuj symbole",           // Polski
   "Mostrar smbolos",          // Espaol
   "",                          //  (Greek)
   "Visa symboler",             // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",                          //  (Russian)
   "",                          // Hrvatski
   "Smbolite nitamine",       // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show VPS",                  // English
   "VPS anzeigen",              // Deutsch
   "",                          // Slovenski
   "Mostra VPS",                // Italiano
   "VPS tonen",                 // Nederlands
   "",                          // Portugus
   "Afficher le VPS",           // Franais
   "",                          // Norsk
   "Nyt VPS-tieto",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " VPS",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"WARNING",                   // English
   "WARNUNG",                   // Deutsch
   "",                          // Slovenski
   "ATTENZIONE",                // Italiano
   "WAARSCHUWING",              // Nederlands
   "",                          // Portugus
   "ATTENTION",                 // Franais
   "",                          // Norsk
   "VAROITUS",                  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "ÿ",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Timer conflict",            // English
   "Timerkonflikt",             // Deutsch
   "",                          // Slovenski
   "Conflitto timer",           // Italiano
   "Timerconflict",             // Nederlands
   "",                          // Portugus
   "Conflit de programmation",  // Franais
   "",                          // Norsk
   "Pllekkinen ajastin",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Timer conflicts",           // English
   "Timerkonflikte",            // Deutsch
   "",                          // Slovenski
   "Conflitti timer",           // Italiano
   "Timerconflicten",                          // Nederlands
   "",                          // Portugus
   "Conflits de programmation", // Franais
   "",                          // Norsk
   "Pllekkisi ajastimia",   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",        //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"TIMERS",                    // English
   "TIMER",                     // Deutsch
   "",                          // Slovenski
   "TIMER",                     // Italiano
   "TIMER",                     // Nederlands
   "",                          // Portugus
   "PROGRAMMATION",             // Franais
   "",                          // Norsk
   "AJASTIMET",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "°",                   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"RERUNS OF THIS SHOW",       // English
   "WIEDERHOLUNGEN",            // Deutsch
   "",                          // Slovenski
   "RIPETI QUESTO SHOW",        // Italiano
   "HERHALINGEN",               // Nederlands
   "",                          // Portugus
   "REPETITION",                // Franais
   "",                          // Norsk
   "TOISTUVAT TAPAHTUMAT",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "¾",                //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"*** Invalid Channel ***",   // English
   "*** Ungltiger Kanal ***",  // Deutsch
   "",                          // Slovenski
   "*** Canale non valido ***", // Italiano
   "*** Ongeldig Kanaal ***",   // Nederlands
   "",                          // Portugus
   "*** Chane non valable ***",  // Franais
   "",                          // Norsk
   "*** Virheellinen kanava ***", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "***   ***",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Size",                      // English
   "Gre",                     // Deutsch
   "",                          // Slovenski
   "Dimensione",                // Italiano
   "Grootte",                   // Nederlands
   "",                          // Portugus
   "Taille",                    // Franais
   "",                          // Norsk
   "Koko",                      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Mute",                      // English
   "Stumm",                     // Deutsch
   "",                          // Slovenski
   "Muto",                      // Italiano
   "Geluid uit",                // Nederlands
   "Muet",                      // Portugus
   "",                          // Franais
   "",                          // Norsk
   "Mykistetty",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ".",                 //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Volume",                    // English
   "Lautstrke",                // Deutsch
   "",                          // Slovenski
   "Volume",                    // Italiano
   "Volume",                    // Nederlands
   "",                          // Portugus
   "Volume",                    // Franais
   "",                          // Norsk
   "nenvoimakkuus",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show symbols in lists",     // English
   "Symbole in Listen",         // Deutsch
   "",                          // Slovenski
   "Mostra simboli negli elenchi",       // Italiano
   "Symbolen in lijsten",       // Nederlands
   "",                          // Portugus
   "Symboles dans les listes",   // Franais
   "",                          // Norsk
   "Nyt tapahtumien symbolit",// suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Try 8bpp single area",      // English
   "Einen 8bpp Bereich versuchen", // Deutsch
   "",                          // Slovenski
   "Prova area singola a 8bpp", // Italiano
   "Op 8bpp bereik testen",     // Nederlands
   "",                          // Portugus
   "Essayer une surface  8bpp",// Franais
   "",                          // Norsk
   "Suosi yht 8bpp kuva-aluetta", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show flags",                // English
   "Fahnen anzeigen",           // Deutsch
   "",                          // Slovenski
   "Mostra segni",              // Italiano
   "Vlaggen tonen",             // Nederlands
   "",                          // Portugus
   "Afficher drapeau",          // Franais
   "",                          // Norsk
   "Nyt liput",               // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",            //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show symbols in menu",      // English
   "Symbole im Men",           // Deutsch
   "",                          // Slovenski
   "Mostra simboli nel menu",   // Italiano
   "Symbolen in menu",          // Nederlands
   "",                          // Portugus
   "Symboles dans le menu",     // Franais
   "",                          // Norsk
   "Nyt valikkosymbolit",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"never",                     // English
   "nie",                       // Deutsch
   "",                          // Slovenski
   "mai",                       // Italiano
   "nooit",                     // Nederlands
   "",                          // Portugus
   "jamais",                    // Franais
   "",                          // Norsk
   "ei koskaan",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"always",                    // English
   "immer",                     // Deutsch
   "",                          // Slovenski
   "sempre",                    // Italiano
   "Altijd",                    // Nederlands
   "",                          // Portugus
   "toujours",                  // Franais
   "",                          // Norsk
   "aina",                      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"percent",                   // English
   "Prozent",                   // Deutsch
   "",                          // Slovenski
   "percentuale",               // Italiano
   "procent",                   // Nederlands
   "",                          // Portugus
   "Pourcentage",               // Franais
   "",                          // Norsk
   "prosentti",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"if exists",                 // English
   "wenn vorhanden",            // Deutsch
   "",                          // Slovenski
   "se esiste",                 // Italiano
   "wanneer aanwezig",          // Nederlands
   "",                          // Portugus
   "si existant",               // Franais
   "",                          // Norsk
   "jos olemassa",              // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",            //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Number of Reruns",          // English
   "Anzahl Wiederholungen",     // Deutsch
   "",                          // Slovenski
   "Numero di ripetizioni",     // Italiano
   "aantal herhalingen",        // Nederlands
   "",                          // Portugus
   "Nombre de rptitions",     // Franais
   "",                          // Norsk
   "Uusintojen lukumr",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",     //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Use Subtitle for reruns",   // English
   "Verw. Untertitel fr Wdh.", // Deutsch
   "",                          // Slovenski
   "Usa sottotitolo per ripetizioni",         // Italiano
   "Gebr. ondertitlel voor herh.", // Nederlands
   "",                          // Portugus
   "Utilise sous-titres pour les rptitions", // Franais
   "",                          // Norsk
   "Kyt lyhytt kuvausta uusinnoille", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ".   ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show timer conflicts",      // English
   "Timerkonflikte anzeigen",   // Deutsch
   "",                          // Slovenski
   "Mostra conflitti timer",    // Italiano
   "Timerconflict tonen",       // Nederlands
   "",                          // Portugus
   "Afficher les conflits de programmation", // Franais
   "",                          // Norsk
   "Nyt pllekkiset ajastimet", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Timer check",               // English
   "berwachung",               // Deutsch
   "",                          // Slovenski
   "Verifica timer",            // Italiano
   "Monitoren",                 // Nederlands
   "",                          // Portugus
   "Observation de la programmation", // Franais
   "",                          // Norsk
   "Ajastimien valvonta",       // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",         //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"EPGSearch",                 // English
   "EPGSearch",                 // Deutsch
   "",                          // Slovenski
   "Ricerca EPG",               // Italiano
   "EPGsearch",                 // Nederlands
   "",                          // Portugus
   "Recherche EPG",             // Franais
   "",                          // Norsk
   "EPGSearch",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Logos & Symbols",           // English
   "Logos & Symbole",           // Deutsch
   "",                          // Slovenski
   "Loghi e simboli",           // Italiano
   "Logo's & Symbolen",         // Nederlands
   "",                          // Portugus
   "Logos et symboles",         // Franais
   "",                          // Norsk
   "Logot ja symbolit",         // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " & ",        //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"use size.vdr only",         // English
   "nur size.vdr verwenden",    // Deutsch
   "",                          // Slovenski
   "usa solo size.vdr",         // Italiano
   "alleen size.vdr gebruiken", // Nederlands
   "",                          // Portugus
   "utiliser seulement size.vdr",  // Franais Patrice Staudt 29.03.2007
   "",                          // Norsk
   "vain jos size.vdr",         // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  size.vdr",  //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show recording's size",     // English
   "Aufnahmengre anzeigen",   // Deutsch
   "",                          // Slovenski
   "Mostra dimensione delle registrazioni",      // Italiano
   "Opnamegrootte tonen",       // Nederlands
   "",                          // Portugus
   "Afficher la taille des enregistrements",   // Franais
   "",                          // Norsk
   "Nyt tallenteen koko",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",    //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"pixel algo",                // English
   "Pixel-Algorithmus",         // Deutsch
   "",                          // Slovenski
   "algoritmo pixel",           // Italiano
   "pixelalgoritme",            // Nederlands
   "",                          // Portugus
   "Algorithme pixel",          // Franais
   "",                          // Norsk
   "nytteistys",               // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"ratio algo",                // English
   "Ratio-Algorithmus",         // Deutsch
   "",                          // Slovenski
   "algoritmo ratio",           // Italiano
   "algoritmeratio",            // Nederlands
   "",                          // Portugus
   "Algorithme ratio",          // Franais
   "",                          // Norsk
   "skaalaus",                  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"zoom image",                // English
   "Zoomen",                    // Deutsch
   "",                          // Slovenski
   "ingrandisci immagine",      // Italiano
   "zoomen",                    // Nederlands
   "",                          // Portugus
   "Agrandir image",            // Franais
   "",                          // Norsk
   "zoomaus",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                 //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show event/recording images",     // English
   "Bilder in EPG/Aufnahmendetails",  // Deutsch
   "",                                // Slovenski
   "Mostra immagini evento/registrazione",      // Italiano
   "EPG/opnamedetails tonen",         // Nederlands
   "",                                // Portugus
   "Images dans les EPG et dtails d'enregistrements",     // Franais
   "",                                // Norsk
   "Nyt kuvat listietovalikossa",  // suomi (Finnish)
   "",                                // Polski
   "",                                // Espaol
   "",                                //  (Greek)
   "",                                // Svenska
   "",                                // Romn
   "",                                // Magyar
   "",                                // Catal
   "  EPG",               //  (Russian)
   "",                                // Hrvatski
   "",                                // Eesti
   "",                                // Dansk
   "",                                // esky (Czech)
   },
  {"  Resize images",           // English
   "  Bildberechnung benutzt",  // Deutsch
   "",                          // Slovenski
   "  Ridimensiona immagini",   // Italiano
   "  Aanpassen beeldgrootte",  // Nederlands
   "",                          // Portugus
   "  Redimensionne les images",  // Franais
   "",                          // Norsk
   "  Muokkaa kuvien kokoa",    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",    //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Image width",             // English
   "  Bildbreite",              // Deutsch
   "",                          // Slovenski
   "  Lunghezza immagine",      // Italiano
   "  Beeldbreedte",            // Nederlands
   "",                          // Portugus
   "  Largeur",                 // Franais
   "",                          // Norsk
   "  Kuvien leveys",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Image height",            // English
   "  Bildhhe",                // Deutsch
   "",                          // Slovenski
   "  Altezza immagine",        // Italiano
   "  Beeldhoogte",             // Nederlands
   "",                          // Portugus
   "  Hauteur",                 // Franais
   "",                          // Norsk
   "  Kuvien korkeus",          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Image format",            // English
   "  Bildformat",              // Deutsch
   "",                          // Slovenski
   "  Formato immagine",        // Italiano
   "  Beeldformaat",            // Nederlands
   "",                          // Portugus
   "  Format d'image",          // Franais
   "",                          // Norsk
   "  Kuvaformaatti",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Full title width",          // English
   "Volle Titelbreite",         // Deutsch
   "",                          // Slovenski
   "Lunghezza titolo completo", // Italiano
   "Volle titelbreedte",        // Nederlands
   "",                          // Portugus
   "Largeur totale pour le titre", // Franais
   "",                          // Norsk
   "Levit otsikkopalkki",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#ifdef USE_PLUGIN_MAILBOX
  {"Show mail icon",            // English
   "Zeige Mail-Icon",           // Deutsch
   "",                          // Slovenski
   "Mostra icona email",        // Italiano
   "Mail-ikoon tonen",          // Nederlands
   "",                          // Portugus
   "Afficher l'icne courriel",  // Franais
   "",                          // Norsk
   "Nyt shkpostikuvake",    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  . ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"only if new mail present",  // English
   "nur bei neuer Mail",        // Deutsch
   "",                          // Slovenski
   "solo se presenti nuove email",          // Italiano
   "alleen bij nieuwe mail",    // Nederlands
   "",                          // Portugus
   "juste lors d'un courriel",  // Franais
   "",                          // Norsk
   "jos uutta postia",          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",  //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#endif
#ifndef DISABLE_ANIMATED_TEXT
  {"Animated Text",             // English
   "Bewegter Text",             // Deutsch
   "",                          // Slovenski
   "Testo animato",             // Italiano
   "Geanimeerde tekst",         // Nederlands
   "",                          // Portugus
   "Texte dfilant",            // Franais
   "",                          // Norsk
   "Tekstien elvinti",        // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Enable",                    // English
   "Verwenden",                 // Deutsch
   "",                          // Slovenski
   "Abilita",                   // Italiano
   "Toelaten",                  // Nederlands
   "",                          // Portugus
   "Permettre",                 // Franais
   "",                          // Norsk
   "Kyt elvinti",          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scoll behaviour",         // English
   "  Scroll-Verhalten",        // Deutsch
   "",                          // Slovenski
   "  Comportamento scorrimento",// Italiano
   "  Scroll gedrag",            // Nederlands
   "",                          // Portugus
   "  Comportement de dfilement", // Franais
   "",                          // Norsk
   "  Vieritystapa",            // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"to the left",               // English
   "nach links",                // Deutsch
   "",                          // Slovenski
   "verso la sinistra",         // Italiano
   "naar links",                // Nederlands
   "",                          // Portugus
   "vers la gauche",            // Franais
   "",                          // Norsk
   "vasemmalle",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"left and right",            // English
   "links und rechts",          // Deutsch
   "",                          // Slovenski
   "sinistra e destra",         // Italiano
   "links en rechts",           // Nederlands
   "",                          // Portugus
   "gauche et droite",          // Franais
   "",                          // Norsk
   "edestakaisin",              // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll delay (ms)",       // English
   "  Scroll-Verzgerung (ms)", // Deutsch
   "",                          // Slovenski
   "  Ritardo scorrimento (ms)",// Italiano
   "  Scrollvertraging (ms)",   // Nederlands
   "",                          // Portugus
   "  Dlai de dfilement (ms)",// Franais
   "",                          // Norsk
   "  Vierityksen viive (ms)",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll pause (ms)",       // English
   "  Scroll-Pause (ms)",       // Deutsch
   "",                          // Slovenski
   "  Pausa scorrimento (ms)",  // Italiano
   "  Scrollpause (ms)",        // Nederlands
   "",                          // Portugus
   "  Pause de dfilement (ms)",// Franais
   "",                          // Norsk
   "  Vierityksen tauko (ms)",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Blink pause (ms)",        // English
   "  Blink-Pause (ms)",        // Deutsch
   "",                          // Slovenski
   "  Pausa lampeggiante (ms)", // Italiano
   "  Blinkpauze (ms)",         // Nederlands
   "",                          // Portugus
   "  Pause de clignotement (ms)",// Franais
   "",                          // Norsk
   "  Vilkutuksen tauko (ms)",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll OSD title",        // English
   "  OSD Titel scrollen",      // Deutsch
   "",                          // Slovenski
   "  Scorri titolo OSD",       // Italiano
   "  OSD titel scrollen",      // Nederlands
   "",                          // Portugus
   "  Dfilement dans le titre du OSD",  // Franais
   "",                          // Norsk
   "  Vierit valikon otsikkoa",// suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll info area",        // English
   "  Infobereich scrollen",    // Deutsch
   "",                          // Slovenski
   "  Scorri informazioni area",// Italiano
   "  Infobereik scrollen",     // Nederlands
   "",                          // Portugus
   "  Barre de dfilement dans la surface info",   // Franais
   "",                          // Norsk
   "  Vierit infoaluetta",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll active list items",  // English
   "  Aktive Listenzeile scrollen", // Deutsch
   "",                          // Slovenski
   "  Scorri valori lista attivi",// Italiano
   "  Lijst aktieve punten scrollen",  // Nederlands
   "",                          // Portugus
   "  Barre de dfilement dans la liste active",  // Franais
   "",                          // Norsk
   "  Vierit aktiivista valintaa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll other items",      // English
   "  Andere Bereiche scrollen", // Deutsch
   "",                          // Slovenski
   "  Scorri altri valori",     // Italiano
   "  Ander bereik scrollen",   // Nederlands
   "",                          // Portugus
   "  Barre de dfilement dans d'autres parties",  // Franais
   "",                          // Norsk
   "  Vierit muita alueita",   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#endif
  {"  Show symbols in menu",    // English
   "  Symbole im Men",         // Deutsch
   "",                          // Slovenski
   "  Mostra simboli nel menu", // Italiano
   "  Symbolen in menu",   // Nederlands
   "",                          // Portugus
   "  dans le menu",  		// Franais
   "",                          // Norsk
   "  Nyt symbolit valikossa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Show symbols in replay",  // English
   "  Symbole bei der Wiedergabe", // Deutsch
   "",                          // Slovenski
   "  Mostra simboli in esecuzione",// Italiano
   "  Symbolen bij weergave",   // Nederlands
   "",                          // Portugus
   "  dans lecture",		// Franais
   "",                          // Norsk
   "  Nyt symbolit toistettaessa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Show symbols in messages",  // English
   "  Symbole bei den Meldungen", // Deutsch
   "",                          // Slovenski
   "  Mostra simboli nei messaggi",// Italiano
   "  Symbolen bij berichten",  // Nederlands
   "",                          // Portugus
   "  dans les messages", 	// Franais
   "",                          // Norsk
   "  Nyt symbolit viesteiss", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Show symbols in audio",   // English
   "  Symbole bei Audio",       // Deutsch
   "",                          // Slovenski
   "  Mostra simboli in audio", // Italiano
   "  Symbolen bij audio",      // Nederlands
   "",                          // Portugus
   "  dans audio",        	// Franais
   "",                          // Norsk
   "  Nyt symbolit nivalikossa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Fonts",                     // English
   "Fonts",                     // Deutsch
   "",                          // Slovenski
   "Caratteri",                 // Italiano
   "Fonts",                     // Nederlands
   "",                          // Portugus
   "Les polices",               // Franais
   "",                          // Norsk
   "Kirjasintyypit",            // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"OSD title",                 // English
   "OSD Titel",                 // Deutsch
   "",                          // Slovenski
   "Titolo OSD",                // Italiano
   "OSD titel",                 // Nederlands
   "",                          // Portugus
   "Titre OSD",                 // Franais
   "",                          // Norsk
   "Valikon otsikko",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Date",                      // English
   "Datum",                     // Deutsch
   "",                          // Slovenski
   "Data",                      // Italiano
   "Datum",                     // Nederlands
   "",                          // Portugus
   "Date",                      // Franais
   "",                          // Norsk
   "Pivys",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Messages",                  // English
   "Meldungen",                 // Deutsch
   "",                          // Slovenski
   "Messaggi",                  // Italiano
   "Meldingen",                 // Nederlands
   "",                          // Portugus
   "Message",                   // Franais
   "",                          // Norsk
   "Viestit",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Help keys",                 // English
   "Farb-Tasten",               // Deutsch
   "",                          // Slovenski
   "Tasti d'aiuto",             // Italiano
   "Help toetsen",              // Nederlands
   "",                          // Portugus
   "Touche couleur",            // Franais
   "",                          // Norsk
   "Vrinppimet",             // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channelinfo: title",        // English
   "Kanalinfo: Titel",          // Deutsch
   "",                          // Slovenski
   "Info canale: titolo",       // Italiano
   "Kanaalinfo: titel",         // Nederlands
   "",                          // Portugus
   "Chane info: titre ",        // Franais
   "",                          // Norsk
   "Kanavatieto: ohjelman nimi",// suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channelinfo: subtitle",     // English
   "Kanalinfo: Untertitel",     // Deutsch
   "",                          // Slovenski
   "Info canale: sottotitolo",  // Italiano
   "Kanaalinfo: ondertitel",    // Nederlands
   "",                          // Portugus
   "Chane info: sous-titres",    // Franais
   "",                          // Norsk
   "Kanavatieto: ohjelman kuvaus", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channelinfo: language",     // English
   "Kanalinfo: Sprache",        // Deutsch
   "",                          // Slovenski
   "Info canale: lingua",       // Italiano
   "Kanaalinfo: taal",          // Nederlands
   "",                          // Portugus
   "Chane info: langue",       // Franais
   "",                          // Norsk
   "Kanavatieto: kieli",        // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"List items",                // English
   "Listen",                    // Deutsch
   "",                          // Slovenski
   "Elenco",                    // Italiano
   "Lijsten",                   // Nederlands
   "",                          // Portugus
   "Liste",                     // Franais
   "",                          // Norsk
   "Listat",                    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: timers title",   // English
   "Infobereich: Timer Titel",  // Deutsch
   "",                          // Slovenski
   "Info area: titoli timer",   // Italiano
   "Infobereik: Timertitel",    // Nederlands
   "",                          // Portugus
   "Barre d'information: Titre Progammation",   // Franais
   "",                          // Norsk
   "Infoalue: ajastimen otsikko", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: timers text",    // English
   "Infobereich: Timer Text",   // Deutsch
   "",                          // Slovenski
   "Info area: testo timer",    // Italiano
   "Infobereik: Timertekst",    // Nederlands
   "",                          // Portugus
   "Barre d'information: Text programmation",   // Franais
   "",                          // Norsk
   "Infoalue: ajastimen leipteksti", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: warning title",  // English
   "Infobereich: Warnung Titel", // Deutsch
   "",                          // Slovenski
   "Info area: titolo avviso",  // Italiano
   "Infobereik: waarschuwing titel", // Nederlands
   "",                          // Portugus
   "Barre d'information: avertissement titre",   // Franais
   "",                          // Norsk
   "Infoalue: varoituksen otsikko",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: warning text",   // English
   "Infobereich: Warnung Text", // Deutsch
   "",                          // Slovenski
   "Info area: testo avviso",   // Italiano
   "Infobereik: waarschuwing tekst",  // Nederlands
   "",                          // Portugus
   "Barre d'information: texte d'avertissement",      // Franais
   "",                          // Norsk
   "Infoalue: varoituksen leipteksti", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: title",            // English
   "Details: Titel",            // Deutsch
   "",                          // Slovenski
   "Dettagli: titolo",          // Italiano
   "Details: titel",            // Nederlands
   "",                          // Portugus
   "Dtails: Titre",            // Franais
   "",                          // Norsk
   "Listiedot: ohjelman nimi", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: subtitle",         // English
   "Details: Untertitel",       // Deutsch
   "",                          // Slovenski
   "Dettagli: sottotitolo",     // Italiano
   "Details: ondertitel",       // Nederlands
   "",                          // Portugus
   "Dtails: Sous-titre",       // Franais
   "",                          // Norsk
   "Listiedot: ohjelman kuvaus", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: date",             // English
   "Details: Datumszeile",      // Deutsch
   "",                          // Slovenski
   "Dettagli: data",            // Italiano
   "Details: datum",            // Nederlands
   "",                          // Portugus
   "Dtails: date",             // Franais
   "",                          // Norsk
   "Listiedot: pivmr",    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: text",             // English
   "Details: Text",             // Deutsch
   "",                          // Slovenski
   "Dettagli: testo",           // Italiano
   "Details: tekst",            // Nederlands
   "",                          // Portugus
   "Dtails: Texte",             // Franais
   "",                          // Norsk
   "Listiedot: leipteksti",   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Replay: times",             // English
   "Wiedergabe: Zeiten",        // Deutsch
   "",                          // Slovenski
   "Esecuzione: volte",         // Italiano
   "Weergave: tijden",          // Nederlands
   "",                          // Portugus
   "Rejouer : priodes",        // Franais
   "",                          // Norsk
   "Toisto: kellonajat",        // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Default OSD Font",          // English
   "Std. OSD Font",             // Deutsch
   "",                          // Slovenski
   "Carattere OSD predefinito", // Italiano
   "Standaard OSDfont",         // Nederlands
   "",                          // Portugus
   "OSD standard",              // Franais
   "",                          // Norsk
   "oletuskirjasintyyppi",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Default Fixed Size Font",   // English
   "Std. Schrift mit fester Breite", // Deutsch
   "",                          // Slovenski
   "Carattere dimensione fissa pred.",// Italiano
   "Standaardwaarde font",     // Nederlands
   "",                          // Portugus
   "Largeur fixe standard",     // Franais
   "",                          // Norsk
   "tasavlinen kirjasintyyppi", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Default Small Font",        // English
   "Std. kleine Schrift",       // Deutsch
   "",                          // Slovenski
   "Carattere piccolo pred.",   // Italiano
   "Standaard klein font",      // Nederlands
   "",                          // Portugus
   "Petite police standard",           // Franais
   "",                          // Norsk
   "pieni kirjasintyyppi",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channel:",                  // English
   "Kanal:",                    // Deutsch
   "",                          // Slovenski
   "Canale:",                   // Italiano
   "Kanaal:",                   // Nederlands
   "",                          // Portugus
   "Chane:",                   // Franais
   "",                          // Norsk
   "Kanava:",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Search pattern:",           // English
   "Suchmuster:",               // Deutsch
   "",                          // Slovenski
   "Modello di ricerca:",       // Italiano
   "Zoekpatroon:",              // Nederlands
   "",                          // Portugus
   "Modle de recherche",       // Franais
   "",                          // Norsk
   "Hakutapa:",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"No timer check",            // English
   "Ohne berwachung",          // Deutsch
   "",                          // Slovenski
   "Nessun timer verifica",     // Italiano
   "Geen controle",             // Nederlands
   "",                          // Portugus
   "Sans surveillance",         // Franais
   "",                          // Norsk
   "Ei valvontaa",              // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"General",                   // English
   "Allgemein",                 // Deutsch
   "",                          // Slovenski
   "Generale",                  // Italiano
   "Algemeen",                  // Nederlands
   "",                          // Portugus
   "Gnralit",                // Franais
   "",                          // Norsk
   "Yleiset",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Name",                      // English
   "Name",                      // Deutsch
   "",                          // Slovenski
   "Nome",                      // Italiano
   "Naam",                      // Nederlands
   "",                          // Portugus
   "Nom",                       // Franais
   "",                          // Norsk
   "Nimi",                      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Width",                     // English
   "Weite",                     // Deutsch
   "",                          // Slovenski
   "Larghezza",                 // Italiano
   "Breedte",                   // Nederlands
   "",                          // Portugus
   "Largeur",                   // Franais
   "",                          // Norsk
   "Leveys",                    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Button$Set",                // English
   "ndern",                    // Deutsch
   "",                          // Slovenski
   "Imposta",                   // Italiano
   "Veranderen",                // Nederlands
   "",                          // Portugus
   "Changer",                   // Franais
   "",                          // Norsk
   "Aseta",                     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"TrueType Font",             // English
   "TrueType Schrift",          // Deutsch
   "",                          // Slovenski
   "Carattere TrueType",        // Italiano
   "TrueType Font",             // Nederlands
   "",                          // Portugus
   "TrueType",                  // Franais
   "",                          // Norsk
   "TrueType-kirjasin",         // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"No TTF support!",            // English
   "TTF nicht untersttzt!",    // Deutsch
   "",                          // Slovenski
   "Nessun supporto TTF!",      // Italiano
   "TTF niet ondersteund!",   // Nederlands
   "",                          // Portugus
   "Les polices TrueType ne sont pas supportes!", // Franais
   "",                          // Norsk
   "Ei TrueType-kirjasintyyppi tukea!", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Fixed Font",                // English
   "Schrift mit fester Breite", // Deutsch
   "",                          // Slovenski
   "Carattere fisso",           // Italiano
   "Vaste waarde font",         // Nederlands
   "",                          // Portugus
   "Police avec une largeur fixe", // Franais
   "",                          // Norsk
   "Tasavlinen kirjasintyyppi", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#ifdef USE_PLUGIN_AVARDS
  {"Dynamic OSD size",          // English
   "Dynamische OSD-Gre",      // Deutsch
   "",                          // Slovenski
   "Dimensione OSD dinamica",   // Italiano
   "Dynamisch OSDgrootte",      // Nederlands
   "",                          // Portugus
   "Taille OSD dynamique",      // Franais
   "",                          // Norsk
   "Vaihtuva kuvaruutunytn koko", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#endif
  {"No TrueType fonts installed!",          // English
   "Keine TrueType Schriften installiert!", // Deutsch
   "",                                      // Slovenski
   "Nessun carattere TrueType installato!", // Italiano
   "Geen TrueType fonten geinstalleerd!",   // Nederlands
   "",                                      // Portugus
   "Il n'y a pas de police TrueType d'install!",  // Franais
   "",                                      // Norsk
   "TrueType-kirjasintyyppej ei lydy!",   // suomi (Finnish)
   "",                                      // Polski
   "",                                      // Espaol
   "",                                      //  (Greek)
   "",                                      // Svenska
   "",                                      // Romn
   "",                                      // Magyar
   "",                                      // Catal
   "",                                      //  (Russian)
   "",                                      // Hrvatski
   "",                                      // Eesti
   "",                                      // Dansk
   "",                                      // esky (Czech)
   },
  {NULL}
};
// vim:et:sw=2:ts=2:
