/*
 * MP3/MPlayer plugin to VDR (C++)
 *
 * (C) 2001-2005 Stefan Huelswitt <s.huelswitt@gmx.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#ifndef ___DVB_MP3_H
#define ___DVB_MP3_H

#include <vdr/thread.h>
#include <vdr/player.h>

#include <mad.h>
#include <fftw3.h>

/*
 * Macros.
 */ 
#define PCM_FRAME_SIZE 2048

#define SPAN_SET_PCM_DATA_ID "Span-SetPcmData-v1.0"
#define SPAN_GET_BAR_HEIGHTS_ID "Span-GetBarHeights-v1.0"
// SpanData
struct Span_SetPcmData_1_0 {
	int length; // the length of the PCM-data
	int *data;	// the PCM-Data as 32-bit int, however only the lower 16-bit are used
				// and you have to take care to hand in such data!
};

struct Span_GetBarHeights_v1_0 {
	int bands;						// number of bands to compute
	int *barHeights;				// the heights of the bars of the two channels combined
	int *barHeightsLeftChannel;		// the heights of the bars of the left channel
	int *barHeightsRightChannel;	// the heights of the bars of the right channel
	int *volumeLeftChannel;			// the volume of the left channels
	int *volumeRightChannel;		// the volume of the right channels
	int *volumeBothChannels;		// the combined volume of the two channels
	const char *name;				// name of the plugin that wants to get the data
									// (must be unique for each client!)
	int falloff;                    // bar falloff value
	// barPeaks[peak-value]
	// it is planned to support peaks falling as if they were subject to gravity
	// NOT supported yet!
	int *barPeaks;
};

// -------------------------------------------------------------------

class cRingBufferFrame;
class cFrame;
class cPlayList;
class cSong;
class cSongInfo;
class cBackgroundScan;
class cDecoder;
class cOutput;
class cOutputDvb;
class cShuffle;

// -------------------------------------------------------------------

class cMP3PlayInfo {
public:
  char Title[64], Artist[64], Album[64], Genre[32], Comment[128], SMode[32], Filename[256];
  int Year, SampleFreq, Bitrate, MaxBitrate, Rating;
  int Num, MaxNum;
  // not in hash
  bool Loop, Shuffle;
  int Hash;
  };

// -------------------------------------------------------------------

class cPlayManager : public cThread {
private:
  cMutex listMutex;
  cCondVar fgCond, bgCond;
  cList<cSong> list;
//  cSong *curr;
//  int currIndex, maxIndex;
  //
  cSong *play;
  bool playNew, eol;
  //
  cShuffle *shuffle;
  bool shuffleMode, loopMode;
  //
  cSong *scan;
  bool stopscan, throttle, pass2, release;
  //
  virtual void Action(void);
  void NoScan(cSong *nono);
  void NoPlay(cSong *nono);
  void ThrottleWait(void);
  int length;
public:
  cPlayManager(void);
  ~cPlayManager();
  // Control interface (to be called from frontend thread only!)
  int currIndex, maxIndex;
  int currindex;
  cSong *curr;
  bool ShuffleMode(void) { return shuffleMode; }
  bool LoopMode(void) { return loopMode; }
  void Flush(void);
  bool SaveList(const char *pl_filename, bool full);
  void DeleteRecord(int Sidx);
  void EmptyPlaylist(void);
  void Add(cPlayList *pl);
  bool Next(void);
  bool Prev(void);
  void Goto(int num);
  void ToggleShuffle(void);
  void ToggleLoop(void);
  bool Info(int num, cMP3PlayInfo *info);
  void Halt(void);
  // Player interface (to be called from player thread only!)
  cSong *Current(void);
  bool NewCurrent(void);
  bool NextCurrent(void);
  void RateSong(int rate);
  int GetListLength(void);
  void Release(void);
  void Throttle(bool thr);
  };

extern cPlayManager *mgr;

// -------------------------------------------------------------------

class cMP3Player : public cPlayer, cThread {
friend class cOutputDvb;
private:
  bool active, started;
  int statusMode;
  cRingBufferFrame *ringBuffer;
  cMutex playModeMutex;
  cCondVar playModeCond;
 //
  int total;
  cDecoder *decoder;
  cOutput *output;
  cFrame *rframe, *pframe, *iframe;
  enum ePlayMode { pmPlay, pmStopped, pmPaused, pmStartup };
  ePlayMode playMode;
  enum eState { msStart, msStop, msDecode, msNormalize, msResample, msOutput, msError, msEof, msWait, msRestart };
  eState state;
  bool levelgood, isStream;
  char artist[256];
  unsigned int dvbSampleRate;
  
  
  void Empty(void);
  void StopPlay(void);
  void SetPlayMode(ePlayMode mode);
  void WaitPlayMode(ePlayMode mode, bool inv);
protected:
  virtual void Activate(bool On);
  virtual void Action(void);
public:

  cMP3Player(void);
  virtual ~cMP3Player();
  int playindex;
  void Pause(void);
  void Play(void);
  void UpdateCache(void);
  bool PrevCheck(void);
  void SkipSeconds(int secs);
  virtual bool GetIndex(int &Current, int &Total, bool SnapToIFrame=false);
  virtual bool GetReplayMode(bool &Play, bool &Forward, int &Speed);
  bool Active(void) { return active; }
  bool IsStream(void) { return isStream; }
  char *CheckImage(char *fileName);
  void LoadImage(const char *fullname);
  void CheckMpeg(void);
  void ShowMpeg(void);
  void send_pes_packet(unsigned char *data, int len, int timestamp);
  int StatusMode(void) {return statusMode;}
  void DeleteTrack(bool All);
  };
  


#endif //___DVB_MP3_H
