#include <string>
#include <stdlib.h>
#include <getopt.h>
#include <strings.h>
#include <typeinfo>

#include <vdr/menuitems.h>
#include <vdr/menu.h>
#include <vdr/status.h>
#include <vdr/plugin.h>
#include <vdr/osd.h>
#include <vdr/interface.h>
#include <vdr/skins.h>

#include "mp3control.h"
#include "common.h"
#include "skin.h"
#include "setup.h"
#include "setup-mp3.h"
#include "data-mp3.h"
#include "player-mp3.h"
#include "menu.h"
#include "menu-async.h"
#include "decoder.h"
#include "decoder-mp3.h"
#include "i18n.h"
#include "stream.h"

#include "symbols/shuffle.xpm"
#include "symbols/loop.xpm"
#include "symbols/stop.xpm"
#include "symbols/play.xpm"
#include "symbols/pause.xpm"
#include "symbols/rew.xpm"
#include "symbols/fwd.xpm"
#include "symbols/copy.xpm"

#include "symbols/delstar.xpm"
#include "symbols/rate00.xpm"
#include "symbols/rate05.xpm"
#include "symbols/rate10.xpm"
#include "symbols/rate15.xpm"
#include "symbols/rate20.xpm"
#include "symbols/rate25.xpm"
#include "symbols/rate30.xpm"
#include "symbols/rate35.xpm"
#include "symbols/rate40.xpm"
#include "symbols/rate45.xpm"
#include "symbols/rate50.xpm"




#ifdef DEBUG
#include <mad.h>
#endif

#define eDvbColor int
#define INLINE


cBitmap cMP3Control::bmShuffle(shuffle_xpm);
cBitmap cMP3Control::bmLoop(loop_xpm);
cBitmap cMP3Control::bmStop(stop_xpm);
cBitmap cMP3Control::bmPlay(play_xpm);
cBitmap cMP3Control::bmPause(pause_xpm);
cBitmap cMP3Control::bmRew(rew_xpm);
cBitmap cMP3Control::bmFwd(fwd_xpm);
cBitmap cMP3Control::bmCopy(copy_xpm);


cBitmap cMP3Control::bmDelStar(delstar_xpm);
cBitmap cMP3Control::bmRate00(rate00_xpm);
cBitmap cMP3Control::bmRate05(rate05_xpm);
cBitmap cMP3Control::bmRate10(rate10_xpm);
cBitmap cMP3Control::bmRate15(rate15_xpm);
cBitmap cMP3Control::bmRate20(rate20_xpm);
cBitmap cMP3Control::bmRate25(rate25_xpm);
cBitmap cMP3Control::bmRate30(rate30_xpm);
cBitmap cMP3Control::bmRate35(rate35_xpm);
cBitmap cMP3Control::bmRate40(rate40_xpm);
cBitmap cMP3Control::bmRate45(rate45_xpm);
cBitmap cMP3Control::bmRate50(rate50_xpm);



// --- cAsyncStatus ------------------------------------------------------------
cAsyncStatus asyncStatus;

cAsyncStatus::cAsyncStatus(void)
{
  text=0;
  changed=false;
}

cAsyncStatus::~cAsyncStatus()
{
  free((void *)text);
}

void cAsyncStatus::Set(const char *Text)
{
  Lock();
  free((void *)text);
  text=Text ? strdup(Text) : 0;
  changed=true;
  Unlock();
}

const char *cAsyncStatus::Begin(void)
{
  Lock();
  return text;
}

void cAsyncStatus::Finish(void)
{
  changed=false;
  Unlock();
}

// --- cMP3Control -------------------------------------------------------------
cMP3Control::cMP3Control(void)
:cControl(player=new cMP3Player)
,cmdMenu(NULL),rateMenu(NULL)
{
  jumpactive=jumphide=copyfile=deletetrack=deletetracks=recordstream=false;
  skipfwd=skiprew=showcoveronly=visible=shown=selecting=selecthide=statusActive=refresh=false;
  ShowSA=true;
  showbuttons=0;  
  timeoutShow=0;
  lastkeytime=number=0;
  visualization=channelsSA=bandsSA=x0=x1=y0=y1=y2=y3=y4=y5=depth=0;
  lastMode=0;
  framesPerSecond=SecondsToFrames(1);
  if(!osd) osd=0;
  font=cFont::GetFont(fontOsd);

#if VDRVERSNUM >= 10338
  cStatus::MsgReplaying(this,"MP3",0,true);
#else
  cStatus::MsgReplaying(this,"MP3");
#endif
  coversize = 0;
}

cMP3Control::~cMP3Control()
{
#ifdef HAVE_VDR_SPEZIAL
    cPlugin *graphtft=cPluginManager::GetPlugin("graphtft");
    if(graphtft) cStatus::MsgImageFile("");
#else
    cPlugin *graphtft=cPluginManager::GetPlugin("graphtft");
    if(graphtft) graphtft->SetupParse("CoverImage", "");
#endif

  if(cmdMenu) {delete cmdMenu;}
  cmdMenu = NULL;

  if(rateMenu) {delete rateMenu;}
  rateMenu = NULL;
  delete lastMode;
  Hide();
  Stop();
}

void cMP3Control::Stop(void)
{
  if(recordstream==true) {cmdMenu->StopRecord();}
#if VDRVERSNUM >= 10338
  cStatus::MsgReplaying(this,0,0,false);
#else
  cStatus::MsgReplaying(this,0);
#endif
  delete player; player=0;
  mgr->Halt();
  mgr->Flush(); //XXX remove later
}

bool cMP3Control::SetPlayList(cPlayList *plist)
{
  bool res;
  char *buff;

  cControl *control=cControl::Control();
  // is there a running MP3 player?
  if(control && typeid(*control)==typeid(cMP3Control)) {
    // add songs to running playlist
    mgr->Add(plist);
    res=true;
    }
  else {
    mgr->Flush();
    mgr->Add(plist);
    cControl::Launch(new cMP3Control);
    res=false;
    }

//  asprintf(&buff, "%s/%s", cPlugin::ConfigDirectory(i18n_name), "playlists/current.m3u");
  asprintf(&buff, "%s/%s", BaseSource, "@current.m3u");
  if(mgr->SaveList(buff, false)) {
    d(printf("MP3ctrl->Refreshed playlist: %s\n", buff));
    }
  else
    d(printf("MP3ctrl->Couldn't refresh current playlist"));
  free(buff);

  delete plist;
  return res;
}

void cMP3Control::ShowTimed(int Seconds)
{
  if(!visible) {
    ShowProgress(true);
    if(Seconds>0) timeoutShow=time(0)+Seconds;
    }
}

void cMP3Control::Hide(void)
{
  HideStatus();
  if (cmdMenu) {
    delete cmdMenu;
    cmdMenu=NULL;
    }

  if (rateMenu) {
    delete rateMenu;
    rateMenu=NULL;
    }


  if(visible) {
    delete osd; osd=0;
    visible = false;
    SetNeedsFastResponse(visible);
    }
}

void cMP3Control::ShowStatus(bool force)
{

  if (cmdMenu || rateMenu) return;

  if((asyncStatus.Changed() || (force && !statusActive))) {
    const char *text=asyncStatus.Begin();
    if(text) {
         if(!statusActive) { osd->SaveRegion( 30, lh +fh +fh/2 +fw, osdwidth -128 -30 -6*fw, lh + 3*fh +fw); }
          osd->DrawText(30, lh + fh +fh/2 +fw, text, clrInfoTitleFG1, clrInfoBG2, font, osdwidth -128 -30 -6*fw, fh, taCenter);
        osd->Flush();
      statusActive=true;
      }
    else
      HideStatus();
    asyncStatus.Finish();
    }

}

void cMP3Control::HideStatus(void)
{
  if(statusActive) {
      osd->RestoreRegion();
      osd->Flush();
      }
  statusActive=false;
}

void cMP3Control::LoadCover(void)
{
  int bmpcolors;
  int w1=120;
  int h1=120;

  if(MP3Setup.EnableSpectrumAnalyzer)
    bmpcolors = 14;
  else
    bmpcolors = 15;    

  if (coverpicture < " " )
    d(printf("MP3ctrl-> DEBUG: no CoverImage"))
  else {
    font=cFont::GetFont(fontOsd);
    fw=6;
    fh=27;

    if(showcoveronly) {
      switch(coversize) {
        case 0:
	    bmpcolors = 252;
	    w1 = 120;
	    h1 = 120;
            osd->DrawRectangle(0 , 0, w1 -1, h1 -1, clrBlack);
            osd->DrawText( 0, h1 -fh, "Load...", clrWhite, clrBlack, cFont::GetFont(fontSml), w1, fh, taCenter);
            Flush();
	  break;  
	case 1:  
	    bmpcolors = 252;
	    w1 = 274;
	    h1 = 274;
            osd->DrawRectangle(0 , 0, w1 -1, h1 -1, clrBlack);
            osd->DrawText( 0, h1 -fh, "Load...", clrWhite, clrBlack, cFont::GetFont(fontSml), w1, fh, taCenter);
            Flush();
	  break;
	case 2:
	    bmpcolors = 252;
	    w1 = 300;
	    h1 = 256;
            osd->DrawRectangle(0 , 0, w1 -1, h1 -1, clrBlack);
            osd->DrawText( 0, h1 -fh, "Load...", clrWhite, clrBlack, cFont::GetFont(fontSml), w1, fh, taCenter);
            Flush();
	  break;
	case 3:
	    bmpcolors = 252;
	    w1 = Setup.OSDWidth;
	    h1 = Setup.OSDHeight;
            osd->DrawRectangle(0 , 0, w1 -1, h1 -1, clrBlack);
            osd->DrawText( 0, h1 -fh, "Load...", clrWhite, clrBlack, cFont::GetFont(fontSml), w1, fh, taCenter);
            Flush();
	  break;
      }	        
    }
    else {
//      bmpcolors = 15;  
//      w1=4*fh + fw -1;
//      h1=4*fh +fh/2 -1;

          w1 = 128;
	  h1 = 128;
    }

    cMP3Bitmap *bmp;
    if((bmp = cMP3Bitmap::Load(coverpicture, MP3Setup.ImgAlpha, h1, w1, bmpcolors)) !=NULL) {
      if(showcoveronly) {
        osd->DrawRectangle( 0, 0, w1 -1, h1 -1, clrTransparent);
        osd->DrawBitmap( 0, 0, bmp->Get(), clrTransparent, clrTransparent, true);
        }
      else {
        osd->DrawRectangle(osdwidth -128 -3*fw -2, lh, osdwidth -1, lh + 5*fh + fh/2 -1, clrInfoBG1);
        osd->DrawBitmap(osdwidth -128 -3*fw , lh +5*fh +fh/2 -1 -128, bmp->Get(), clrTransparent, clrTransparent, true);
      }
//      delete (bmp);
    }

//      osd->DrawRectangle(3*fw, lh + fh + fh/2 , x1 -5*fh -1 - fh/2 , lh + 5*fh + fh/2 -1, clrInfoBG2); // Info


#ifdef HAVE_VDR_SPEZIAL
    cPlugin *graphtft=cPluginManager::GetPlugin("graphtft");
    if(graphtft) cStatus::MsgImageFile(coverpicture ? coverpicture:"");
#else
    cPlugin *graphtft=cPluginManager::GetPlugin("graphtft");
    if(graphtft) graphtft->SetupParse("CoverImage", coverpicture ? coverpicture:"");
#endif

  }
  CanLoadCover = false;
}


void cMP3Control::ShowCoverOnly(bool open)
{
  int w2=119;
  int h2=119;
  int depths=8;

/*
  if(MP3Skin.isMpeg == 1) {
    showcoveronly = false;
    SetNeedsFastResponse(true);
    //needsFastResponse = true;
    return;
  }    
*/

  if(!cOsd::IsOpen()) {
    if(!visible && !open) {
      open=true;
    }
  }

  if(!visible && open) {
    HideStatus();

    osd=cOsdProvider::NewOsd(Setup.OSDLeft, Setup.OSDTop);
    if(!osd) return;

    coversize=MP3Setup.Coversize;
    switch(coversize) {
      case 0:
          depths = 8;
	  w2 = 119;
	  h2 = 119;
	break;  
      case 1:  
	  depths = 8;
	  w2 = 273;
	  h2 = 273;
	break;
      case 2:  
	  depths = 8;
	  w2 = 299;
	  h2 = 255;
	break;
      case 3:
	  depths = 8;
	  w2 = Setup.OSDWidth -1;
	  h2 = Setup.OSDHeight -1;
	break;
    }	        

    tArea Area[] = {{ 0 , 0, w2, h2, depths}, };
    eOsdError result = osd->CanHandleAreas(Area, sizeof(Area) / sizeof(tArea));
    if (result == oeOk) {
      osd->SetAreas(Area, sizeof(Area) / sizeof(tArea));
      }
    else  {
      const char *errormsg = NULL;
      switch (result) {
        case oeTooManyAreas:
	  errormsg = "Too many OSD areas"; break;
	case oeTooManyColors:
	  errormsg = "Too many colors"; break;
	case oeBppNotSupported:
	  errormsg = "Depth not supported"; break;	
	case oeAreasOverlap:
	  errormsg = "Areas are overlapped"; break;
	case oeWrongAlignment:
	  errormsg = "Areas not correctly aligned"; break;
	case oeOutOfMemory:
	  errormsg = "OSD memory overflow"; break;
	case oeUnknown:
          errormsg = "Unknown OSD error"; break;
	default:
	break;
        }	
      esyslog("mp3ng: ERROR! OSD open failed! Can't handle areas (%d)-%s\n", result, errormsg);
      return;
    }

    osd->DrawRectangle(0 , 0, w2, h2, clrTransparent); // Cover
    LoadCover();
    Flush();
    ShowStatus(true);
//    needsFastResponse=visible=true;
    visible=true;
    SetNeedsFastResponse(visible);
    delete lastMode; lastMode=0;
  }


  cMP3PlayInfo *mode=new cMP3PlayInfo;
  bool valid=mgr->Info(-1,mode);
  bool changed=(!lastMode || mode->Hash!=lastMode->Hash || refresh);
  char buf[256];

  if(valid) { // send progress to status monitor
    if(changed || mode->Loop!=lastMode->Loop || mode->Shuffle!=lastMode->Shuffle) {
      snprintf(buf,sizeof(buf),mode->Artist[0]?"[%c%c] (%d/%d) %s - %s":"[%c%c] (%d/%d) %s",
               mode->Loop?'L':'.',mode->Shuffle?'S':'.',mode->Num,mode->MaxNum,mode->Title,mode->Artist);
#if VDRVERSNUM >= 10338
      cStatus::MsgReplaying(this,buf,mode->Filename[0]?mode->Filename:0,true);
#else
      cStatus::MsgReplaying(this,buf);
#endif
    }
  }

  if(visible) { // refresh the OSD display
    flush=false;

    if(CanLoadCover) {
      LoadCover();
      flush = true;
    }

    if(flush) Flush();
  }

  SetNeedsFastResponse(false);
  delete lastMode; lastMode=mode;
  refresh = false;

}      


void cMP3Control::Flush(void)
{
  if(osd) osd->Flush();
}


void cMP3Control::ShowHelpButtons(int ShowButtons) {
      int tab;
      tab = Setup.OSDWidth/4;
      showbuttons = ShowButtons;
      

  switch(showbuttons) {
    case 0:
        osd->DrawEllipse(14, lh + 7*fh +fh/2 + 8,  26 , lh + 7*fh +fh/2 +21, clrStatusRed, 0);

        if(MP3Setup.RatingFirst)
          osd->DrawText(       34 , lh + 7*fh +fh/2, "Rating", clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
        else
          osd->DrawText(       34 , lh + 7*fh +fh/2, tr("Commands"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);

        osd->DrawEllipse(tab+8, lh + 7*fh +fh/2 +8, tab + 20 , lh + 7*fh +fh/2 +21, clrStatusGreen, 0);
        osd->DrawText(  tab + 28, lh + 7*fh +fh/2, tr("Track-"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
        osd->DrawEllipse(2*tab+8, lh + 7*fh +fh/2 +8, 2*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusYellow, 0);
        osd->DrawText( 2*tab +28, lh + 7*fh +fh/2, tr("Track+"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
        osd->DrawEllipse(3*tab+8, lh + 7*fh +fh/2 +8, 3*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusBlue, 0);
        osd->DrawText( 3*tab +28, lh + 7*fh +fh/2, tr("More.."), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
      break;
    case 1:       
	osd->DrawEllipse(14, lh + 7*fh +fh/2 + 8,  26 , lh + 7*fh +fh/2 +21, clrStatusRed, 0);

        if(MP3Setup.RatingFirst)
          osd->DrawText(       34 , lh + 7*fh +fh/2, tr("Commands"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
        else
          osd->DrawText(       34 , lh + 7*fh +fh/2, "Rating", clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);

//	osd->DrawText(       34 , lh + 6*fh +fh/2, tr("Parent"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(tab+8, lh + 7*fh +fh/2 +8, tab + 20 , lh + 7*fh +fh/2 +21, clrStatusGreen, 0);
	osd->DrawText(  tab + 28, lh + 7*fh +fh/2, tr("Cover"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(2*tab+8, lh + 7*fh +fh/2 +8, 2*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusYellow, 0);
	osd->DrawText( 2*tab +28, lh + 7*fh +fh/2, tr("Jump"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(3*tab+8, lh + 7*fh +fh/2 +8, 3*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusBlue, 0);
        if(MP3Setup.AdminMode)
	  osd->DrawText( 3*tab +28, lh + 7*fh +fh/2, tr("More.."), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	else  
	  osd->DrawText( 3*tab +28, lh + 7*fh +fh/2, tr("Parent"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
      break;
    case 2:  	
	osd->DrawEllipse(14, lh + 7*fh +fh/2 + 8,  26 , lh + 7*fh +fh/2 +21, clrStatusRed, 0);
	osd->DrawText(       34 , lh + 7*fh +fh/2, tr("Delete"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(tab+8, lh + 7*fh +fh/2 +8, tab + 20 , lh + 7*fh +fh/2 +21, clrStatusGreen, 0);
	osd->DrawText(  tab + 28, lh + 7*fh +fh/2, tr("Clear"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(2*tab+8, lh + 7*fh +fh/2 +8, 2*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusYellow, 0);
	osd->DrawText( 2*tab +28, lh + 7*fh +fh/2, tr("Copy"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(3*tab+8, lh + 7*fh +fh/2 +8, 3*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusBlue, 0);
	osd->DrawText( 3*tab +28, lh + 7*fh +fh/2, tr("Parent"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
      break; 
    case 3:  	
	osd->DrawEllipse(14, lh + 7*fh +fh/2 + 8,  26 , lh + 7*fh +fh/2 +21, clrStatusRed, 0);
	osd->DrawText(       34 , lh + 7*fh +fh/2, tr("Parent"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(tab+8, lh + 7*fh +fh/2 +8, tab + 20 , lh + 7*fh +fh/2 +21, clrStatusGreen, 0);
	osd->DrawText(  tab + 28, lh + 7*fh +fh/2, "<<", clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(2*tab+8, lh + 7*fh +fh/2 +8, 2*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusYellow, 0);
	osd->DrawText( 2*tab +28, lh + 7*fh +fh/2, ">>", clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
	osd->DrawEllipse(3*tab+8, lh + 7*fh +fh/2 +8, 3*tab + 20 , lh + 7*fh +fh/2 +21, clrStatusBlue, 0);
	osd->DrawText( 3*tab +28, lh + 7*fh +fh/2, tr("Min/Sec"), clrStatusTextFG, clrStatusBG, cFont::GetFont(fontSml), 14*fw, fh, taLeft);
      break; 
  }         
  
//  Flush();    
}


void cMP3Control::ConvertRatingToChar(int value, int bgClr, int fgClr, int rowc) {

  int bg=bgClr;
//  int bg=MP3Skin.clrListBG1;
//  int fg=fgClr;
  int fg=MP3Skin.clrListRating;
  int x1=Setup.OSDWidth;
  int i=rowc;
  int fw=6;
  int fh=27;
  int y3=6;
  int y4=25*fw;

  if(value <0) value=0;

// Strich : 5*fw
// Raute  : 1*fw
  switch(value) {
     case 0:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3  , bmRate00 , bg , fg );
//       rating="          ";
       break;
     case 3:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmDelStar , bg , fg );
//       rating="         L";
       break;
     case 28:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate05 , bg , fg );
//       rating="         *";
       break;
     case 53:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate10 , bg , fg );
//       rating="        **";
       break;
     case 78:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate15 , bg , fg );
//       rating="       ***";
       break;
     case 104:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate20 , bg , fg );
//       rating="      ****";
       break;
     case 129:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate25 , bg , fg );
//       rating="     *****";
       break;
     case 154:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate30 , bg , fg );
//       rating="    ******";
       break;
     case 179:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate35 , bg , fg );
//       rating="   *******";
       break;
     case 205:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate40 , bg , fg );
//       rating="  ********";
       break;
     case 230:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate45 , bg , fg );
//       rating=" *********";
       break;
     case 255:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate50 , bg , fg );
//       rating="**********";
       break;
     default:
       osd->DrawBitmap( (1*fw) +(fh/2) +(10*fw) + (x1 - (y4) -fh) , 2*fh + (fh/2) + (i*fh) +y3   , bmRate00 , bg , fg );
//       rating="";
       break;  
  }

}

void cMP3Control::ShowProgress(bool open)
{
  int index, total;

  if(player->GetIndex(index,total) && total>=0) {

    if(!cOsd::IsOpen()) {
      if(!visible && !open) {
        open=true;

        font=cFont::GetFont(fontOsd);
        fw=6;
        fh=27;
    
        artistfirst = MP3Setup.ArtistFirst;
        depth                 = 4;
	clrTopBG1             = MP3Skin.clrTopBG1;
	clrTopTextFG1         = MP3Skin.clrTopTextFG1;

	clrTopBG2             = MP3Skin.clrTopBG2;
	clrTopTextFG2         = MP3Skin.clrTopTextFG2;
        clrTopItemBG1         = MP3Skin.clrTopItemBG1;
	clrTopItemInactiveFG  = MP3Skin.clrTopItemInactiveFG;
	clrTopItemActiveFG    = MP3Skin.clrTopItemActiveFG;

	clrListBG1            = MP3Skin.clrListBG1;
	clrListBG2            = MP3Skin.clrListBG2;
	clrListTextFG         = MP3Skin.clrListTextFG;
	clrListTextActiveFG   = MP3Skin.clrListTextActiveFG;
	clrListTextActiveBG   = MP3Skin.clrListTextActiveBG;
	clrListRating         = MP3Skin.clrListRating;

	clrInfoBG1            = MP3Skin.clrInfoBG1;
	clrInfoBG2            = MP3Skin.clrInfoBG2;
	clrInfoTextFG1        = MP3Skin.clrInfoTextFG1;
	clrInfoTitleFG1       = MP3Skin.clrInfoTitleFG1;
	clrInfoTextFG2        = MP3Skin.clrInfoTextFG2;

	clrProgressBG1        = MP3Skin.clrProgressBG1;
	clrProgressBG2        = MP3Skin.clrProgressBG2;
	clrProgressbarFG      = MP3Skin.clrProgressbarFG;
	clrProgressbarBG      = MP3Skin.clrProgressbarBG;

	clrStatusBG           = MP3Skin.clrStatusBG;
	clrStatusRed          = MP3Skin.clrStatusRed;
	clrStatusGreen        = MP3Skin.clrStatusGreen;
	clrStatusYellow       = MP3Skin.clrStatusYellow;
	clrStatusBlue         = MP3Skin.clrStatusBlue;
	clrStatusTextFG       = MP3Skin.clrStatusTextFG;

        if (MP3Skin.isMpeg == 0) {
          rows      = MP3Setup.Rowcount;
          osdheight = Setup.OSDHeight;
          osdwidth  = Setup.OSDWidth;
          osdtop    = Setup.OSDTop;
          osdleft   = Setup.OSDLeft;	
        }
        else {
          rows      = MP3Skin.rows;
          osdheight = MP3Skin.osdheight;
          osdwidth  = MP3Skin.osdwidth;
          osdtop    = MP3Skin.osdtop;
          osdleft   = MP3Skin.osdleft;	
          if ( player->IsStream() )
            clrProgressbarBG    = 0x0A000000;
          else
            clrProgressbarBG    = MP3Skin.clrProgressbarBG;
	}

        lh   = 3*fh +(rows * fh) + fh/2;
        x0 = 0;
        x1 = osdwidth;
        y0 = 0;
        y1 = fh;
        y2 = y1 + fh;
        y5 = osdheight;
        y4 = y5 -fh;
        y3 = y4 - fh;

        visualization = satheme[MP3Setup.ThemesSA].Visualization; 
        channelsSA    = satheme[MP3Setup.ThemesSA].ChannelsSA;
	bandsSA       = satheme[MP3Setup.ThemesSA].BandsSA;
      }
    }


    if(!visible && open) {
      HideStatus();

      osd=cOsdProvider::NewOsd(osdleft + MP3Setup.OSDoffsetx, osdtop + MP3Setup.OSDoffsety);
      if(!osd) return;

//printf("COVERAREA: Breite=%d , HOEHE=%d\n",108 -24, 108 + 14 -1);
			 
      tArea Area[] = { { 0               ,  0               , x1 -1               ,  fh -3              , 2 },        // border top
                       { 0               , fh -2            , x1 -1               ,  2*fh -1            , 2 },        // between top and tracklist
#ifdef HAVE_VDR_SPEZIAL
		       { 0               ,  2*fh            , x1 -1               ,  lh   -1            , 4 },        // tracklist
#else
		       { 0               ,  2*fh            , x1 -1               ,  lh   -1            , 2 },        // tracklist
#endif
		       { 0               , lh               , x1 -128 -3*fw -3    , lh + 5*fh + fh/2 -1 , 2 },        // Info
		       { x1 -128 -3*fw -2, lh               , x1 - 1              , lh + 5*fh + fh/2 -1 , depth },    // Cover
		       { 0               , lh + 5*fh + fh/2 , x1 -1               , lh + 7*fh + fh/2 -1 , 2 },        // Progress
#ifdef HAVE_VDR_SPEZIAL
		       { 0               , lh + 7*fh + fh/2 , x1 -1               , y5 -1               , 4 },        // Bottom
#else
		       { 0               , lh + 7*fh + fh/2 , x1 -1               , lh + 8*fh + fh/2 -1 , 4 },        // Bottom
#endif

		       };

      eOsdError result = osd->CanHandleAreas(Area, sizeof(Area) / sizeof(tArea));
      if (result == oeOk) {
        osd->SetAreas(Area, sizeof(Area) / sizeof(tArea));
	}
      else  {
        const char *errormsg = NULL;
	switch (result) {
	    case oeTooManyAreas:
	    	errormsg = "Too many OSD areas"; break;
	    case oeTooManyColors:
	    	errormsg = "Too many colors"; break;
	    case oeBppNotSupported:
	    	errormsg = "Depth not supported"; break;	
	    case oeAreasOverlap:
	    	errormsg = "Areas are overlapped"; break;
	    case oeWrongAlignment:
	    	errormsg = "Areas not correctly aligned"; break;
	    case oeOutOfMemory:
	    	errormsg = "OSD memory overflow"; break;
	    case oeUnknown:
	    	errormsg = "Unknown OSD error"; break;
	    default:
	    break;
	    }	
	esyslog("mp3ng: ERROR! OSD open failed! Can't handle areas (%d)-%s\n", result, errormsg);
	return;
      }

//top
#ifdef HAVE_VDR_SPEZIAL
      if(MP3Setup.FullSize) {
        osd->DrawRectangle(0, 0, x1 - 1, fh -3, clrTopBG1);         // border top
        }
      else {
        osd->DrawRectangle(0, 0, x1 - 1, fh -3, clrTopBG1);         // border top
        osd->DrawEllipse(0, 0, fh/2 , fh/2,  clrTransparent, -2);
        osd->DrawEllipse(x1 -1 - fh/2, 0, x1 -1 , fh/2, clrTransparent, -1);
      }      	

      font=cFont::GetFont(fontEthno);
#else
      osd->DrawRectangle(0, 0, x1 - 1, fh -3, clrTopBG1);         // border top
      osd->DrawEllipse(0, 0, fh/2 , fh/2,  clrTransparent, -2);
      osd->DrawEllipse(x1 -1 - fh/2, 0, x1 -1 , fh/2, clrTransparent, -1);
      font=cFont::GetFont(fontSml);
#endif
      osd->DrawText( 3*fw, 0, tr("- VDR-MUSICPLAYER -"), clrTopTextFG1, clrTopBG1, font, x1 - (6*fw), fh, taCenter);
      font=cFont::GetFont(fontOsd);
      osd->DrawRectangle(0, fh -2,    x1 -1 , 2*fh -1  ,clrTopBG2);
      osd->DrawText( 8*fw, fh , tr("TRACKLIST :"), clrTopTextFG2, clrTopBG2, font, 40*fw, fh, taLeft);

//tracklist
      osd->DrawRectangle(0, 2*fh  ,  x1 -1 , lh -1 ,clrListBG1);
      osd->DrawRectangle(3*fw, 2*fh ,  x1 - 3*fw , lh - fh/2 -1 ,clrListBG2);
      osd->DrawEllipse(3*fw  , 2*fh , 3*fw + fh/2 , 2*fh  + fh/2, clrListBG1, -2);
      osd->DrawEllipse(x1 - 3*fw - fh/2, 2*fh, x1 - 3*fw , 2*fh + fh/2, clrListBG1, -1);
      osd->DrawEllipse(3*fw             , lh -fh -1, 3*fw + fh/2 , lh - fh/2 -1, clrListBG1, -3);
      osd->DrawEllipse(x1 - 3*fw - fh/2 , lh -fh -1, x1 - 3*fw   , lh - fh/2 -1, clrListBG1, -4);

//info
      osd->DrawRectangle(0                    , lh               , x1 -128 -3*fw -3    , lh + 5*fh +fh/2 -1 ,clrInfoBG1); // Info
      osd->DrawRectangle(x1 -128 -3*fw -2     , lh               , x1 -1               , lh + 5*fh +fh/2 -1 ,clrInfoBG1); // Cover
      osd->DrawRectangle(18, lh + 27 + fh/2   , x1 -128 -5*fw -1 , lh + 5*fh + fh/2 -1 , clrInfoBG2); // Info
      osd->DrawEllipse(18  , lh + 27 + fh/2   , 18 + fh/2        , lh + 54, clrInfoBG1 , -2);
      osd->DrawEllipse(x1 -128 -4*fw -fh/2 -1 , lh + fh + fh/2   , x1 -128 -5*fw -1    , lh + 2*fh, clrInfoBG1, -1);


//progressbar
      osd->DrawRectangle(0, lh + 5*fh + fh/2 , x1 -1 , lh + 7*fh + fh/2 -1  , clrProgressBG1);        // Progress
      osd->DrawRectangle(3*fw, lh + 6*fh, x1 - 3*fw , lh + 7*fh ,clrProgressBG2);        // Progress
      osd->DrawEllipse(3*fw, lh + 6*fh + fh/2, 3*fw + fh/2 , lh + 7*fh, clrProgressBG1, -3);
      osd->DrawEllipse(x1 - 3*fw - fh/2, lh + 6*fh + fh/2 , x1  - 3*fw , lh + 7*fh, clrProgressBG1, -4);


//bottom
#ifdef HAVE_VDR_SPEZIAL
      if(MP3Setup.FullSize) {
        osd->DrawRectangle(0, lh + 7*fh + fh/2 , x1 - 1 , y5 -1, clrStatusBG);         // border top
        }
      else {
        osd->DrawRectangle(0, lh + 7*fh + fh/2 , x1 - 1 , lh + 8*fh + fh/2 -1 , clrStatusBG);         // border top
        osd->DrawEllipse(0, lh + 8*fh -1 , fh/2 , lh + 8*fh + fh/2 -1,  clrTransparent, -3);
        osd->DrawEllipse(x1 -1 - fh/2, lh + 8*fh -1, x1 -1 , lh + 8*fh +fh/2 -1, clrTransparent, -4);
        osd->DrawRectangle(0, lh + 8*fh + fh/2 , x1 - 1 , y5 -1 , clrTransparent);         // If OSD higher than static Areas
      }	
#else
      osd->DrawRectangle(0, lh + 7*fh + fh/2 , x1 - 1 , lh + 8*fh + fh/2 -1 , clrStatusBG);         // border top
      osd->DrawEllipse(0, lh + 8*fh -1 , fh/2 , lh + 8*fh + fh/2 -1,  clrTransparent, -3);
      osd->DrawEllipse(x1 -1 - fh/2, lh + 8*fh -1, x1 -1 , lh + 8*fh +fh/2 -1, clrTransparent, -4);
#endif

      ShowHelpButtons(showbuttons);	
	
      player->LoadImage(Songname);
      LoadCover();


      osd->Flush();
      ShowStatus(true);
      visible = true;
      SetNeedsFastResponse(visible);

      fliptime=listtime=0; flipint=0; flip=-1; top=lastTop=-1; lastIndex=lastTotal=-1;
      delete lastMode; lastMode=0;

    }




//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    cMP3PlayInfo *mode=new cMP3PlayInfo;
    bool valid=mgr->Info(-1,mode);
    bool changed=(!lastMode || mode->Hash!=lastMode->Hash || refresh);
    char buf[256];

    if(valid) { // send progress to status monitor
      if(changed || mode->Loop!=lastMode->Loop || mode->Shuffle!=lastMode->Shuffle) {
        snprintf(buf,sizeof(buf),mode->Artist[0]?"[%c%c] (%d/%d) %s - %s":"[%c%c] (%d/%d) %s",
                  mode->Loop?'L':'.',mode->Shuffle?'S':'.',mode->Num,mode->MaxNum,mode->Title,mode->Artist);
#if VDRVERSNUM >= 10338
      cStatus::MsgReplaying(this,buf,mode->Filename[0]?mode->Filename:0,true);
#else
      cStatus::MsgReplaying(this,buf);
#endif

        }
    }


    if(visible) { // refresh the OSD progress display
      flush=false;

      if (CanLoadCover) {
        osd->DrawRectangle(x1 - 128 -3*fw -2, lh, x1 -1, lh + 4*fh + fh/2 -1, clrInfoBG1);
        LoadCover();
        flush = true;
        }




      if(!selecting && changed && !statusActive || refresh) {
        if (!scrollmode) {
	  font=cFont::GetFont(fontSml);
          snprintf(buf,sizeof(buf),"%s %i %s %i","No.",mode->Num,tr("of"),mode->MaxNum);
      	  osd->DrawText( 30, lh + 3*fh + fh/2, buf, clrInfoTextFG2, clrInfoBG2, cFont::GetFont(fontSml), 35 * fw, fh, taLeft);
          if(mode->MaxBitrate>0) {
            snprintf(buf,sizeof(buf),"%s: %.1f kHz, %d-%d kbps, %s", tr("Info"), mode->SampleFreq/1000.0,mode->Bitrate/1000,mode->MaxBitrate/1000,mode->SMode);
            osd->DrawText( 30, lh + 2*fh + fh/2 +4, buf, clrInfoTextFG2, clrInfoBG2, cFont::GetFont(fontSml), osdwidth -128 -30 -6*fw, fh, taLeft);
            }
          else {
            snprintf(buf,sizeof(buf),"%s: %.1f kHz, %d kbps, %s",tr("Info"), mode->SampleFreq/1000.0,mode->Bitrate/1000,mode->SMode);
            osd->DrawText( 30, lh + 2*fh + fh/2 +4, buf, clrInfoTextFG2, clrInfoBG2, cFont::GetFont(fontSml), osdwidth -128 -30 -6*fw, fh, taLeft);
            }
          font=cFont::GetFont(fontOsd);
          flush=true;
          }
        else {
          mgr->Info(mgr->currindex+1,mode);
	  font=cFont::GetFont(fontSml);
          snprintf(buf,sizeof(buf),"%s: %i %s %i","No.",mode->Num,tr("of"),mode->MaxNum);
      	  osd->DrawText( 30, lh + 3*fh + fh/2, buf, clrInfoTextFG2, clrInfoBG2, cFont::GetFont(fontSml), 37 * fw, fh, taLeft);
          if(mode->MaxBitrate>0) {
            snprintf(buf,sizeof(buf),"%s: %.1f kHz, %d-%d kbps, %s", tr("Info"), mode->SampleFreq/1000.0,mode->Bitrate/1000,mode->MaxBitrate/1000,mode->SMode);
            osd->DrawText( 30, lh + 2*fh + fh/2 +4, buf, clrInfoTextFG2, clrInfoBG2, cFont::GetFont(fontSml), osdwidth -128 -30 -6*fw, fh, taLeft);
            }
          else {
            snprintf(buf,sizeof(buf),"%s: %.1f kHz, %d kbps, %s",tr("Info"), mode->SampleFreq/1000.0,mode->Bitrate/1000,mode->SMode);
            osd->DrawText( 30, lh + 2*fh + fh/2 +4, buf, clrInfoTextFG2, clrInfoBG2, cFont::GetFont(fontSml), osdwidth -128 -30 -6*fw, fh, taLeft);
          }      
          font=cFont::GetFont(fontOsd);

          snprintf(buf,sizeof(buf),mode->Artist[0]?"%s - %s":"%s%s",mode->Title,mode->Artist);
            if(buf[0]) {
              if(!statusActive) {
                DisplayInfo(buf);
                flush=true;
              }
            }
          mgr->Info(-1,mode);
        }
      }


      if(copyfile) {
        copyfile=false;
	osd->DrawBitmap(x1 - 3*fw - 276, fh , bmCopy, clrTopBG2, clrTopBG2);
      }

      if(!lastMode || mode->Loop!=lastMode->Loop) {
        if(mode->Loop)  osd->DrawBitmap(x1 - 3*fw - 246, fh , bmLoop, clrTopItemActiveFG, clrTopItemBG1 );
    	else osd->DrawBitmap(x1 - 3*fw - 246, fh , bmLoop, clrTopBG2, clrTopBG2);
        flush=true;
      }

      if(!lastMode || mode->Shuffle!=lastMode->Shuffle) {
        if(mode->Shuffle)  osd->DrawBitmap(x1 - 3*fw - 216, fh , bmShuffle, clrTopItemActiveFG, clrTopItemBG1);
        else osd->DrawBitmap(x1 - 3*fw - 216, fh , bmShuffle, clrTopBG2, clrTopBG2);
        flush=true;
      }


      int playstatus;
      playstatus = player->StatusMode();
      switch(playstatus) {
        case 1:
          osd->DrawBitmap(osdwidth - 3*fw - 160, fh , bmStop, clrTopItemActiveFG, clrTopItemBG1);
          osd->DrawBitmap(osdwidth - 3*fw - 130, fh , bmPlay, clrTopItemInactiveFG, clrTopItemBG1);
          osd->DrawBitmap(osdwidth - 3*fw - 100, fh , bmPause, clrTopItemInactiveFG, clrTopItemBG1);
          break;
        case 2:
          osd->DrawBitmap(osdwidth - 3*fw - 160, fh , bmStop, clrTopItemInactiveFG, clrTopItemBG1);
          osd->DrawBitmap(osdwidth - 3*fw - 130, fh , bmPlay, clrTopItemActiveFG, clrTopItemBG1);
          osd->DrawBitmap(osdwidth - 3*fw - 100, fh , bmPause, clrTopItemInactiveFG, clrTopItemBG1);
          break;
        case 3:
          osd->DrawBitmap(osdwidth - 3*fw - 160, fh , bmStop, clrTopItemInactiveFG, clrTopItemBG1);
          osd->DrawBitmap(osdwidth - 3*fw - 130, fh , bmPlay, clrTopItemInactiveFG, clrTopItemBG1);
          osd->DrawBitmap(osdwidth - 3*fw - 100, fh , bmPause, clrTopItemActiveFG, clrTopItemBG1);
          break;
      }
  

      if(skiprew)  osd->DrawBitmap(osdwidth - 3*fw - 70, fh , bmRew, clrTopItemActiveFG, clrTopItemBG1);
       else
      osd->DrawBitmap(osdwidth - 3*fw - 70, fh , bmRew, clrTopItemInactiveFG, clrTopItemBG1);

      if(skipfwd)  osd->DrawBitmap(osdwidth - 3*fw - 40, fh , bmFwd, clrTopItemActiveFG, clrTopItemBG1);
       else
      osd->DrawBitmap(osdwidth - 3*fw - 40, fh , bmFwd, clrTopItemInactiveFG, clrTopItemBG1);

      if(recordstream) {
        osd->DrawText( 8*fw, lh + fh/2 -fw, tr("RECORDING STREAM :"), clrInfoTitleFG1, clrInfoBG1, cFont::GetFont(fontOsd), (46*fw), fh, taLeft);
        flush=true;
        }
      else {
        if(!player->IsStream())
	  osd->DrawText( 8*fw, lh + fh/2 -fw, tr("NOW PLAYING LOCAL :"), clrInfoTextFG1, clrInfoBG1, cFont::GetFont(fontOsd), (46*fw), fh, taLeft);
	else
	  osd->DrawText( 8*fw, lh + fh/2 -fw, tr("NOW PLAYING STREAM :"), clrInfoTextFG1, clrInfoBG1, cFont::GetFont(fontOsd), (46*fw), fh, taLeft);
	flush=true;
      }

      if(!player->IsStream()) {
        index/=framesPerSecond; total/=framesPerSecond;
        if(index!=lastIndex || total!=lastTotal) {
          if(total>0) {
	    osd->DrawRectangle( 7*fw, lh + 6*fh, osdwidth - 7*fw, lh + 7*fh, clrProgressBG2);
            osd->DrawEllipse(8*fw -1, lh + 6*fh + fh/2 -fw -2, 9*fw-1, lh + 6*fh + fh/2 +fw +2, clrProgressbarFG, 7);
            cProgressBar ProgressBar(x1 -18*fw, 2*fw +5, index, total, clrProgressbarFG , clrProgressbarBG);
	    osd->DrawBitmap(9*fw , lh + 6*fh + fh/2 -fw -2, ProgressBar);
	    osd->DrawEllipse(x1 -9*fw, lh + 6*fh +fh/2 -fw -2, x1 - 8*fw -1 , lh + 6*fh + fh/2 +fw +2,  clrProgressbarBG,5);
          }
    	  snprintf(buf,sizeof(buf),total?"%s: %02d:%02d %s %02d:%02d":"%s: %02d:%02d ",tr("Time"),index/60,index%60, "-",total/60,total%60);
          font=cFont::GetFont(fontSml);
    	  osd->DrawText( x1 -390, lh +3*fh +fh/2, buf, clrInfoTextFG2, clrInfoBG2, font, 226, fh, taRight);
    	  font=cFont::GetFont(fontOsd);
          flush=true;
        }
      }
      else {
	osd->DrawRectangle( 7*fw, lh + 6*fh, osdwidth - 7*fw, lh + 7*fh, clrProgressBG2);
        osd->DrawEllipse(8*fw -1, lh + 6*fh + fh/2 -fw -2, 9*fw-1, lh + 6*fh + fh/2 +fw +2, clrProgressbarBG, 7);
        osd->DrawRectangle(9*fw, lh +6*fh +fh/2 -fw -2, x1 -9*fw -1, lh + 6*fh + fh/2 +fw +2, clrProgressbarBG);
	osd->DrawEllipse(x1 -9*fw, lh + 6*fh +fh/2 -fw -2, x1 - 8*fw -1 , lh + 6*fh + fh/2 +fw +2,  clrProgressbarBG,5);
      }
	
      if(!jumpactive) {
        if (!scrollmode) {
          bool doflip=false;
          if((!lastMode || mode->Loop!=lastMode->Loop || mode->Shuffle!=lastMode->Shuffle))
            doflip=true;
          if(!valid || changed) {
            fliptime=time(0); flip=0;
	    doflip=true;
	    }
          else if(time(0)>fliptime+flipint) {
	    fliptime=time(0);
	    flip++; if(flip>=MP3Setup.DisplayMode) flip=0;
            doflip=true;
	  }
          if(doflip) {
            buf[0]=0;

            switch(flip) {
	      default:
	        flip=0;
	      case 0:
	        snprintf(buf,sizeof(buf),"%s",mode->Title);
	        flipint=6;
	        break;
	      case 1:
                if(mode->Artist[0]) {
	          snprintf(buf,sizeof(buf),"%s: %s",tr("Artist"),mode->Artist);
	          flipint=4;
	          }
	        else fliptime = 0;
	        break;
	      case 2:
                if(mode->Album[0]) {
      	          snprintf(buf,sizeof(buf),"Album: %s",mode->Album);
	          flipint=4;
	          }
                else fliptime=0;
                break;
	      case 3:
                if(mode->Genre[0]) {
                  snprintf(buf,sizeof(buf),mode->Year>0?"Genre: %s  Year: %d":"Genre: %s",mode->Genre, mode->Year);
	          flipint=3;
		  }
	        else fliptime=0;	
	        break;
	      }
            if(buf[0]) {
              if(!statusActive) {
                DisplayInfo(buf);
                flush=true;
                }
	      else { d(printf("mp3ng-ctrl: displayinfo skipped due to status active!\n")) }  
            }
          }    
        }
      }

      bool all=(top!=lastTop || changed);
      if(all || time(0)>listtime+2) {
        num=(top>0 && mode->Num==lastMode->Num) ? top : mode->Num - rows/2;
        if(num+rows>mode->MaxNum) num=mode->MaxNum-rows+1;
        if(num<1) num=1;
        top=num;

        for(int i=0 ; i<rows && i<MAXROWS && num<=mode->MaxNum ; i++,num++) {
          cMP3PlayInfo pi;
          mgr->Info(num,&pi);	   if(!pi.Title[0]) break;

          if(artistfirst) {snprintf(buf,sizeof(buf),pi.Artist[0]?"%d.\t    %s - %s":"%d.\t    %s",num,pi.Artist,pi.Title);}
          else {snprintf(buf,sizeof(buf),pi.Artist[0]?"%d.\t    %s - %s":"%d.\t    %s",num,pi.Title,pi.Artist);}

          eDvbColor fg=clrListTextFG, bg=clrListBG2;
          int hash=MakeHash(buf);

	  if(scrollmode) {
            if(num==mode->Num) {
	      bg=clrListTextActiveFG;
	      fg=clrListTextActiveBG;
	      hash=(hash^77) + 23;
	    }
	  }	
	  else  {
            if(num==mode->Num) {
	      bg=clrListTextActiveBG;
	      fg=clrListTextActiveFG;
	      hash=(hash^77) + 23;
	    }
	  }

          if(all || hash!=hashlist[i]) {
            char *s=rindex(buf,'\t');
            if(s) {
              *s++=0;
	        font=cFont::GetFont(fontSml);
    	        osd->DrawEllipse( 5*fw                    , 2*fh + (fh/2) + (i*fh)   , (5*fw)+(fh/2) , 2*fh + (fh/2)+ (i*fh)+fh , bg , 7);
          	osd->DrawText( (5*fw) +(fh/2) +1          , (2*fh) + (fh/2) + (i*fh) , buf , fg , bg , font , 10*fw          , fh , taRight);
//           	osd->DrawText( (5*fw) +(fh/2) +1 +(10*fw), 3*fh + (fh/2) + (i*fh)   , s   , fg , bg , font , x1 - (31*fw) -fh, fh , taLeft);
           	osd->DrawText( (5*fw) +(fh/2) +1 +(10*fw), 2*fh + (fh/2) + (i*fh)   , s   , fg , bg , font , x1 - (29*fw) -fh -2, fh , taLeft);

//		osd->DrawRectangle( 5*fw +fh/2 +1 +10*fw+(x1-31*fw)-fh, 3*fh+(fh/2)+(i*fh), 5*fw +fh/2 +2 +10*fw+(x1-31*fw)-fh, 3*fh + (fh/2)+ (i*fh)+fh, fg);

                
//           	osd->DrawText( (5*fw) +(fh/2) +(10*fw) + (x1 - (31*fw) -fh)+3 -2, 3*fh + (fh/2) + (i*fh)   , rating ,fg ,bg ,font ,15*fw -fh+1+2, fh , taRight);
//           	osd->DrawText( (5*fw) +(fh/2) +(10*fw) + (x1 - (35*fw) -fh)+3 -2, 3*fh + (fh/2) + (i*fh)   , rating ,fg ,bg ,font ,19*fw -fh+1+2, fh , taRight);

		osd->DrawRectangle( 5*fw +fh/2+10*fw+(x1-29*fw)-fh -1, 2*fh+(fh/2)+(i*fh), x1 -(5*fw) -fh/2 +1, 2*fh + (fh/2)+ (i*fh) +fh -1, bg);

//(5*fw) +(fh/2) +(10*fw) + (x1 - (26*fw) -fh)+3 -2,


                if(MP3Setup.EnableRating) ConvertRatingToChar(pi.Rating, bg , fg , i); 

	        osd->DrawEllipse( x1 -(5*fw) -fh/2        , 2*fh + (fh/2) + (i*fh)   , x1 - (5*fw), 2*fh + (fh/2) +(i*fh) + fh, bg , 5);
	        font=cFont::GetFont(fontOsd);
            }
	    else {
	      osd->DrawText( 5*fw , 2*fh + (fh/2) + (i*fh) , buf, fg, bg, font, x1 - (10*fw), fh , taLeft);
	    }

              flush=true;
              hashlist[i]=hash;
          }
        }
      listtime=time(0); lastTop=top;
      }

// Spectrum Analyzer visualization
         if ( MP3Setup.EnableSpectrumAnalyzer )	{



	   if (cPluginManager::CallFirstService(SPAN_GET_BAR_HEIGHTS_ID, NULL) && ShowSA)	{
	     Span_GetBarHeights_v1_0 GetBarHeights;
 	     int bar;
 	     int *barHeights = new int[bandsSA];
 	     int *barHeightsLeftChannel = new int[bandsSA];
 	     int *barHeightsRightChannel = new int[bandsSA];
 	     int volumeLeftChannel;
 	     int volumeRightChannel;
 	     int volumeBothChannels;
 								
 	     GetBarHeights.bands 					= bandsSA;
 	     GetBarHeights.barHeights				        = barHeights;
 	     GetBarHeights.barHeightsLeftChannel 	                = barHeightsLeftChannel;
 	     GetBarHeights.barHeightsRightChannel	                = barHeightsRightChannel;
 	     GetBarHeights.volumeLeftChannel			        = &volumeLeftChannel;
 	     GetBarHeights.volumeRightChannel		                = &volumeRightChannel;
 	     GetBarHeights.volumeBothChannels		                = &volumeBothChannels;
 	     GetBarHeights.name						= "MP3-NextGen";
 	     GetBarHeights.falloff					= MP3Setup.FalloffSA;
 			
 	     if ( cPluginManager::CallFirstService(SPAN_GET_BAR_HEIGHTS_ID, &GetBarHeights )) {

		LoadCover();

//lh +5*fh +fh/2 -1 -128
 					
	       int i;
               int barWidth =0;
	       int coverleft= x1 -128 -3*fw;
	       int covertop = lh +5*fh +fh/2 -127;

 	       for ( i=0; i < bandsSA; i++ ) {

                 switch(visualization) {
		   case 1:
 	               barWidth = 128/bandsSA;
//printf("CASE 1 AKTIV: barwidth=%d channels=%d bands=%d\n", barWidth, channelsSA, bandsSA);
 		       if (player != NULL) {
 		         bar = barHeights[i];
 		         osd->DrawRectangle(coverleft +(i*barWidth), covertop, coverleft + (i*barWidth) +barWidth -1, covertop + 110 - bar, clrBlack);
		       }
		       break;
		   case 2:
 	               barWidth = 64/bandsSA;
//printf("CASE 2 AKTIV: barwidth=%d channels=%d bands=%d\n", barWidth, channelsSA, bandsSA);
 		       if (player != NULL) {
 		         bar = barHeightsLeftChannel[i];
 		         osd->DrawRectangle(coverleft +(i*barWidth)    , covertop, coverleft +(i*barWidth) +barWidth -1    , covertop + 110 - bar, clrBlack);
 		         bar = barHeightsRightChannel[i];
 		         osd->DrawRectangle(coverleft +64 +(i*barWidth), covertop, coverleft +64 +(i*barWidth) +barWidth -1, covertop + 110 - bar, clrBlack);
		       }
		       break;
                   case 3:
 	               barWidth = 64;
//printf("CASE 2 AKTIV: barwidth=%d channels=%d bands=%d\n", barWidth, channelsSA, bandsSA);
		       osd->DrawRectangle(coverleft           , covertop, coverleft +(barWidth -1), covertop + 110 - volumeLeftChannel,  clrBlack);
 		       osd->DrawRectangle(coverleft +barWidth , covertop, coverleft +128          , covertop + 110 - volumeRightChannel, clrBlack);
                       break;
		   default: break;
		 }         
	       }

/* 	       if (channelsSA == 1) {
		 osd->DrawRectangle(x1 - 4*fh -4*fw +i*barWidth, lh, x1 - 4*fh - 4*fw +i*barWidth+barWidth, lh + 110 - volumeLeftChannel, clrInfoBG2);
 		 i++;
 		 osd->DrawRectangle(x1 - 4*fh -4*fw +i*barWidth, lh, x1 - 4*fh - 4*fw +i*barWidth+barWidth, lh + 110 - volumeRightChannel, clrInfoBG2);
 	         }
 	       else if (channelsSA == 2) {
	       	 i++;
		 i++;
 		 osd->DrawRectangle(x1 - 4*fh -4*fw +(bandsSA * barWidth) + i*barWidth, lh, x1 - 4*fh - 4*fw +(bandsSA * barWidth) +i*barWidth+barWidth, lh + 110 - volumeLeftChannel, clrInfoBG2);
 		 i++;
 		 osd->DrawRectangle(x1 - 4*fh -4*fw +(bandsSA * barWidth) + i*barWidth, lh, x1 - 4*fh - 4*fw +(bandsSA * barWidth) +i*barWidth+barWidth, lh + 110 - volumeRightChannel, clrInfoBG2);
 	       }
*/
 	       flush = true;
 	     }
 				
 	     delete barHeights;
 	     delete barHeightsLeftChannel;
 	     delete barHeightsRightChannel;
 	   }
 	 }
 
         if(flush) Flush();
   }


    skiprew=0;
    skipfwd=0;
    lastIndex=index; lastTotal=total;
    delete lastMode; lastMode=mode;
    refresh=false;
  }

}


void cMP3Control::DisplayInfo(const char *s)
{
  if(osd) {
    if(s) {
#ifdef HAVE_VDR_SPEZIAL
      	osd->DrawText( 30, lh + fh +fh/2 +fw, s, clrInfoTitleFG1, clrInfoBG2, cFont::GetFont(fontBig), osdwidth -128 -30 -6*fw, fh, taLeft);
#else
      	osd->DrawText( 30, lh + fh +fh/2 +fw, s, clrInfoTitleFG1, clrInfoBG2, cFont::GetFont(fontOsd), osdwidth -128 -30 -6*fw, fh, taLeft);
#endif
    }
  else {
#ifdef HAVE_VDR_SPEZIAL
      	osd->DrawText( 30, lh + fh +fh/2 +fw, s, clrInfoBG2, clrInfoBG2, cFont::GetFont(fontBig), osdwidth -128 -30 -6*fw, fh, taLeft);
#else
      	osd->DrawText( 30, lh + fh +fh/2 +fw, s, clrInfoBG2, clrInfoBG2, cFont::GetFont(fontOsd), osdwidth -128 -30 -6*fw, fh, taLeft);
#endif
       }
  }
}



void cMP3Control::JumpDisplay(void)
{
  char buf[64];
  const char *j=tr("Jump: "), u=jumpsecs?'s':'m';
  if(!jumpmm)
    sprintf(buf, "%s- %c", j,u);
  else
    sprintf(buf,"%s%d- %c",j,jumpmm,u);

  DisplayInfo(buf);
}      


void cMP3Control::JumpProcess(eKeys Key)
{
  int n=Key-k0, d=jumpsecs?1:60;
  switch(Key) {
    case k0 ... k9:
      if(jumpmm*10+n <= lastTotal/d) jumpmm=jumpmm*10+n;
      JumpDisplay();
      break;
    case kBlue:
      jumpsecs=!jumpsecs;
      JumpDisplay();
      break;
    case kPlay:
    case kUp:
      jumpmm-=lastIndex/d;
      // fall through
    case kFastRew:
    case kFastFwd:
    case kGreen:
    case kYellow:
      player->SkipSeconds(jumpmm*d * ((Key==kGreen) ? -1:1));
      // fall through
    default:
      jumpactive=false;
      break;      
    }
    
  if(!jumpactive) {
    if(jumphide) Hide();
    ShowHelpButtons(0);
    }
}        

void cMP3Control::Jump(void)
{
  jumpmm=0; jumphide=jumpsecs=false;
  if(!visible) {
    ShowTimed(); if(!visible) return;
    jumphide=true;
  }
  JumpDisplay();
  jumpactive=true; fliptime=0; flip=-1;
}  


void cMP3Control::CopyTrack(void)
{
FILE *copyscript;
char *buffer;

  osd->DrawBitmap(osdwidth - 3*fw - 276, 2*fh -fw, bmCopy, clrTopItemActiveFG, clrTopItemBG1);
  Flush();
  asprintf(&buffer, "cp -f \"%s\"  \"%s\"", Songname, MP3Setup.CopyDir);
  copyscript = popen(buffer, "r");
  dsyslog("mp3ng-ctrl: Executing: %s", buffer);
  free(buffer);
  pclose(copyscript);
  copyfile = true;
}



eOSState cMP3Control::ProcessKey(eKeys Key)
{

  if(!player->Active()) return osEnd;

  if(showcoveronly)
    ShowCoverOnly();
  else
    ShowProgress();

  ShowStatus(Key==kNone);

  if(jumpactive && Key!=kNone) { JumpProcess(Key); return osContinue; }

  if(cmdMenu) {
      
    eOSState eOSRet = cmdMenu->ProcessKey(Key);
    switch(eOSRet) {
        case kRed:
        case osBack:
            delete cmdMenu;
	    cmdMenu = NULL;

            // Can't call function from commands, so this is the way :(
            if (deletetrack) {
	      deletetrack = false;
              player->DeleteTrack(false);
	      }
	    else {  
              if (deletetracks) {
                deletetracks = false;
                player->DeleteTrack(true);
	        }
	    }	  

            if(showcoveronly)
              ShowCoverOnly();
            else
              ShowProgress();

	    return osContinue;
        default: return eOSRet;
    }
  }    		
  else if(rateMenu) {
      
    eOSState eOSRet = rateMenu->ProcessKey(Key);
    switch(eOSRet) {
        case kRed:
        case osBack:
            delete rateMenu;
	    rateMenu = NULL;

            if(showcoveronly)
              ShowCoverOnly();
            else
              ShowProgress();

	    return osContinue;
        default: return eOSRet;
    }
  }
  else {

  switch(Key) {

    case kMenu:
    case kUp:
    case kUp|k_Repeat:
        ShowSA=false;      
        if(!scrollmode) scrollmode = true;	
        mgr->Prev();
        player->Play();
      break;
    case kDown:
    case kDown|k_Repeat:
        ShowSA=false;      
        if(!scrollmode)	scrollmode = true;
	if(mgr->NextCurrent()) player->Play();
      break;

    case kLeft:
    case kLeft|k_Repeat:
        ShowSA=false;      
        if(!scrollmode) { scrollmode = true; }
        if(top>0) {
	  top-=rows;
	  top = top + rows/2;
          }
	  
	  if(top<1) top=1;
	  mgr->Goto(top);
      break;

    case kFastRew:
    case kFastRew|k_Repeat:
        ShowSA=false;      
        if(!player->IsStream()) player->SkipSeconds(-MP3Setup.Jumptime);
        skiprew=1;
      break;

    case kRight:
    case kRight|k_Repeat:
        ShowSA=false;      
	if(!scrollmode) scrollmode = true;
        if(top>0)  top+=rows;
	
	if((top+rows/2)< mgr->maxIndex) {
	  mgr->Goto(top + rows/2);
	  }
	else {  
	  mgr->Goto(mgr->maxIndex +1);
	}  
      break;

    case kFastFwd:
    case kFastFwd|k_Repeat:
        ShowSA=false;      
        if(!player->IsStream()) player->SkipSeconds(MP3Setup.Jumptime);
        skipfwd=1;
      break;

    case kPlay:
      player->Play();
      break;

    case kRed:


        // MENUE  OK
        if(showbuttons==0) {
          if(MP3Setup.RatingFirst) {
            if(!player->IsStream()) {
              Hide();
              rateMenu = new cMP3Rating();
              }
	    }
	  else {    
            deletetrack=deletetracks=false;
            Hide();
            cmdMenu = new cMP3Commands();
            }
	  }
	else
	  // BACK  OK
	  if(showbuttons==1) {
	    ShowHelpButtons(0);
            if(MP3Setup.RatingFirst) {
              deletetrack=deletetracks=false;
              Hide();
              cmdMenu = new cMP3Commands();
	      }
	    else {
	      if(!player->IsStream()) {    
                Hide();
                rateMenu = new cMP3Rating();
              }
            }
//	    ShowHelpButtons(0);
	  }
	else
	  //DELETE TRACK  OK
	  if(showbuttons==2) {
            if(!mgr->maxIndex==0 && !mgr->ShuffleMode() && !CannotDelete) {
              player->DeleteTrack(false);
	      ShowHelpButtons(0);
	    }  
	  }      
      break;

    case kGreen: 
    case kGreen|k_Repeat:
        // TRACK-  OK
        if(showbuttons==0) {
	  if(scrollmode) scrollmode=false;
	  mgr->Prev();
          player->Play();
	  }
	else
	  // COVER  OK
	  if(showbuttons==1) {
            if(!showcoveronly) {
              ShowHelpButtons(0);
              showcoveronly = true;
	      Hide();
              ShowCoverOnly(false);
              }
            else {
	      showcoveronly = false;
	      Hide();
	      ShowProgress(false);
      	      }
	  }
	else
	  // CLEAR
	  if(showbuttons==2) {
	    if(!mgr->maxIndex==0 && !mgr->ShuffleMode()) {
              player->DeleteTrack(true);
	      ShowHelpButtons(0);
	      Hide();
	      ShowProgress(false);
	    }  
	}      
      break;

    case kYellow:
    case kYellow|k_Repeat:
        // TRACK+  OK
        if(showbuttons==0) {
          if(scrollmode) scrollmode=false;
	  mgr->Next();
	  player->Play();
	  }
	else
	  // JUMP
	  if(showbuttons==1) {
	    if(!player->IsStream()){
	      Jump();
	      ShowHelpButtons(3);
	      }
	    else  
	      ShowHelpButtons(0);
	  }
	else
	  // COPY  OK
	  if(showbuttons==2) {
	    CopyTrack();
	    ShowHelpButtons(0);
	  }      
      break;

    case kBlue: //OK
        if(showbuttons==0) {
	  if(!showcoveronly) 
            ShowHelpButtons(1);
	  else {
	    showcoveronly = false;
	    Hide();
	    ShowProgress(false);
      	  }
        }
	else
	  if(showbuttons==1) {
	    if(MP3Setup.AdminMode)
	      ShowHelpButtons(2);
	    else
	      ShowHelpButtons(0);  
	  }
	else
	  if(showbuttons==2) {
            ShowHelpButtons(0);
	  }      
      break;





    case kPause:
        player->Pause();
      break;

    case kOk:
        if (scrollmode) {
          scrollmode=false;
	  refresh = true;
	  mgr->Goto((mgr->currIndex) +1);
	  player->Play();

          if(showcoveronly)
            ShowCoverOnly(true);
          else
            ShowProgress(true);

        }
        else {
          Hide();
	  cRemote::CallPlugin("mp3ng");
          return (osPlugin);
        }
      break;

    case kStop:
        Hide();
        Stop();
        return osEnd;

    case k0 ... k9:
        number=number*10+Key-k0;
        if(lastMode && number>0 && number<=lastMode->MaxNum) {
          if(!visible) { ShowTimed(); selecthide=true; }
            selecting=true; lastkeytime=time_ms();
            char buf[32];
            snprintf(buf,sizeof(buf),"%s: %d- %s %d","No.",number,tr("of"),lastMode->MaxNum);
            font=cFont::GetFont(fontSml);
      	    osd->DrawText( 5*fw, lh + 3*fh + fh/2, buf, clrInfoTextFG2, clrInfoBG2, font, 40 * fw , fh, taLeft);
            font=cFont::GetFont(fontOsd);
            Flush();
            break;
        }
	number=0; lastkeytime=0;
    case kNone:
        if(selecting && time_ms()-lastkeytime>SELECT_TIMEOUT) {
	  if(number>0) {mgr->Goto(number); player->Play(); }
	  if(selecthide) timeoutShow=time(0)+SELECTHIDE_TIMEOUT;
	  if(lastMode) lastMode->Hash=-1;
	  number=0; selecting=selecthide=false;
	}
      break;

    case kBack:
        if(scrollmode) {
          mgr->Goto(mgr->currindex+1);
          scrollmode = false;
          refresh = true;

          if(showcoveronly)
            ShowCoverOnly(true);
          else
            ShowProgress(true);
      
          }
        else {
          Hide();
#if VDRVERSNUM >= 10332
	  cRemote::CallPlugin(i18n_name);
          if(MP3Setup.ExitClose)
	    return (osBack);
	  else    
            return (osPlugin);
#else
          return osEnd;
#endif	  	  
        }
    default:
      ShowSA=true;
      return osUnknown;
    }

  return osContinue;
  }
}


