#ifndef __COMMANDS_H
#define __COMMANDS_H

#include <vdr/osdbase.h>
#include "setup-mp3.h"
#include "player-mp3.h"
#include "data-mp3.h"
#include "menu.h"


//class cMP3Player;
class cFileSources;
class cFileSource;
class cFileObj;
class cFileObjItem;

class cMP3EditPlaylist : public cOsdMenu {
private:
 eOSState Execute(void);
 void SetHelp();
public:
 cMP3EditPlaylist(void);
 virtual eOSState ProcessKey(eKeys Key);
 bool DeleteList(void);
};


class cMP3Commands : public cOsdMenu {
private:
 cCommands commands;
 eOSState Execute(void);
 void SetHelp();
public:
 cMP3Commands(void);
 virtual ~cMP3Commands();
 virtual eOSState ProcessKey(eKeys Key);
 void LoadCommands();
 bool DeleteList(void);
 void StartRecord(void);
 void StopRecord(void);
};


class cMP3SearchResult : public cOsdMenu {
private:
 virtual eOSState ID3Info(void);
 virtual eOSState AddOne(void);
 virtual eOSState AddAll(void);
 void SetHelp();
 int GetTab(int Tab);
protected:
  static cFileObj *selected;
  cFileObj *newsong;
  cFileSource *source;
  cFileObj *CurrentItem(void);
public:
 cMP3SearchResult(const char *szTitle);
 virtual ~cMP3SearchResult();
 virtual eOSState ProcessKey(eKeys Key);
 int LoadResult();
 static cFileObj *GetSelected(void) { return selected; }
};


class cMP3SearchValue : public cOsdMenu {
private:
  cOsdItem *Item(const char *text);
  static char *searchtext1;
  static char *searchtext2;
  static char *searchtext3;
  static char *searchtext4;
//  const char *rate[13];
  char data1[64];
  char data2[64];
  char data3[64];
  char data4[64];
  int Which;
  void SetHelp();
  void SetGenres();
  void GetRatingSearchText();
  void GetTheValues();
public:
  cMP3SearchValue(const char *Title, int which);
  virtual eOSState ProcessKey(eKeys Key);
  static const char *GetNewValue1(void) { return searchtext1; }
  static const char *GetNewValue2(void) { return searchtext2; }
  static const char *GetNewValue3(void) { return searchtext3; }
  static const char *GetNewValue4(void) { return searchtext4; }
};  

/*
class cMP3SearchMoreValue : public cOsdMenu {
private:
//  cOsdItem *Item(const char *text);
  static char *searchtext1;
  static char *searchtext2;
  static char *searchtext3;
  static char *searchtext4;
  char data1[64];
  char data2[64];
  int data3;
  int data4;
  void SetHelp();
//  void SetGenres();
//  void GetRatingSearchText();
  void GetTheValues();
public:
  cMP3SearchMoreValue(const char *Title);
  virtual eOSState ProcessKey(eKeys Key);
  static const char *GetNewValue1(void) { return searchtext1; }
  static const char *GetNewValue2(void) { return searchtext2; }
  static const char *GetNewValue3(void) { return searchtext3; }
  static const char *GetNewValue4(void) { return searchtext4; }
};  
*/



class cMP3Search : public cOsdMenu {
private:
 bool searching;
 char searchresult[256];
 eOSState Search(bool second);
 void SetHelp();
public:
 cMP3Search(void);
 virtual ~cMP3Search();
 virtual eOSState ProcessKey(eKeys Key);
};

/*
class cMP3Rating : public cOsdMenu {
private:
  cOsdItem *Item(const char *text);
 void SetHelp();
 void GetRatingText();
 eOSState SetRating(void);
public:
 cMP3Rating(void);
 virtual ~cMP3Rating();
 virtual eOSState ProcessKey(eKeys Key);
};
*/
  
#endif // __COMMANDS_H
