/*
 * avards.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#include "avards.h"
#include "setup.h"

extern cParameter config;

cMenuSetupAvards::cMenuSetupAvards(void)
{
  modes[0] = tr("auto");
  modes[1] = tr("force 4:3");
  modes[2] = tr("force L14:9");
  modes[3] = tr("force L16:9");
  modes[4] = tr("force L>16:9");
  modes[5] = tr("force 16:9");

  tmpconfig = config;


  Add(new cMenuEditBoolItem(tr("start/stop entry in main menu"), &tmpconfig.ShowInMainMenu, tr("no"), tr("yes")));
  Add(new cMenuEditBoolItem(tr("Auto start plugin"),             &tmpconfig.AutoStart, tr("no"), tr("yes")));
  Add(new cMenuEditStraItem(tr("WSS mode"),                      &tmpconfig.Mode, MAX_MODES, modes));
  Add(new cMenuEditBoolItem(tr("Enable L>16:9 in auto mode (2,4:1)"), &tmpconfig.Overzoom, tr("no"), tr("yes")));
  Add(new cMenuEditIntItem(tr("Pan tone tolerance"),             &tmpconfig.PanToneTolerance, 0, 255));
  Add(new cMenuEditIntItem(tr("Pan tone max. black"),            &tmpconfig.PanToneBlackMax, 0, 255));
  Add(new cMenuEditIntItem(tr("overscan (%)"),                   &tmpconfig.Overscan_pct, 0, 100));
  Add(new cMenuEditIntItem(tr("logo width (%)"),                 &tmpconfig.MaxLogoWidth_pct, 0, 100));
  Add(new cMenuEditIntItem(tr("poll rate (milliseconds)"),       &tmpconfig.PollRate, 80, 5000));
  Add(new cMenuEditIntItem(tr("delay (n polls)"),                &tmpconfig.Delay, 1, MAXDELAY));
  Add(new cMenuEditBoolItem(tr("test if frontend has lock"),     &tmpconfig.FrontendHasLockTest, tr("no"), tr("yes")));
}

void cMenuSetupAvards::Store(void)
{
  config = tmpconfig;
  SetupStore("ShowInMainMenu",     config.ShowInMainMenu);
  SetupStore("AutoStart",          config.AutoStart);
  SetupStore("Mode",               config.Mode);
  SetupStore("Overzoom",           config.Overzoom);
  SetupStore("PanToneTolerance",   config.PanToneTolerance);
  SetupStore("PanToneBlackMax",    config.PanToneBlackMax);
  SetupStore("Overscan",           config.Overscan_pct);
  SetupStore("LogoWidth",          config.MaxLogoWidth_pct);
  SetupStore("PollRate",           config.PollRate);
  SetupStore("Delay",              config.Delay);
  SetupStore("FEHasLock",          config.FrontendHasLockTest);
}
