
/*
 * Character mappings
 * An attempt to map Teletext characters into ISO-8859-1.
 * Trying to use similar looking or similar meaning
 * characters.
 */


/*
 * G0 and G2 national option table given Triplet 1 bits 14-11 and Control bits from C12-14
 * ETSI EN 300 706 Table 33
 */
uint8_t laG0_nat_opts_lookup[16][8] = {
  {1, 4, 11, 5, 3, 8, 0, 1},
  {7, 4, 11, 5, 3, 1, 0, 1},
  {1, 4, 11, 5, 3, 8, 12, 1},
  {1, 1, 1, 1, 1, 10, 1, 9},
  {1, 4, 2, 6, 1, 1, 0, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 5 - reserved
  {1, 1, 1, 1, 1, 1, 12, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 7 - reserved
  {1, 1, 1, 1, 3, 1, 1, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 9 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 11 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}, // 12 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}, // 13 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}, // 14 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}  // 15 - reserved
};


uint8_t laG0_nat_replace_map[128] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 7, 8,
9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 0
};


/*
 * Latin National Option Sub-Sets
 * ETSI EN 300 706 Table 36
 */

uint8_t laG0_nat_opts[13][14] = {
{0, '#', 'u', 'c', 't', 'z', '', '', 'r', '', '', 'e', '', 's'}, // 0 - Czech/Slovak
{0, '', '$', '@', '-', '', '-', '|', '#', '-', '', '#', '', ''}, // 1 - English
{0, '#', '', 'S', '', '', 'Z', '', '', 's', '', '', 'z', ''}, // 2 - Estonian
{0, '', '', '', '', '', '', '', '#', '', '', '', '', ''}, // 3 - French
{0, '#', '$', '', '', '', '', '^', '_', '', '', '', '', ''}, // 4 - German
{0, '', '$', '', '', '', '-', '|', '#', '', '', '', '', ''}, // 5 - Italian
{0, '#', '$', 'S', 'e', 'e', 'Z', 'c', 'u', 's', 'a', 'u', 'z', 'i'}, // 6 - Lettish/Lithuanian
{0, '#', 'n', 'a', 'Z', 'S', 'L', 'c', '', 'e', 'z', 's', 'l', 'z'}, // 7 - Polish
{0, '', '$', 'i', '', '', '', '', '', '', '', '', '', ''}, // 8 - Portuguese/Spanish
{0, '#', '', 'T', '', 'S', 'A', '', 'i', 't', '', 's', 'a', ''}, // 9 - Rumanian
{0, '#', '', 'C', 'C', 'Z', 'D', 'S', '', 'c', 'c', 'z', 'd', 's'}, // 10 - Serbian/Croation/Slovenian
{0, '#', '', '', '', '', '', '', '_', '', '', '', '', ''}, // 11 - Swedish/Finnish/Hungarian
{0, 'T', 'g', 'I', 'S', '', '', '', 'G', 'i', 's', '', '', ''}  // 12 - Turkish
};

uint16_t laG0_nat_opts16[13][14] = {
{0, '#',    'u',    'c',    't',    'z',    0xc3bd, 0xc3ad, 'r',    0xc3a9, 0xc3a1, 'e',    0xc3ba, 's'   }, // 0 - Czech/Slovak
{0, 0xc2a3, '$',    '@',    '-',    0xc2bd, '-',    '|',    '#',    '-',    0xc2bc, '#',    0xc2be, 0xc3b7}, // 1 - English
{0, '#',    0xc3b5, 'S',    0xc384, 0xc396, 'Z',    0xc39c, 0xc395, 's',    0xc3a4, 0xc3b6, 'z',    0xc3bc}, // 2 - Estonian
{0, 0xc3a9, 0xc3af, 0xc3a0, 0xc3ab, 0xc3aa, 0xc3b9, 0xc3ae, '#',    0xc3a8, 0xc3a2, 0xc3b4, 0xc3bb, 0xc3a7}, // 3 - French
{0, '#',    '$',    0xc2a7, 0xc384, 0xc396, 0xc39c, '^',    '_',    0xc2ba, 0xc3a4, 0xc3b6, 0xc3bc, 0xc39f}, // 4 - German
{0, 0xc2a3, '$',    0xc3a9, 0xc2ba, 0xc3a7, '-',    '|',    '#',    0xc3b9, 0xc3a0, 0xc3b2, 0xc3a8, 0xc3ac}, // 5 - Italian
{0, '#',    '$',    'S',    'e',    'e',    'Z',    'c',    'u',    's',    'a',    'u',    'z',    'i'   }, // 6 - Lettish/Lithuanian
{0, '#',    'n',    'a',    'Z',    'S',    'L',    'c',    0xc3b3, 'e',    'z',    's',    'l',    'z'   }, // 7 - Polish
{0, 0xc3a7, '$',    'i',    0xc3a1, 0xc3a9, 0xc3ad, 0xc3b3, 0xc3ba, 0xc2bf, 0xc3bc, 0xc3b1, 0xc3a8, 0xc3a0}, // 8 - Portuguese/Spanish
{0, '#',    0xc2a4, 'T',    0xc382, 'S',    'A',    0xc38e, 'i',    't',    0xc3a2, 's',    'a',    0xc3ae}, // 9 - Rumanian
{0, '#',    0xc38b, 'C',    'C',    'Z',    'D',    'S',    0xc3ab, 'c',    'c',    'z',    'd',    's'   }, // 10 - Serbian/Croation/Slovenian
{0, '#',    0xc2a4, 0xc389, 0xc384, 0xc396, 0xc385, 0xc39c, '_',    0xc3a9, 0xc3a4, 0xc3b6, 0xc3a5, 0xc3bc}, // 11 - Swedish/Finnish/Hungarian
{0, 'T',    'g',    'I',    'S',    0xc396, 0xc387, 0xc39c, 'G',    'i',    's',    0xc3b6, 0xc3a7, 0xc3bc}  // 12 - Turkish
};

/*
 * Latin G2 Set
 * ETSI EN 300 706 Table 37
 */
uint8_t laG2_la1_table[] = {
'?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
'?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
'', '', '', '', '$', '', '#', '', '', '', '"', '', '-', '|', '-', '|',
'', '', '', '', '', '', '', '', '', '\'', '"', '', '', '', '', '',
' ', '`', '', '^', '~', '-', '?', '', '', '.', '', '', '_', '"', '?', '?',
'-', '', '', '', 'T', '?', 'C', 'p', '?', ' ', ' ', ' ', '?', '?', '?', '?',
'?', '', 'D', 'a', '?', '?', ' ', 'I', 'L', 'L', '', '', 'o', 'P', 'n', 'n',
'k', '', 'd', 'd', 'h', 'i', 'i', 'l', 'l', '', '', '', 'p', 't', 'n', '?'
};

uint16_t laG2_la1_table16[] = {
'?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',
'?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',    '?',
0xc2a0, 0xc2a1, 0xc2a2, 0xc2a3, '$',    0xc2a5, '#',    0xc2a7, 0xc2a4, 0xc2b4, '"',    0xc2ab, '-',    '|',    '-',    '|',
0xc2b0, 0xc2b1, 0xc2b2, 0xc2b3, 0xc397, 0xc2b5, 0xc2b6, 0xc2b7, 0xc3b7, '\'',   '"',    0xc2bb, 0xc2bc, 0xc2bd, 0xc2be, 0xc2bf,
' ',    '`',    0xc2b4, '^',    '~',    '-',    '?',    0xc2b7, 0xc2a8, '.',    0xc2ba, 0xc2b8, '_',    '"',    '?',    '?',
'-',    0xc2b9, 0xc2ae, 0xc2a9, 'T',    '?',    'C',    'p',    '?',    ' ',    ' ',    ' ',    '?',    '?',    '?',    '?',
'?',    0xc386, 'D',    'a',    '?',    '?',    ' ',    'I',    'L',    'L',    0xc398, 0xc396, 'o',    'P',    'n',    'n',
'k',    0xc3a6, 'd',    'd',    'h',    'i',    'i',    'l',    'l',    0xc3b8, 0xc3b6, 0xc39f, 'p',    't',    'n',    '?'
};
