#ifndef __MP3NG_H
#define __MP3NG_H

#include <string.h>

#include <vdr/plugin.h>

#include "version.h"
#include "i18n.h"
#include "common.h"
#include "setup-mp3.h"
#include "setup.h"
#include "menubrowse.h"

static const char *VERSION        = PLUGIN_VERSION;
static const char *DESCRIPTION    = "Next Generation audio player";
static const char *MAINMENUENTRY  = "MP3-NextGen"; 

class cPluginMp3 : public cPlugin {
public:
  cPluginMp3(void);
  virtual ~cPluginMp3();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return tr(DESCRIPTION); }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void);
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
};

class cMenuSetupMP3 : public cMenuSetupPage {
private:
  //
  const char *sathemes[eSAThemeMaxNumber];
  const char *cddb[3], *scan[3], *bgr[3], *coversize[4];
  const char *aout[AUDIOOUTMODES];
  int amode, amodes[AUDIOOUTMODES];
protected:
  virtual void Store(void);
public:
  cMenuSetupMP3(void);
};


#endif // __MP3NG_H
