/*
 * quickepgsearch.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */
#include <string>
#include <list>
#include <vdr/plugin.h>
#if APIVERSNUM < 10507
#include "i18n.h"
#define trNOOP(s) (s)
#endif
#include "services.h"
#include "mainmenushortcut.h"

static const char VERSION[]        = "0.0.1";
static const char DESCRIPTION[]    = trNOOP("Quick search for broadcasts");
static const char MAINMENUENTRY[]  = trNOOP("Quick search");
static const char SETUPTEXT[]      = trNOOP("Show in main menu");

#if APIVERSNUM < 10507
const tI18nPhrase Phrases[] =
{
    {
        "Quick search for broadcasts",
        "Schnelle Suche nach Sendungen",// Deutsch
        "",// TODO 
        "",// TODO
        "",// TODO
        "",// TODO 
        "",// TODO
        "",// TODO 
        "Pikahaku ohjelmaoppaalle",// suomi
        "",// TODO Polski
        "",// TODO Espaol
        "",// TODO  (Greek)
        "",// TODO Svenska
        "",// TODO Romaneste
        "",// TODO Magyar
        "",// TODO Catal
        "",// TODO  (Russian)
        "",// TODO Hrvatski (Croatian)
        "", // Eesti
        "", // Dansk
        "", // Czech
    },
    {
        "Quick search",
        "Schnellsuche",
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "Pikahaku",
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "", // Eesti
        "", // Dansk
        "", // Czech
    },
    {
        "Show in main menu",
        "Im Hauptmen anzeigen",
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "Nyt valinta pvalikossa",
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "",// TODO
        "", // Eesti
        "", // Dansk
        "", // Czech
    },
    { NULL }
};
#endif
  
class cPluginQuicksearch : public cMainMenuShortcut
{
    public:
        virtual const char* Version() { return VERSION; }
#if APIVERSNUM < 10507
        virtual const char* Description() { return tr(DESCRIPTION); }
#else
        virtual const char* Description() { return I18nTranslate(DESCRIPTION, "epgsearch"); }
#endif
        virtual bool Initialize();
        virtual cOsdObject* MainMenuAction() { return GetEpgSearchMenu("Epgsearch-quicksearch-v1.0"); };

    protected:
#if APIVERSNUM < 10507
        virtual const char* SetupText() { return tr(SETUPTEXT); }
        virtual const char* MainMenuText() { return tr(MAINMENUENTRY); };
#else
        virtual const char* SetupText() { return I18nTranslate(SETUPTEXT, "epgsearch"); }
        virtual const char* MainMenuText() { return I18nTranslate(MAINMENUENTRY, "epgsearch"); }
#endif
};

bool cPluginQuicksearch::Initialize()
{
#if APIVERSNUM < 10507
    RegisterI18n(Phrases);
#endif
    return cMainMenuShortcut::Initialize();
}

VDRPLUGINCREATOR(cPluginQuicksearch); // Don't touch this!
