#include "menu_timersdone.h"
#include "epgsearchtools.h"

int sortModeTimerDone = 0;

cMenuTimerDoneItem::cMenuTimerDoneItem(cTimerDone* TimerDone)
{
   timerDone = TimerDone;
   Set();
}

void cMenuTimerDoneItem::Set(void)
{
   if (!timerDone)
      return;
   char *buffer = NULL;
    
   char buf[32];
   struct tm tm_r;
   tm *tm = localtime_r(&timerDone->start, &tm_r);
   strftime(buf, sizeof(buf), "%d.%m.%y %H:%M", tm);

   const cChannel* ch = Channels.GetByChannelID(timerDone->channelID, true, true);
   asprintf(&buffer, "%d\t%s\t%s~%s", ch?ch->Number():0, buf, timerDone->title.c_str(), timerDone->shorttext.c_str());
   SetText(buffer, false);
}

int cMenuTimerDoneItem::Compare(const cListObject &ListObject) const
{
   cMenuTimerDoneItem *p = (cMenuTimerDoneItem *)&ListObject;
   if (sortModeTimerDone == 0) // sort by Date
      if (timerDone->start > p->timerDone->start) return 1; else return -1;
   else
   {
      char* s1 = NULL;
      char* s2 = NULL;
      asprintf(&s1, "%s~%s", timerDone->title.c_str(), timerDone->shorttext.c_str());
      asprintf(&s2, "%s~%s", p->timerDone->title.c_str(), p->timerDone->shorttext.c_str());
      int res = strcasecmp(s1, s2);
      free(s1);
      free(s2);
      return res;
   }
}

// --- cMenuTimersDone ----------------------------------------------------------
cMenuTimersDone::cMenuTimersDone(cSearchExt* Search)
   :cOsdMenu("", 4, 15)
{
   search = Search;
   showAll = true;
   sortModeTimerDone = 0;
   if (search) showAll = false;
   Set();
   Display();
}

void cMenuTimersDone::Set()
{
   Clear();
   eventObjects.Clear();
   cMutexLock TimersDoneLock(&TimersDone);
   cTimerDone* timerDone = TimersDone.First();
   while (timerDone) {
      if (showAll || (!showAll && search && timerDone->searchID == search->ID))
         Add(new cMenuTimerDoneItem(timerDone));
      timerDone = TimersDone.Next(timerDone);
   }
   UpdateTitle();
   SetHelp(sortModeTimerDone==0?tr("Button$by name"):tr("Button$by date"), tr("Button$Delete all"), tr("Button$Delete"), showAll?search->search:tr("Button$Show all"));
   Sort();

   cMenuTimerDoneItem* item = (cMenuTimerDoneItem*)First();
   while(item)
   {
      if (item->timerDone)
      {
         const cEvent* Event = item->timerDone->GetEvent();
         if (Event) eventObjects.Add(Event);
      }
      item = (cMenuTimerDoneItem*)Next(item);
   }
}

void cMenuTimersDone::UpdateCurrent()
{
   // navigation in summary could have changed current item, so update it
   cEventObj* cureventObj = eventObjects.GetCurrent();
   if (cureventObj && cureventObj->Event())
      for (cMenuTimerDoneItem *item = (cMenuTimerDoneItem *)First(); item; item = (cMenuTimerDoneItem *)Next(item)) 
         if (item->timerDone->GetEvent() == cureventObj->Event())
         {
            cureventObj->Select(false);
            SetCurrent(item);
            Display();
            break;
         }               
}

cTimerDone *cMenuTimersDone::CurrentTimerDone(void)
{
   cMenuTimerDoneItem *item = (cMenuTimerDoneItem *)Get(Current());
   return item ? item->timerDone : NULL;
}

void cMenuTimersDone::UpdateTitle()
{
   char *buffer = NULL;
   asprintf(&buffer, "%d %s%s%s", Count(), tr("Timers"), showAll?"":" ", showAll?"":search->search);
   SetTitle(buffer);
   Display();
   free(buffer);
}

eOSState cMenuTimersDone::Delete(void)
{
   cTimerDone *curTimerDone = CurrentTimerDone();
   if (curTimerDone) {
      if (Interface->Confirm(tr("Edit$Delete entry?"))) {
         LogFile.Log(1,"deleted timer done: '%s~%s'", curTimerDone->title!=""?curTimerDone->title.c_str():"unknown title", curTimerDone->shorttext!=""?curTimerDone->shorttext.c_str():"unknown subtitle");
         cMutexLock TimersDoneLock(&TimersDone);
         TimersDone.Del(curTimerDone);
         TimersDone.Save();
         cOsdMenu::Del(Current());
         Display();
         UpdateTitle();
      }
   }
   return osContinue;
}

eOSState cMenuTimersDone::DeleteAll(void)
{
   if (Interface->Confirm(tr("Edit$Delete all entries?"))) {
      cMutexLock TimersDoneLock(&TimersDone);
      while(Count()>0)
      {
         cMenuTimerDoneItem *item = (cMenuTimerDoneItem *)Get(0);
         if (!item) break;
         cTimerDone *curTimerDone = item->timerDone;
         TimersDone.Del(curTimerDone);
         cOsdMenu::Del(0);
      }
      TimersDone.Save();
      Display();
      UpdateTitle();
   }

   return osContinue;
}

eOSState cMenuTimersDone::ProcessKey(eKeys Key)
{
   bool HadSubMenu = HasSubMenu();
   eOSState state = cOsdMenu::ProcessKey(Key);
   if (!HasSubMenu() && HadSubMenu)
      UpdateCurrent();

   if (state == osUnknown) {
      switch (Key) {
         case kGreen:
            state = DeleteAll();
            break;
         case kYellow:
            state = Delete();
            break;
         case kBlue:
            if(!HasSubMenu()) {
               showAll = !showAll;
               Set();
               Display();
            }
            break;
         case k0:
         case kRed:
            if(!HasSubMenu()) {
               sortModeTimerDone = 1-sortModeTimerDone;
               Set();
               Display();
            }
            break;
         case k8:
            return osContinue;
         case kOk:
         {
            cTimerDone *TimerDone = CurrentTimerDone();
            const cEvent* Event = TimerDone->GetEvent();
            if (!Event) break;
            return AddSubMenu(new cMenuEventSearchSimple(Event, eventObjects));
         }
         default: break;
      }
   }

   return state;
}


