#include "menu_recsdone.h"
#include "epgsearchtools.h"

int sortModeRecDone = 0;

cMenuRecDoneItem::cMenuRecDoneItem(cRecDone* RecDone)
{
  recDone = RecDone;
  Set();
}

void cMenuRecDoneItem::Set(void)
{
    if (!recDone)
	return;
    char *buffer = NULL;
    
    char buf[32];
    struct tm tm_r;
    tm *tm = localtime_r(&recDone->startTime, &tm_r);
    strftime(buf, sizeof(buf), "%d.%m.%y %H:%M", tm);

    asprintf(&buffer, "%s\t%s~%s", buf, recDone->title?recDone->title:"", recDone->shortText?recDone->shortText:"");
    SetText(buffer, false);
}

int cMenuRecDoneItem::Compare(const cListObject &ListObject) const
{
    cMenuRecDoneItem *p = (cMenuRecDoneItem *)&ListObject;
    if (sortModeRecDone == 0) // sort by Date
	if (recDone->startTime > p->recDone->startTime) return 1; else return -1;
    else
    {
	char* s1 = NULL;
	char* s2 = NULL;
	asprintf(&s1, "%s~%s", recDone->title?recDone->title:"", recDone->shortText?recDone->shortText:"");
	asprintf(&s2, "%s~%s", p->recDone->title?p->recDone->title:"", p->recDone->shortText?p->recDone->shortText:"");
	int res = strcasecmp(s1, s2);
	free(s1);
	free(s2);
	return res;
    }
}

// --- cMenuRecsDone ----------------------------------------------------------
cMenuRecsDone::cMenuRecsDone(cSearchExt* Search)
:cOsdMenu("", 15)
{
    search = Search;
    showAll = true;
    sortModeRecDone = 0;
    if (search) showAll = false;
    Set();
    Display();
}

void cMenuRecsDone::Set()
{
    Clear();
    cMutexLock RecsDoneLock(&RecsDone);
    cRecDone* recDone = RecsDone.First();
    while (recDone) {
	if (showAll || (!showAll && search && recDone->searchID == search->ID))
	    Add(new cMenuRecDoneItem(recDone));
	recDone = RecsDone.Next(recDone);
    }
    UpdateTitle();
    SetHelp(sortModeRecDone==0?tr("Button$by name"):tr("Button$by date"), tr("Button$Delete all"), tr("Button$Delete"), showAll?search->search:tr("Button$Show all"));
    Sort();
}

cRecDone *cMenuRecsDone::CurrentRecDone(void)
{
    cMenuRecDoneItem *item = (cMenuRecDoneItem *)Get(Current());
    return item ? item->recDone : NULL;
}

void cMenuRecsDone::UpdateTitle()
{
    char *buffer = NULL;
    asprintf(&buffer, "%d %s%s%s", Count(), tr("Recordings"), showAll?"":" ", showAll?"":search->search);
    SetTitle(buffer);
    Display();
    free(buffer);
}

eOSState cMenuRecsDone::Delete(void)
{
    cRecDone *curRecDone = CurrentRecDone();
    if (curRecDone) {
	if (Interface->Confirm(tr("Edit$Delete entry?"))) {
	    LogFile.Log(1,"deleted recording done: '%s~%s'", curRecDone->title?curRecDone->title:"unknown title", curRecDone->shortText?curRecDone->shortText:"unknown subtitle");
	    cMutexLock RecsDoneLock(&RecsDone);
	    RecsDone.Del(curRecDone);
	    RecsDone.Save();
	    cOsdMenu::Del(Current());
	    Display();
	    UpdateTitle();
	}
    }
    return osContinue;
}

eOSState cMenuRecsDone::DeleteAll(void)
{
    if (Interface->Confirm(tr("Edit$Delete all entries?"))) {
	cMutexLock RecsDoneLock(&RecsDone);
	while(Count()>0)
	{
	    cMenuRecDoneItem *item = (cMenuRecDoneItem *)Get(0);
	    if (!item) break;
	    cRecDone *curRecDone = item->recDone;
	    RecsDone.Del(curRecDone);
	    cOsdMenu::Del(0);
	}
	RecsDone.Save();
	Display();
	UpdateTitle();
    }

    return osContinue;
}

eOSState cMenuRecsDone::Summary(void)
{
    if (HasSubMenu() || Count() == 0)
	return osContinue;
    cRecDone* recDone = CurrentRecDone();
    if (recDone && !isempty(recDone->description))
	return AddSubMenu(new cMenuTextDone(tr("Summary"), recDone));
    return osContinue;
}

eOSState cMenuRecsDone::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);
  if (state == osUnknown) {
    switch (Key) {
	case kOk:
	    state = Summary();
	    break;
	case kGreen:
	    state = DeleteAll();
	    break;
	case kYellow:
	    state = Delete();
	    break;
	case kBlue:
	    showAll = !showAll;
	    Set();
	    Display();
	    break;
	case k0:
	case kRed:
	    sortModeRecDone = 1-sortModeRecDone;
	    Set();
	    Display();
	    break;
	case k8:
	    return osContinue;
      default: break;
    }
  }

  return state;
}

eOSState cMenuTextDone::ProcessKey(eKeys Key)
{
    eOSState state = cMenuText::ProcessKey(Key);
    if (state == osContinue) {
	switch (Key) {
	    case kBlue:
		if (recDone->aux) return AddSubMenu(new cMenuText(tr("Auxiliary info"), recDone->aux));		
		break;
	    case kOk: return osBack;
	    default:  state = osContinue;
	}
    }
    return state;
}

// --- cMenuTextDone ----------------------------------------------------------
cMenuTextDone::cMenuTextDone(const char *Title, cRecDone* RecDone, eDvbFont Font) 
: cMenuText(Title, RecDone->description, Font), recDone(RecDone) 
{
  if (recDone->aux) SetHelp(NULL, NULL, NULL, tr("Button$Aux info"));
}
  
