/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import org.htmlparser.Node;
import org.htmlparser.scanners.ScriptScanner;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.SimpleNodeIterator;

public class ScriptTag
extends CompositeTag {
    private static final String[] mIds = new String[]{"SCRIPT"};
    private static final String[] mEndTagEnders = new String[]{"BODY", "HTML"};
    protected String mCode;

    public ScriptTag() {
        this.setThisScanner(new ScriptScanner());
    }

    public String[] getIds() {
        return mIds;
    }

    public String[] getEndTagEnders() {
        return mEndTagEnders;
    }

    public String getLanguage() {
        return this.getAttribute("LANGUAGE");
    }

    public String getScriptCode() {
        String ret = null != this.mCode ? this.mCode : this.getChildrenHTML();
        return ret;
    }

    public void setScriptCode(String code) {
        this.mCode = code;
    }

    public String getType() {
        return this.getAttribute("TYPE");
    }

    public void setLanguage(String language) {
        this.setAttribute("LANGUAGE", language);
    }

    public void setType(String type) {
        this.setAttribute("TYPE", type);
    }

    protected void putChildrenInto(StringBuffer sb) {
        if (null != this.getScriptCode()) {
            sb.append(this.getScriptCode());
        } else {
            SimpleNodeIterator e = this.children();
            while (e.hasMoreNodes()) {
                Node node = e.nextNode();
                sb.append(node.toHtml());
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Script Node : \n");
        if (this.getLanguage() != null || this.getType() != null) {
            sb.append("Properties -->\n");
            if (this.getLanguage() != null && this.getLanguage().length() != 0) {
                sb.append("[Language : " + this.getLanguage() + "]\n");
            }
            if (this.getType() != null && this.getType().length() != 0) {
                sb.append("[Type : " + this.getType() + "]\n");
            }
        }
        sb.append("\n");
        sb.append("Code\n");
        sb.append("****\n");
        sb.append(this.getScriptCode() + "\n");
        return sb.toString();
    }
}

