#ifndef __OSDCONTROLLER_H
#define __OSDCONTROLLER_H

#include "tools.h"


#define MAX_OSD_LISTENERS 10

class cOsdProvider;
class cOsd;
class cMutex;

namespace NonInteractiveOsdPatch
{

  class cOsdListener
  {
    
  public:
    virtual ~cOsdListener() {};
    virtual void Show() = 0;
    virtual void Hide() = 0;

  };
    
  class cListenerListObject;

  class cOsdController
  {
  public:
    cOsdController();
    ~cOsdController();
    bool Subscribe( int priority, cOsdListener* listener );
    void Unsubscribe( cOsdListener* listner );

  private:
    friend class ::cOsdProvider;
    friend class ::cOsd;
    void Show();
    void Hide();
    void ShowHighest();

    bool iShowing;
    cMutex* iMutex;
    cListenerListObject* iCurrent;
    cList<cListenerListObject>* iListeners;

  };
  extern cOsdController OsdController;

}
#endif
