
/*
 * Character mappings
 * An attempt to map Teletext characters into ISO-8859-1.
 * Trying to use similar looking or similar meaning
 * characters.
 */


/*
 * G0 and G2 national option table given Triplet 1 bits 14-11 and Control bits from C12-14
 * ETSI EN 300 706 Table 33
 */
uint8_t laG0_nat_opts_lookup[16][8] = {
  {1, 4, 11, 5, 3, 8, 0, 1},
  {7, 4, 11, 5, 3, 1, 0, 1},
  {1, 4, 11, 5, 3, 8, 12, 1},
  {1, 1, 1, 1, 1, 10, 1, 9},
  {1, 4, 2, 6, 1, 1, 0, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 5 - reserved
  {1, 1, 1, 1, 1, 1, 12, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 7 - reserved
  {1, 1, 1, 1, 3, 1, 1, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 9 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1},
  {1, 1, 1, 1, 1, 1, 1, 1}, // 11 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}, // 12 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}, // 13 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}, // 14 - reserved
  {1, 1, 1, 1, 1, 1, 1, 1}  // 15 - reserved
};


uint8_t laG0_nat_replace_map[128] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 7, 8,
9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 0
};


/*
 * Latin National Option Sub-Sets
 * ETSI EN 300 706 Table 36
 */

uint8_t laG0_nat_opts[13][14] = {
{0, '#', 'u', 'c', 't', 'z', '', '', 'r', '', '', 'e', '', 's'}, // 0 - Czech/Slovak
{0, '', '$', '@', '-', '', '-', '|', '#', '-', '', '#', '', ''}, // 1 - English
{0, '#', '', 'S', '', '', 'Z', '', '', 's', '', '', 'z', ''}, // 2 - Estonian
{0, '', '', '', '', '', '', '', '#', '', '', '', '', ''}, // 3 - French
{0, '#', '$', '', '', '', '', '^', '_', '', '', '', '', ''}, // 4 - German
{0, '', '$', '', '', '', '-', '|', '#', '', '', '', '', ''}, // 5 - Italian
{0, '#', '$', 'S', 'e', 'e', 'Z', 'c', 'u', 's', 'a', 'u', 'z', 'i'}, // 6 - Lettish/Lithuanian
{0, '#', 'n', 'a', 'Z', 'S', 'L', 'c', '', 'e', 'z', 's', 'l', 'z'}, // 7 - Polish
{0, '', '$', 'i', '', '', '', '', '', '', '', '', '', ''}, // 8 - Portuguese/Spanish
{0, '#', '', 'T', '', 'S', 'A', '', 'i', 't', '', 's', 'a', ''}, // 9 - Rumanian
{0, '#', '', 'C', 'C', 'Z', 'D', 'S', '', 'c', 'c', 'z', 'd', 's'}, // 10 - Serbian/Croation/Slovenian
{0, '#', '', '', '', '', '', '', '_', '', '', '', '', ''}, // 11 - Swedish/Finnish/Hungarian
{0, 'T', 'g', 'I', 'S', '', '', '', 'G', 'i', 's', '', '', ''}  // 12 - Turkish
};

/*
 * Latin G2 Set
 * ETSI EN 300 706 Table 37
 */
uint8_t laG2_la1_table[] = {
'?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
'?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
'', '', '', '', '$', '', '#', '', '', '', '"', '', '-', '|', '-', '|',
'', '', '', '', '', '', '', '', '', '\'', '"', '', '', '', '', '', 
' ', '`', '', '^', '~', '-', '?', '', '', '.', '', '', '_', '"', '?', '?',
'-', '', '', '', 'T', '?', 'C', 'p', '?', ' ', ' ', ' ', '?', '?', '?', '?',
'?', '', 'D', 'a', '?', '?', ' ', 'I', 'L', 'L', '', '', 'o', 'P', 'n', 'n',
'k', '', 'd', 'd', 'h', 'i', 'i', 'l', 'l', '', '', '', 'p', 't', 'n', '?'
};
