/*
 * trayopen.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 */
#include <getopt.h>
#include <stdlib.h>
#include <vdr/plugin.h>
#if VDRVERSNUM >= 10332
#include <vdr/remote.h>
#endif
#include <vdr/interface.h>
#include "setup.h"

#include "i18n.h"

#include "cdstatus.h"

static const char *VERSION = "0.0.4pre3";
static const char *DESCRIPTION = "Open/Close CD/DVD-Rom";
static const char *MAINMENUENTRY = "Trayopen";

// --------------- Setup menu -------------------

class cPluginTrayopen;

class cMenuTrayopenSetup : public cMenuSetupPage {
private:
  cPluginTrayopen *Plugin;
protected:
  virtual void Store(void);

public:
  cMenuTrayopenSetup(cPluginTrayopen *plugin);
}; 


//----------------- Plugin ----------------------

class cPluginTrayopen : public cPlugin {
private:
protected:
  cCDStatus *cdStatus;
public:
  cPluginTrayopen(void);
  virtual ~cPluginTrayopen();
  virtual const char *Version(void) {return VERSION; }
  virtual const char *Description(void) { return tr(DESCRIPTION); }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void); 
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void) { return TrayopenSetup.HideMainMenuEntry ? NULL : tr(MAINMENUENTRY); } 
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  virtual void SaveSetup(void);
};

// --- cPluginTrayopen ----------------------------------------------------------

cPluginTrayopen::cPluginTrayopen(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
}

cPluginTrayopen::~cPluginTrayopen()
{
  // Clean up after yourself!
  if (cdStatus)
    delete(cdStatus);
}


const char *cPluginTrayopen::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginTrayopen::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginTrayopen::Initialize(void)
{
  // Initialize any background activities the plugin shall perform.
  return true;
} 


bool cPluginTrayopen::Start(void)
{
  // Start any background activities the plugin shall perform.
  RegisterI18n(Phrases);
  cPlugin *p = cPluginManager::GetPlugin("vdrcd");
  cdStatus=new cCDStatus(p);
  return (cdStatus && cdStatus->Start());
}

void cPluginTrayopen::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

cOsdObject *cPluginTrayopen::MainMenuAction(void)
{
  if (cdStatus)
    cdStatus->OpenCloseRequest();
  return NULL;
}


cMenuSetupPage *cPluginTrayopen::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cMenuTrayopenSetup(this);
} 


bool cPluginTrayopen::SetupParse(const char *Name, const char *Value)
{
  // Parse your own setup parameters and store their values.
  if      (!strcasecmp(Name,"HideMainMenuEntry"))  TrayopenSetup.HideMainMenuEntry = atoi(Value);
  else if (!strcasecmp(Name,"Device"))             strn0cpy(TrayopenSetup.Device, Value, sizeof(TrayopenSetup.Device));
  else if (!strcasecmp(Name,"CDAutoStart"))	   TrayopenSetup.CDAutoStart       = atoi(Value);
  else if (!strcasecmp(Name,"LockTrayButton"))	   TrayopenSetup.LockTrayButton    = atoi(Value);
  else return false;
//  SaveSetup();
  return true;
}

void cPluginTrayopen::SaveSetup(void)
{
  if (cdStatus)
    cdStatus->SetConfig();
}

cMenuTrayopenSetup::cMenuTrayopenSetup(cPluginTrayopen *plugin)
{
  static const char allowed[] = { " abcdefghijklmnopqrstuvmxyz0123456789-./" };
  Plugin = plugin;
  Add(new cMenuEditBoolItem(tr("Hide mainmenu entry"), &TrayopenSetup.HideMainMenuEntry));
  Add(new cMenuEditStrItem( tr("Device"),               TrayopenSetup.Device, 255, allowed));
  Add(new cMenuEditBoolItem(tr("Disc autostart"),      &TrayopenSetup.CDAutoStart));
  Add(new cMenuEditBoolItem(tr("Lock tray button"),    &TrayopenSetup.LockTrayButton));
}


void cMenuTrayopenSetup::Store(void)
{
  SetupStore("HideMainMenuEntry", TrayopenSetup.HideMainMenuEntry);
  SetupStore("Device",            TrayopenSetup.Device);
  SetupStore("CDAutoStart", 	  TrayopenSetup.CDAutoStart);
  SetupStore("LockTrayButton",    TrayopenSetup.LockTrayButton);
  Plugin->SaveSetup();
} 

VDRPLUGINCREATOR(cPluginTrayopen); // Don't touch this!
