/*
 * MP3/MPlayer plugin to VDR (C++)
 *
 * (C) 2001-2005 Stefan Huelswitt <s.huelswitt@gmx.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#ifndef ___SETUP_MP3_H
#define ___SETUP_MP3_H

extern const char *cddbpath;
extern const char *netscript;
#ifdef WITH_OSS
extern const char *dspdevice;
#endif

// ----------------------------------------------------------------

#define DEFAULT_TARGET_LEVEL  25
#define MAX_TARGET_LEVEL      50
#define DEFAULT_LIMITER_LEVEL 70
#define MIN_LIMITER_LEVEL     25

#define MAX_HOSTNAME 128

#define AUDIOOUTMODES    2
#define AUDIOOUTMODE_DVB 0
#define AUDIOOUTMODE_OSS 1

enum eSAModes {
  eSAModeMaxNumber
};  

class cMP3Setup {
public:
  cMP3Setup(void);
  int InitLoopMode;
  int InitShuffleMode;
  int AudioMode;
  int BgrScan;
  int EditorMode;
  int DisplayMode;
  int UseDeviceStillPicture;
  int MenuMode;
  int TargetLevel;
  int LimiterLevel;
  int Only48kHz;
  int UseProxy;
  char ProxyHost[MAX_HOSTNAME];
  int ProxyPort;
  int UseCddb;
  char CddbHost[MAX_HOSTNAME];
  int CddbPort;
  int AudioOutMode;
  int AbortAtEOL;
//  int ReplayDisplay;
  int HideMainMenu;
  int KeepSelect;
  int ExitClose;
  char CopyDir[256];
  char RecordDir[256];
  char RecordOpts[256];
  char CoverDir[256];
  int Jumptime;
  int AdminMode;
  int EnableRating;
  char RateCompat[256];
  int RateInFile;
  int RatingFirst;
  int OSDoffsetx;
  int OSDoffsety;
  int Rowcount;
  int ArtistFirst;
  int Coversize;
#ifdef HAVE_VDR_SPEZIAL
  int FullSize;
#endif
  int ShowFileName;
  int MaxResult;
  int ImgAlpha;
  int ImgDither;
  int EnableSpectrumAnalyzer;
  int ThemesSA;
  int FalloffSA;
#ifdef HAVE_MAGICK
  int MaxCacheFill;
  int ImgAspect;
  int ImgTreeDepth;
#endif
  };



extern cMP3Setup MP3Setup;

enum eSAThemes
{
  e1_SA8,
  e1_SA16,
  e1_SA32,
  e1_SA64,
  e2_SA4,
  e2_SA8,
  e2_SA16,
  e2_SA32,
  e2_SAVol,
  eSAThemeMaxNumber
};  

struct cSATheme
{
  int Visualization;
  int ChannelsSA;
  int BandsSA;
};  


extern const cSATheme satheme[eSAThemeMaxNumber];


#endif //___SETUP_MP3_H
