
#include <string>
#include <fstream>

#include <vdr/interface.h>
#include <vdr/menu.h>
#include <vdr/plugin.h>

#ifdef HAVE_ICONPATCH
#include <vdr/iconpatch.h>
#endif

#include "rating.h"
#include "i18n.h"
#include "player-mp3.h"
#include "data-mp3.h"
#include "decoder.h"
#include "mp3control.h"
#include "skin.h"


//---------------- cMP3Rating --------------------------------------------------------------------------------------------------------------------------

/*
class cMP3Rating : public cOsdMenu {
private:
  cOsdItem *Item(const char *text);
  void SetHelp();
  void GetRatingText();
  eOSState SetRating(void);
public:
  cMP3Rating(void);
  virtual eOSState ProcessKey(eKeys Key);
};
*/

cMP3Rating::cMP3Rating(void)
:cOsdMenu(tr("MP3ng Rating"))
{
  GetRatingText();
  SetHelp();
  
//  Add(new cOsdItem(hk("LOS MACH ES")));

  Display();
}


cMP3Rating::~cMP3Rating()
{

}


void cMP3Rating::SetHelp() {
  cOsdMenu::SetHelp(tr("Parent"),NULL,NULL,tr("GO"));
}


cOsdItem *cMP3Rating::Item(const char *text)
{
  char *buf=0;
  asprintf(&buf,"%s",text?text:"");
  cOsdItem *item = new cOsdItem(buf,osUnknown,true);
//  item->SetSelectable(true);
  free(buf);
  Add(item); return item;
}


void cMP3Rating::GetRatingText() {

  std::ifstream filestr;
  std::string datei;
  std::string line;
  int count=0;

  datei=cPlugin::ConfigDirectory(i18n_name);
  datei=datei + "/data/ratinggettext.dat";

  filestr.open (datei.c_str());

  
  if(filestr) {
    while ((getline(filestr,line,'\n'))) {
      count++;
      char content[64];
      strcpy(content,line.c_str()); 
      Item(content);
    }
    
    filestr.close();
  }
}


eOSState cMP3Rating::SetRating(void) {

  int rating=0;
  int current = Current();

  switch(current) {
        case 0: 
           rating=3; // Bombe , sehr schlecht
	   break;
        case 1: 
           rating=28;  // 0,5
	   break;
        case 2: 
           rating=53;  // 1
	   break;
        case 3: 
           rating=78;  // 1,5
	   break;
        case 4: 
           rating=104;  // 2
	   break;
        case 5: 
           rating=129;  // 2,5
	   break;
        case 6: 
           rating=154;  // 3
	   break;
        case 7: 
           rating=179;  // 3,5
	   break;
        case 8: 
           rating=205;  // 4
	   break;
        case 9: 
           rating=230;  // 4,5
	   break;
        case 10: 
           rating=255;  // 5
	   break;
  }


  if(MP3Setup.RateInFile) {
    FILE *cmd;
    char *buffer;

    d(printf("MP3ng: (Rating) Edit ID3Tag 'POPM' to '%s:%i'\n",MP3Setup.RateCompat,rating));
    asprintf(&buffer, "id3v2 --POPM '%s:%i' '%s'", MP3Setup.RateCompat, rating, Songname);
    cmd = popen(buffer, "r");
    d(printf("MP3ng: Executed '%s'\n", buffer));
    pclose(cmd);
    free(buffer);
  }
  
  mgr->RateSong(rating);

 return osBack;
}


eOSState cMP3Rating::ProcessKey(eKeys Key)
{

  bool hadSubmenu = HasSubMenu();

  eOSState state = cOsdMenu::ProcessKey(Key);

  if (hadSubmenu && !HasSubMenu()) return osBack;

  printf("cmd: CURRENT = %i\n",Current());

  if (state == osUnknown) {
    switch (Key) {
        case kRed:
	case kBack:   return osBack;
	    break;
        case kBlue:
        case kOk:
            printf("cmd: OK PRESSED\n");
	    return SetRating();
	    break;
        default:      state = osContinue;
    }
  }
  return state;
}
