#ifndef __TEXTEFFECTS_H
#define __TEXTEFFECTS_H

#include <vdr/skins.h>
#include <string>
#include <vector>

#include "enigma.h"

#ifdef DISABLE_ANIMATED_TEXT
#define TE_START(osd) ;
#define TE_STOP ;
#define TE_LOCK(cond) ;
#define TE_UNLOCK(cond) ;
#define TE_WAKEUP(cond) ;
#define TE_MARQUEE(osd, id, x...) osd->DrawText(x)
#define TE_BLINK(osd, id, x...) osd->DrawText(x)
#define TE_TITLE(osd, id, s, Font, Width, skin) osd->DrawTitle(s)

#else // !DISABLE_ANIMATED_TEXT
#include <vdr/thread.h>

using namespace std;

#define TE_START(osd) EnigmaTextEffects.Start(osd);
#define TE_STOP EnigmaTextEffects.Stop();
#define TE_LOCK(cond) { if (!cond) EnigmaTextEffects.UpdateLock(); }
#define TE_UNLOCK(cond) { if (!cond) EnigmaTextEffects.UpdateUnlock(); }
#define TE_WAKEUP(cond) { if (!cond) EnigmaTextEffects.RefreshEffects(); }
#define TE_MARQUEE(osd, id, x...) EnigmaTextEffects.DrawAnimatedText(id, 0, x)
#define TE_BLINK(osd, id, x...) EnigmaTextEffects.DrawAnimatedText(id, 1, x)
#define TE_TITLE(osd, id, x...) EnigmaTextEffects.DrawAnimatedTitle(id, 0, x)
#endif //DISABLE_ANIMATED_TEXT

#ifdef DISABLE_ANIMATED_TEXT
class cEnigmaTextEffects {
#else
class cEnigmaTextEffects : public cThread {
#endif
private:
  cOsd *osd;

#ifndef DISABLE_ANIMATED_TEXT
  struct tEffect {
    int nAction;
    uint nOffset;
    int nDirection;
    uint64_t nNextUpdate;
    string strText;
    int x, y, Width, Height;
    tColor ColorFg, ColorBg;
    const cFont *Font;
    int Alignment;
    cSkinEnigmaOsd *Skin;

  public:
    tEffect(void) : nAction(0), nOffset(0), nDirection(0),
                    nNextUpdate(0), x(0), y(0), Width(0), Height(0),
                    ColorFg(0), ColorBg(0), Font(NULL), Alignment(taDefault),
                    Skin(NULL)
    {};
  };

  typedef vector<tEffect*> tEffects;
  tEffects vecEffects;
  cCondVar condSleep;
  cMutex mutexSleep;

  void DoEffect(tEffect *e, uint64_t nNow = 0);
  void DoScroll(tEffect *e, uint64_t nNow);
  void DoBlink(tEffect *e, uint64_t nNow);

  void Wakeup(void)
  {
    mutexSleep.Lock();
    condSleep.Broadcast();
    mutexSleep.Unlock();
  }
#endif //DISABLE_ANIMATED_TEXT

public:
#ifdef DISABLE_ANIMATED_TEXT
  cEnigmaTextEffects(void);
  ~cEnigmaTextEffects(void);

#else
  cEnigmaTextEffects(const char *Description = NULL);
  ~cEnigmaTextEffects(void);

  virtual void Action(void);

  bool Start(cOsd *o);
  void Stop(void);
  void Clear(void);

  void ResetText(int i, tColor ColorFg = 0, tColor ColorBg = 0);
  void UpdateTextWidth(int i, int Width);
  int DrawAnimatedTitle(int o_id, int action, const char *s, const cFont *Font, int Width, cSkinEnigmaOsd *skin);
  int DrawAnimatedText(int o_id, int action, int x, int y, const char *s, tColor ColorFg, tColor ColorBg, const cFont *Font, int Width = 0, int Height = 0, int Alignment = taDefault);

  void UpdateLock(void)
  { Lock(); }

  void UpdateUnlock(void)
  { Unlock(); }

  void RefreshEffects(void)
  { Wakeup(); }
#endif //DISABLE_ANIMATED_TEXT

};

extern cEnigmaTextEffects EnigmaTextEffects;

#endif //__TEXTEFFECTS_H
// vim:et:sw=2:ts=2:
