/*
 * i18n.c: The 'EnigmaNG' VDR skin
 *
 * See the README file for copyright information and how to reach the author.
 *
 */

#include "i18n.h"

const tI18nPhrase Phrases[] = {
  {"en_US",             // English
   "de_DE",             // Deutsch
   "sl_SI",             // Slovenski
   "it_IT",             // Italiano
   "nl_NL",             // Nederlands
   "pt_PT",             // Portugus
   "fr_FR",             // Franais  Patrice Staudt 18.05.2007
   "no_NO",             // Norsk
   "fi_FI",             // suomi (Finnish)
   "pl_PL",             // Polski
   "es_ES",             // Espaol
   "el_GR",             //  (Greek)
   "sv_SE",             // Svenska
   "ro_RO",             // Romn
   "hu_HU",             // Magyar
   "ca_AD",             // Catal
   "ru_RU",             //  (Russian)
   "hr_HR",             // Hrvatski
   "et_EE",             // Eesti
   "da_DK",             // Dansk
   "cs_CZ",             // esky (Czech)
   },
  {"EnigmaNG skin",             // English
   "EnigmaNG Oberflche",       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "EnigmaNG skin",             // Nederlands
   "",                          // Portugus
   "Skin EnigmaNG",             // Franais
   "",                          // Norsk
   "EnigmaNG-ulkoasu",          // suomi (Finnish)
   "Skin EnigmaNG",             // Polski
   "Piel EnigmaNG",             // Espaol
   "",                          //  (Greek)
   "EnigmaNG-temat",            // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "EnigmaNG ",             //  (Russian)
   "",                          // Hrvatski
   "EnigmaNG kest",             // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"EnigmaNG",                  // English
   "EnigmaNG",                  // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "EnigmaNG",                  // Nederlands
   "",                          // Portugus
   "EnigmaNG",                  // Franais
   "",                          // Norsk
   "EnigmaNG",                  // suomi (Finnish)
   "EnigmaNG",                  // Polski
   "EnigmaNG",                  // Espaol
   "",                          //  (Greek)
   "EnigmaNG",                  // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "EnigmaNG",                  //  (Russian)
   "",                          // Hrvatski
   "EnigmaNG",                  // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"min",                       // English
   "min",                       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "min",                       // Nederlands
   "",                          // Portugus
   "min",                       // Franais
   "",                          // Norsk
   "min",                       // suomi (Finnish)
   "min",                       // Polski
   "min",                       // Espaol
   "",                          //  (Greek)
   "min",                       // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                       //  (Russian)
   "",                          // Hrvatski
   "min",                       // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Stereo",                    // English
   "Stereo",                    // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Stereo",                    // Nederlands
   "",                          // Portugus
   "Stro",                    // Franais
   "",                          // Norsk
   "Stereo",                    // suomi (Finnish)
   "Stereo",                    // Polski
   "Estereo",                   // Espaol
   "",                          //  (Greek)
   "Stereo",                    // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "Stereo",                    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Left",                      // English
   "Links",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Links",                     // Nederlands
   "",                          // Portugus
   "Gauche",                    // Franais
   "",                          // Norsk
   "Vasen",                     // suomi (Finnish)
   "W lewo",                    // Polski
   "Izquierda",                 // Espaol
   "",                          //  (Greek)
   "Vnster",                   // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                     //  (Russian)
   "",                          // Hrvatski
   "Vasak",                     // Eesti
   "",                          // Danske
   "",                          // esky (Czech)
   },
  {"Right",                     // English
   "Rechts",                    // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Rechts",                    // Nederlands
   "",                          // Portugus
   "Droite",                    // Franais
   "",                          // Norsk
   "Oikea",                     // suomi (Finnish)
   "W prawo",                   // Polski
   "Derecha",                   // Espaol
   "",                          //  (Greek)
   "Hger",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "Parem",                     // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Mute",                      // English
   "Stumm",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Geluid uit",                // Nederlands
   "",                          // Portugus
   "Muet",                      // Franais
   "",                          // Norsk
   "Mykistetty",                // suomi (Finnish)
   "Wycisz",                    // Polski
   "Silenciar",                 // Espaol
   "",                          //  (Greek)
   "Dmpa",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ". ",                //  (Russian)
   "",                          // Hrvatski
   "Hletu",                   // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Volume",                    // English
   "Lautstrke",                // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Volume",                    // Nederlands
   "",                          // Portugus
   "Volume",                    // Franais
   "",                          // Norsk
   "nenvoimakkuus",           // suomi (Finnish)
   "Gono",                  // Polski
   "Volumen",                   // Espaol
   "",                          //  (Greek)
   "Volym",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                 //  (Russian)
   "",                          // Hrvatski
   "Helitugevus",               // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show channel logos",        // English
   "Kanal-Logos anzeigen",      // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Toon kanaallogo's",         // Nederlands
   "",                          // Portugus
   "Afficher logo des chanes", // Franais
   "",                          // Norsk
   "Nyt kanavalogot",         // suomi (Finnish)
   "Pokazuj logo kanau",       // Polski
   "Mostrar los logos de los canales",  // Espaol
   "",                          //  (Greek)
   "Visa kanallogotyper",       // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "Kanalilogo nitamine",      // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Identify channel by",       // English
   "  Kanal-Identifikation durch",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "  Kanaalidentificatie door",  // Nederlands
   "",                          // Portugus
   "  Identifier chane par",     // Franais
   "",                          // Norsk
   "  Tunnista kanava",           // suomi (Finnish)
   "  Rozpoznaj kana po",        // Polski
   "  Identificar el canal por...",       // Espaol
   "",                          //  (Greek)
   "  Identifiera kanal med",     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "    ",       //  (Russian)
   "",                          // Hrvatski
   "  Kanali tuvastamise meetod", // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"name",                      // English
   "Name",                      // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "naam",                      // Nederlands
   "",                          // Portugus
   "Nom",                       // Franais
   "",                          // Norsk
   "nimest",                   // suomi (Finnish)
   "nazwa",                     // Polski
   "Nombre",                    // Espaol
   "",                          //  (Greek)
   "namn",                      // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                  //  (Russian)
   "",                          // Hrvatski
   "nimi",                      // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"data",                      // English
   "ID",                        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "data",                      // Nederlands
   "",                          // Portugus
   "Donne",                    // Franais
   "",                          // Norsk
   "tiedoista",                 // suomi (Finnish)
   "parametry",                 // Polski
   "Datos",                     // Espaol
   "",                          //  (Greek)
   "data",                      // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "andmed",                    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channel logo cache size",   // English
   "Gre des Logo-Caches",     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Kanaallogo cache",          // Nederlands
   "",                          // Portugus
   "Taille du cache des logo",  // Franais
   "",                          // Norsk
   "Vlimuistin koko kanavalogoille",   // suomi (Finnish)
   "Rozmiar cache dla logo kanau",     // Polski
   "Tamao de la cache de los logos",   // Espaol
   "",                          //  (Greek)
   "Cachestorlek fr logotyper",        // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  o ",  //  (Russian)
   "",                          // Hrvatski
   "Kanalilogo vahemlu suurus",        // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Button$Flush cache",        // English
   "Cache leeren",              // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Cache legen",               // Nederlands
   "",                          // Portugus
   "Supprimer cache",           // Franais
   "",                          // Norsk
   "Tyhjenn",                  // suomi (Finnish)
   "Oprnij cache",            // Polski
   "Limpiar la cache",          // Espaol
   "",                          //  (Greek)
   "Tm cachen",                // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",              //  (Russian)
   "",                          // Hrvatski
   "Thjenda",                  // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Flushing channel logo cache...",    // English
   "Logo-Cache wird geleert...",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Kanaallogo cache legen...", // Nederlands
   "",                          // Portugus
   "Suppression du cache...",   // Franais
   "",                          // Norsk
   "Tyhjennetn vlimuistia...",       // suomi (Finnish)
   "Oprniam cache logo kanau...",    // Polski
   "Limpiando la cache...",     // Espaol
   "",                          //  (Greek)
   "Tmmer cachen...",          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ...",                          //  (Russian)
   "",                          // Hrvatski
   "Kanalilogo vahemlu thjendamine...",       // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Languages",                 // English
   "Sprachen",                  // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Talen",                     // Nederlands
   "",                          // Portugus
   "Langues",                   // Franais
   "",                          // Norsk
   "Kielet",                    // suomi (Finnish)
   "Jzyki",                    // Polski
   "Lenguajes",                 // Espaol
   "",                          //  (Greek)
   "Sprk",                     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "Keeled",                    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Auxiliary information",     // English
   "Zusatzinformation",         // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Hulp informatie",           // Nederlands
   "",                          // Portugus
   "Information auxiliare",     // Franais
   "",                          // Norsk
   "Listiedot",                // suomi (Finnish)
   "Informacje pomocnicze",     // Polski
   "Informacin auxiliar",      // Espaol
   "",                          //  (Greek)
   "Extrainformation",          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ". ",          //  (Russian)
   "",                          // Hrvatski
   "Lisainfo",                  // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show auxiliary information",        // English
   "Zusatzinfo anzeigen",       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Toon hulp informatie",      // Nederlands
   "",                          // Portugus
   "Afficher information auxiliaire",   // Franais
   "",                          // Norsk
   "Nyt listiedot",          // suomi (Finnish)
   "Pokazuj informacje pomocnicze",     // Polski
   "Mostrar informacin auxiliar",      // Espaol
   "",                          //  (Greek)
   "Visa extrainformation",     // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " . ",      //  (Russian)
   "",                          // Hrvatski
   "Lisainfo nitamine",        // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show remaining/elapsed time",          // English
   "Zeige abgel./restl. Zeit",             // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Toon resterend/gedane tijd",  // Nederlands
   "",                          // Portugus
   "Afficher le temps coul/restant", // Franais
   "",                          // Norsk
   "Nyt tapahtuman aika",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ./. ",     //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"remaining",                 // English
   "restliche",                 // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "resterend",                   // Nederlands
   "",                          // Portugus
   "restant",                   // Franais
   "",                          // Norsk
   "jljell oleva",            // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                 //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"elapsed",                   // English
   "abgelaufene",               // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "gedane",                // Nederlands
   "",                          // Portugus
   "coul",                    // Franais
   "",                          // Norsk
   "kulunut",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                  //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show info area in main menu",            // English
   "Infobereich im Hauptmen",               // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Info in hoofdmenu",         // Nederlands
   "",                          // Portugus
   "Surface d'infos dans le menu principale",  // Franais
   "",                          // Norsk
   "Nyt infoalue pvalikossa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " .   . ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show marker in lists",            // English
   "Symbol vor Listeneintrgen",      // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Markering in lijsten tonen", // Nederlands
   "",                          // Portugus
   "Symbole dans les listes",   // Franais
   "",                          // Norsk
   "Nyt valintasymboli",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show progressbar",          // English
   "Fortschrittbalken anzeigen",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Progressiebalk tonen",      // Nederlands
   "",                          // Portugus
   "Afficher barre de progression",     // Franais
   "",                          // Norsk
   "Nyt aikajana",            // suomi (Finnish)
   "Pokazuj pasek postpu",     // Polski
   "Mostrar barra de progreso", // Espaol
   "",                          //  (Greek)
   "Visa framsteg",             // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "Edenemisriba nitamine",    // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show symbols",              // English
   "Symbole anzeigen",          // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Symbolen tonen",            // Nederlands
   "",                          // Portugus
   "Afficher symbole",          // Franais
   "",                          // Norsk
   "Nyt symbolit",            // suomi (Finnish)
   "Pokazuj symbole",           // Polski
   "Mostrar smbolos",          // Espaol
   "",                          //  (Greek)
   "Visa symboler",             // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",                          //  (Russian)
   "",                          // Hrvatski
   "Smbolite nitamine",       // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show VPS",                  // English
   "VPS anzeigen",              // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "VPS tonen",                 // Nederlands
   "",                          // Portugus
   "Afficher le VPS",           // Franais
   "",                          // Norsk
   "Nyt VPS-tieto",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " VPS",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"WARNING",                   // English
   "WARNUNG",                   // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "WAARSCHUWING",              // Nederlands
   "",                          // Portugus
   "ATTENTION",                 // Franais
   "",                          // Norsk
   "VAROITUS",                  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "ÿ",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Timer conflict",            // English
   "Timerkonflikt",             // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Timerconflict",             // Nederlands
   "",                          // Portugus
   "Conflit de programmation",  // Franais
   "",                          // Norsk
   "Pllekkinen ajastin",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Timer conflicts",           // English
   "Timerkonflikte",            // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Timerconflicten",                          // Nederlands
   "",                          // Portugus
   "Conflits de programmation", // Franais
   "",                          // Norsk
   "Pllekkisi ajastimia",   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",        //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"TIMERS",                    // English
   "TIMER",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "TIMER",                     // Nederlands
   "",                          // Portugus
   "PROGRAMMATION",             // Franais
   "",                          // Norsk
   "AJASTIMET",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "°",                   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"RERUNS OF THIS SHOW",       // English
   "WIEDERHOLUNGEN",            // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "HERHALINGEN",               // Nederlands
   "",                          // Portugus
   "REPETITION",                // Franais
   "",                          // Norsk
   "TOISTUVAT TAPAHTUMAT",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "¾",                //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"*** Invalid Channel ***",   // English
   "*** Ungltiger Kanal ***",  // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "*** Ongeldig Kanaal ***",   // Nederlands
   "",                          // Portugus
   "*** Chanes non valable ***",  // Franais
   "",                          // Norsk
   "*** Virheellinen kanava ***", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "***   ***",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Size",                      // English
   "Gre",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Grootte",                   // Nederlands
   "",                          // Portugus
   "Taille",                    // Franais
   "",                          // Norsk
   "Koko",                      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Mute",                      // English
   "Stumm",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Geluid uit",                // Nederlands
   "Muet",                      // Portugus
   "",                          // Franais
   "",                          // Norsk
   "Mykistetty",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ".",                 //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Volume",                    // English
   "Lautstrke",                // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Volume",                    // Nederlands
   "",                          // Portugus
   "Volume",                    // Franais
   "",                          // Norsk
   "nenvoimakkuus",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show symbols in lists",     // English
   "Symbole in Listen",         // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Symbolen in lijsten",       // Nederlands
   "",                          // Portugus
   "Symboles dans les listes",   // Franais
   "",                          // Norsk
   "Nyt tapahtumien symbolit",// suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Try 8bpp single area",      // English
   "Einen 8bpp Bereich versuchen", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "",                          // Franais
   "",                          // Norsk
   "",                          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show flags",                // English
   "Fahnen anzeigen",           // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Vlaggen tonen",             // Nederlands
   "",                          // Portugus
   "Afficher drapeau",          // Franais
   "",                          // Norsk
   "Nyt liput",               // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",            //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show symbols in menu",      // English
   "Symbole im Men",           // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Symbolen in menu",          // Nederlands
   "",                          // Portugus
   "Symboles dans le menu",     // Franais
   "",                          // Norsk
   "Nyt valikkosymbolit",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"never",                     // English
   "nie",                       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "nooit",                     // Nederlands
   "",                          // Portugus
   "jamais",                    // Franais
   "",                          // Norsk
   "ei koskaan",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"always",                    // English
   "immer",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Altijd",                    // Nederlands
   "",                          // Portugus
   "toujours",                  // Franais
   "",                          // Norsk
   "aina",                      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                    //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"percent",                   // English
   "Prozent",                   // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "procent",                   // Nederlands
   "",                          // Portugus
   "Pourcentage",               // Franais
   "",                          // Norsk
   "prosentti",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"if exists",                 // English
   "wenn vorhanden",            // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "wanneer aanwezig",          // Nederlands
   "",                          // Portugus
   "si existant",               // Franais
   "",                          // Norsk
   "jos olemassa",              // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",            //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Number of Reruns",          // English
   "Anzahl Wiederholungen",     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "aantal herhalingen",        // Nederlands
   "",                          // Portugus
   "Nombre de rptitions",     // Franais
   "",                          // Norsk
   "Uusintojen lukumr",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",     //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Use Subtitle for reruns",   // English
   "Verw. Untertitel fr Wdh.", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Gebr. ondertitlel voor herh.", // Nederlands
   "",                          // Portugus
   "Utilise sous-titre pour les rptitions", // Franais
   "",                          // Norsk
   "Kyt lyhytt kuvausta uusinnoille", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   ".   ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show timer conflicts",      // English
   "Timerkonflikte anzeigen",   // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Timerconflict tonen",       // Nederlands
   "",                          // Portugus
   "Afficher les conflits de programmation", // Franais
   "",                          // Norsk
   "Nyt pllekkiset ajastimet", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Timer check",               // English
   "berwachung",               // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Monitoren",                 // Nederlands
   "",                          // Portugus
   "Observation de la programmation", // Franais
   "",                          // Norsk
   "Ajastimien valvonta",       // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",         //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"EPGSearch",                 // English
   "EPGSearch",                 // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "EPGsearch",                 // Nederlands
   "",                          // Portugus
   "Recherche EPG",             // Franais
   "",                          // Norsk
   "EPGSearch",                 // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Logos & Symbols",           // English
   "Logos & Symbole",           // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Logo's & Symbolen",         // Nederlands
   "",                          // Portugus
   "Logos et symboles",         // Franais
   "",                          // Norsk
   "Logot ja symbolit",         // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " & ",        //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"use size.vdr only",         // English
   "nur size.vdr verwenden",    // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "alleen size.vdr gebruiken", // Nederlands
   "",                          // Portugus
   "utiliser seulement size.vdr",  // Franais Patrice Staudt 29.03.2007
   "",                          // Norsk
   "vain jos size.vdr",         // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  size.vdr",  //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show recording's size",     // English
   "Aufnahmengre anzeigen",   // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Opnamegrootte tonen",       // Nederlands
   "",                          // Portugus
   "Afficher la taille des l'enregistrements",   // Franais
   "",                          // Norsk
   "Nyt tallenteen koko",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",    //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"pixel algo",                // English
   "Pixel-Algorithmus",         // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "pixelalgoritme",            // Nederlands
   "",                          // Portugus
   "Algorithme pixel",          // Franais
   "",                          // Norsk
   "nytteistys",               // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"ratio algo",                // English
   "Ratio-Algorithmus",         // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "algoritmeratio",            // Nederlands
   "",                          // Portugus
   "Algorithme ratio",          // Franais
   "",                          // Norsk
   "skaalaus",                  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   " ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"zoom image",                // English
   "Zoomen",                    // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "zoomen",                    // Nederlands
   "",                          // Portugus
   "Agrandit image",            // Franais
   "",                          // Norsk
   "zoomaus",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                 //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Show event/recording images",     // English
   "Bilder in EPG/Aufnahmendetails",  // Deutsch
   "",                                // Slovenski
   "",                                // Italiano
   "EPG/opnamedetails tonen",         // Nederlands
   "",                                // Portugus
   "Images dans les EPG et dtails d'enregistrements",     // Franais
   "",                                // Norsk
   "Nyt kuvat listietovalikossa",  // suomi (Finnish)
   "",                                // Polski
   "",                                // Espaol
   "",                                //  (Greek)
   "",                                // Svenska
   "",                                // Romn
   "",                                // Magyar
   "",                                // Catal
   "  EPG",               //  (Russian)
   "",                                // Hrvatski
   "",                                // Eesti
   "",                                // Dansk
   "",                                // esky (Czech)
   },
  {"  Resize images",           // English
   "  Bildberechnung benutzt",  // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "  Aanpassen beeldgrootte",  // Nederlands
   "",                          // Portugus
   "  Redimension les images",  // Franais
   "",                          // Norsk
   "  Muokkaa kuvien kokoa",    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",    //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Image width",             // English
   "  Bildbreite",              // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "  Beeldbreedte",            // Nederlands
   "",                          // Portugus
   "  Largeur d'image ",        // Franais
   "",                          // Norsk
   "  Kuvien leveys",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Image height",            // English
   "  Bildhhe",                // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "  Beeldhoogte",             // Nederlands
   "",                          // Portugus
   "  Hauteur d'image",         // Franais
   "",                          // Norsk
   "  Kuvien korkeus",          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Image format",            // English
   "  Bildformat",              // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "  Beeldformaat",            // Nederlands
   "",                          // Portugus
   "  Format d'image",          // Franais
   "",                          // Norsk
   "  Kuvaformaatti",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",      //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Full title width",          // English
   "Volle Titelbreite",         // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Volle titelbreedte",        // Nederlands
   "",                          // Portugus
   "Largeur total pour le titre", // Franais
   "",                          // Norsk
   "Levit otsikkopalkki",      // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#ifdef USE_PLUGIN_MAILBOX
  {"Show mail icon",            // English
   "Zeige Mail-Icon",           // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "Mail-ikoon tonen",          // Nederlands
   "",                          // Portugus
   "Affiche l'icone courriel",  // Franais
   "",                          // Norsk
   "Nyt shkpostikuvake",    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "  . ",   //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"only if new mail present",  // English
   "nur bei neuer Mail",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "alleen bij nieuwe mail",    // Nederlands
   "",                          // Portugus
   "juste lors d'un courriel",  // Franais
   "",                          // Norsk
   "jos uutta postia",          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "   ",  //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#endif
#ifndef DISABLE_ANIMATED_TEXT
  {"Animated Text",             // English
   "Bewegter Text",             // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Texte dfilant",            // Franais
   "",                          // Norsk
   "Tekstien elvinti",        // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Enable",                    // English
   "Verwenden",                 // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Permettre",                 // Franais
   "",                          // Norsk
   "Kyt elvinti",          // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scoll behaviour",         // English
   "  Scroll-Verhalten",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Comportement de dfilement", // Franais
   "",                          // Norsk
   "  Vieritystapa",            // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"to the left",               // English
   "nach links",                // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "vers la gauche",            // Franais
   "",                          // Norsk
   "vasemmalle",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"left and right",            // English
   "links und rechts",          // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "gauche et droite",          // Franais
   "",                          // Norsk
   "edestakaisin",              // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll delay (ms)",       // English
   "  Scroll-Verzgerung (ms)", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Dlai de dfilement (ms)",// Franais
   "",                          // Norsk
   "  Vierityksen viive (ms)",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll pause (ms)",       // English
   "  Scroll-Pause (ms)",       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Pause de dfilement (ms)",// Franais
   "",                          // Norsk
   "  Vierityksen tauko (ms)",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Blink pause (ms)",        // English
   "  Blink-Pause (ms)",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Pause de clignotement (ms)",// Franais
   "",                          // Norsk
   "  Vilkutuksen tauko (ms)",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll OSD title",        // English
   "  OSD Titel scrollen",      // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Dfillement dans le titre du OSD",  // Franais
   "",                          // Norsk
   "  Vierit valikon otsikkoa",// suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll info area",        // English
   "  Infobereich scrollen",    // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Barre de dfilement dans la surface info",   // Franais
   "",                          // Norsk
   "  Vierit infoaluetta",     // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll active list items",  // English
   "  Aktive Listenzeile scrollen", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Barre de dfilement dans la liste active",  // Franais
   "",                          // Norsk
   "  Vierit aktiivista valintaa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Scroll other items",      // English
   "  Andere Bereiche scrollen", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Barre de dfilement dans d'autre partie",  // Franais
   "",                          // Norsk
   "  Vierit muita alueita",   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
#endif
  {"  Show symbols in menu",    // English
   "  Symbole im Men",         // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Afficher les symboles dans le menu",  // Franais
   "",                          // Norsk
   "  Nyt symbolit valikossa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Show symbols in replay",  // English
   "  Symbole bei der Wiedergabe", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Afficher les symboles dans lecture",  // Franais
   "",                          // Norsk
   "  Nyt symbolit toistettaessa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Show symbols in messages",  // English
   "  Symbole bei den Meldungen", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Afficher les symboles dans les messages", // Franais
   "",                          // Norsk
   "  Nyt symbolit viesteiss", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"  Show symbols in audio",   // English
   "  Symbole bei Audio",       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "  Afficher les symboles dans audio",   // Franais
   "",                          // Norsk
   "  Nyt symbolit nivalikossa", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Fonts",                     // English
   "Fonts",                     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Les polices",               // Franais
   "",                          // Norsk
   "Kirjasimet",                // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"OSD title",                 // English
   "OSD Titel",                 // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "OSD Titre",                 // Franais
   "",                          // Norsk
   "Valikon otsikko",           // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Messages",                  // English
   "Meldungen",                 // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Message",                   // Franais
   "",                          // Norsk
   "Viestit",                   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Help keys",                 // English
   "Farb-Tasten",               // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Touche couleur",            // Franais
   "",                          // Norsk
   "Vrinppimet",             // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channelinfo: title",        // English
   "Kanalinfo: Titel",          // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Channel info: titre ",      // Franais
   "",                          // Norsk
   "Kanavatieto: ohjelman nimi",// suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channelinfo: subtitle",     // English
   "Kanalinfo: Untertitel",     // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Channel info: sous-titre",  // Franais
   "",                          // Norsk
   "Kanavatieto: ohjelman kuvaus", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Channelinfo: language",     // English
   "Kanalinfo: Sprache",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Channel info: langue",      // Franais
   "",                          // Norsk
   "Kanavatieto: kieli",        // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"List items",                // English
   "Listen",                    // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Liste",                     // Franais
   "",                          // Norsk
   "Listat",                    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: timers title",   // English
   "Infobereich: Timer Titel",  // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Barre d'information: Titre Progammation",   // Franais
   "",                          // Norsk
   "Infoalue: ajastimen otsikko", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: timers text",    // English
   "Infobereich: Timer Text",   // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Barre d'information: Text programmation",   // Franais
   "",                          // Norsk
   "Infoalue: ajastimen leipteksti", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: warning title",  // English
   "Infobereich: Warnung Titel", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Barre d'information: avertissement titre",   // Franais
   "",                          // Norsk
   "Infoalue: varoituksen otsikko",  // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Info area: warning text",   // English
   "Infobereich: Warnung Text", // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Barre d'information: texte d'avertissement",      // Franais
   "",                          // Norsk
   "Infoalue: varoituksen leipteksti", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: title",            // English
   "Details: Titel",            // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Dtails: Titre",            // Franais
   "",                          // Norsk
   "Listiedot: ohjelman nimi", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: subtitle",         // English
   "Details: Untertitel",       // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Dtails: Sous-titre",       // Franais
   "",                          // Norsk
   "Listiedot: ohjelman kuvaus", // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: date",             // English
   "Details: Datumszeile",      // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Dtails: date",             // Franais
   "",                          // Norsk
   "Listiedot: pivmr",    // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Details: text",             // English
   "Details: Text",             // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Dtails: Text",             // Franais
   "",                          // Norsk
   "Listiedot: leipteksti",   // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {"Replay: times",             // English
   "Wiedergabe: Zeiten",        // Deutsch
   "",                          // Slovenski
   "",                          // Italiano
   "",                          // Nederlands
   "",                          // Portugus
   "Rejouer : priodes",        // Franais
   "",                          // Norsk
   "Toisto: kellonajat",        // suomi (Finnish)
   "",                          // Polski
   "",                          // Espaol
   "",                          //  (Greek)
   "",                          // Svenska
   "",                          // Romn
   "",                          // Magyar
   "",                          // Catal
   "",                          //  (Russian)
   "",                          // Hrvatski
   "",                          // Eesti
   "",                          // Dansk
   "",                          // esky (Czech)
   },
  {NULL}
};
// vim:et:sw=2:ts=2:
