/*
 * MP3/MPlayer plugin to VDR (C++)
 *
 * (C) 2001-2005 Stefan Huelswitt <s.huelswitt@gmx.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>

#include "common.h"
#include "setup-mp3.h"

cMP3Setup MP3Setup;

// --- cMP3Setup ---------------------------------------------------------------

cMP3Setup::cMP3Setup(void)
{
  InitLoopMode = 0;
  InitShuffleMode = 0;
  AudioMode = 1;
  BgrScan = 1;
  EditorMode = 1;
  DisplayMode = 4;
  UseDeviceStillPicture = 1;
  MenuMode = 2;
  TargetLevel = DEFAULT_TARGET_LEVEL;
  LimiterLevel = DEFAULT_LIMITER_LEVEL;
  Only48kHz = 0;
  UseProxy = 0;
  strcpy(ProxyHost,"localhost");
  ProxyPort = 8080;
  UseCddb = 1;
  strcpy(CddbHost,"freedb.freedb.org");
  CddbPort = 888;
  AudioOutMode = 0;
  AbortAtEOL = 1;
//  ReplayDisplay = 0;
  HideMainMenu = 0;
  KeepSelect = 0;
  ExitClose = 1;
  strcpy(CopyDir,"/tmp");
  strcpy(RecordDir,"/tmp");
  strcpy(RecordOpts,"-r 127.0.0.1:8080");
  strcpy(CoverDir,"/tmp");
  AdminMode = 0;
  EnableRating = 0;
  strcpy(RateCompat,"no@email");
  RateInFile = 0;
  RatingFirst = 0;
  Jumptime = 30;
  OSDoffsetx = 0;
  OSDoffsety = 0;
  Rowcount = 7;
  ArtistFirst = 0;
  Coversize = 0;
#ifdef HAVE_VDR_SPEZIAL
  FullSize = 0;
#endif
  ShowFileName = 0;
  MaxResult = 300;
  ImgAlpha = 210;
  ImgDither = 0;
  EnableSpectrumAnalyzer = 0;
  ThemesSA = 5;
  FalloffSA = 8;
#ifdef HAVE_MAGICK
  MaxCacheFill = 10;
  ImgAspect = 0;
  ImgTreeDepth = 4;
#endif
};

const cSATheme satheme[eSAThemeMaxNumber] =
{
// Visualization
// Channels
// Bands

 {
 1,   
 1,
 8,  //8 band mono 
 },
 {
 1,
 1,
 16, //16 band mono
 },
 {
 1,
 1,
 32, //32 band mono
 },
 {
 1,
 1,
 64, //64 band mono
 },
 {
 2,
 2,
 4,  //4 band stereo 
 },
 {
 2,
 2,
 8,  //8 band stereo
 },
 {
 2,
 2,
 16, //16 band stereo
 },
 {
 2,
 2,
 32, //32 band stereo
 },
 {
 3,
 2,  // Volume stereo
 1,
 }
};

