/*
 * avards.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#include <vdr/thread.h>
#include <float.h>
#include "avards_services.h"

#define MAXSTRING 100

class cWSSoverdrive
{
private:
  int vbi_device;
public:
  cWSSoverdrive(void);
  ~cWSSoverdrive();
  bool OpenVbiDevice(const char* szDevice);
  void CloseVbiDevice(void);
  void SetWSS(int);
};


class cDetector : public cThread
{
private:
  virtual void Action(void);
  cCondWait Wait;
  char pszDvbVideo[MAXSTRING];
  char pszDvbFrontend[MAXSTRING];
  int naAspectInfo;
  cWSSoverdrive *wssoverdrive;

  ///cMutex mutex;
public:
  cDetector(void);
  ~cDetector();
  bool Active() { return Running(); }
  //void Update();
  bool StartUp();
  void Stop();
  bool GetOSDSize(avards_OSDsize_v1_0 *Data);
};
