#ifndef __MP3CONTROL_H
#define __MP3CONTROL_H

#include <string>
#include <vdr/menuitems.h>

#include "player-mp3.h"
#include "commands.h"
#include "rating.h"

#define MAXROWS 120

class cMP3Control : public cControl {
private:
  cOsd *osd;
  std::string imagefile;
  const cFont *font;

  int fw, fh;
  //
  cMP3Player *player;

  cMP3Commands *cmdMenu;
  cMP3Rating *rateMenu;

  bool copyfile, showcoveronly, visible, shown, statusActive, refresh, flush, skiprew, skipfwd;
  time_t timeoutShow, greentime, oktime;
  int coversize, lastkeytime, num, number, playstatus;
  bool selecting, selecthide, artistfirst;
  //
  cMP3PlayInfo *lastMode;
  time_t fliptime, listtime;
  int hashlist[MAXROWS];
  int flip, flipint, top, rows, osdwidth, osdtop, osdleft, osdheight, lh, showbuttons;
  int x0, x1, y0, y1, y2, y3, y4, y5, depth;
  int lastIndex, lastTotal, lastTop;
  int framesPerSecond;

  char *rating;
  //
  bool jumpactive, jumphide, jumpsecs, ShowSA;
  int jumpmm, channelsSA, bandsSA, visualization;
  //
  static cBitmap bmShuffle , bmLoop , bmStop , bmPlay , bmPause , bmRew , bmFwd , bmCopy;

  static cBitmap bmDelStar,bmRate00,bmRate05,bmRate10,bmRate15,bmRate20,bmRate25,bmRate30,bmRate35,bmRate40,bmRate45,bmRate50;

  // , bmRec;
  //
  int clrTopBG1;
  int clrTopTextFG1;
  int clrTopBG2;
  int clrTopTextFG2;
  int clrTopItemBG1;
  int clrTopItemInactiveFG;
  int clrTopItemActiveFG;
  int clrListBG1;
  int clrListBG2;
  int clrListTextFG;
  int clrListTextActiveFG;
  int clrListTextActiveBG;
  int clrListRating;
  int clrInfoBG1;
  int clrInfoBG2;
  int clrInfoTextFG1;
  int clrInfoTitleFG1;
  int clrInfoTextFG2;
  int clrProgressBG1;
  int clrProgressBG2;
  int clrProgressbarFG;
  int clrProgressbarBG;
  int clrStatusBG;
  int clrStatusRed;
  int clrStatusGreen;
  int clrStatusYellow;
  int clrStatusBlue;
  int clrStatusTextFG;
  //
  void ShowTimed(int Seconds=0);
  void ShowStatus(bool force);
  void HideStatus(void);
  void ShowCoverOnly(bool open=false);
  void ShowHelpButtons(int ShowButtons);
  void ConvertRatingToChar(int value, int bgClr, int fgClr, int rowc);
  void ShowProgress(bool open=false);
  void DisplayInfo(const char *s=0);
  void JumpDisplay(void);
  void JumpProcess(eKeys Key);
  void Jump(void);
  void Stop(void);
  void LoadCover(void);
  void CopyTrack(void);
  inline void Flush(void);
public:
  cMP3Control(void);
  virtual ~cMP3Control();
  virtual eOSState ProcessKey(eKeys Key);
  virtual void Show(void) { ShowTimed(); }
  virtual void Hide(void);
  bool Visible(void) { return visible; }
  static bool SetPlayList(cPlayList *plist);
};

#endif // __MP3CONTROL_H
