#include "transponders.h"

string cTranspoders::StrTrim(string sInput) {
    string sRetVal="";
    int iStart=0;
    int iStop=0;
	int iStrLength=sInput.length();
    for(int i=0; i<iStrLength; i++) {
        if (sInput[i] != ' ') {
            iStart=i;
            i=sInput.length();
        }
    }
    for(int i=iStrLength-1; i>0; i--) {
        if (sInput[i] != ' ') {
            iStop=i;
            i=0;
        }
    }
    sRetVal=sInput.substr(iStart,iStop-iStart+1);
    return sRetVal;
}

string cTranspoders::StrBeforeChar(string sLine, char cFind) {
    string sRetVal = "";
    int iStrLength=sLine.length();
    if (sLine.length() != 0) {
        for(int i=0; i<iStrLength; i++) {
    	    if (sLine[i] != cFind) {
    	        sRetVal = sRetVal + sLine[i];
    	    } else {
    		i = sLine.length();
    	    }
        }
    }
    sRetVal=StrTrim(sRetVal);
    return sRetVal;
}


string cTranspoders::StrAfterChar(string sLine, char cFind) {
    string sRetVal = "";
    int iStart=0;
    int iStrLength=sLine.length();
    if (iStrLength!=0) {
        for(int i=0; i<iStrLength; i++) {
            if ((sLine[i] == cFind) && (iStart== 0)) {
				iStart=i;
			}
        }
        for(int i=iStart+1; i<iStrLength; i++) {
			sRetVal=sRetVal+sLine[i];
    	}
    }
    sRetVal=StrTrim(sRetVal);
    return sRetVal;
}


string cTranspoders::IntToStr(int iValue) {
    string sTemp="";
    if (iValue < 1) {
		sTemp="0";
    } else {
    	for(int i; iValue>0; i++) {
			char c=(char)(iValue % 10) + 48;
			sTemp=c+sTemp;
			iValue=iValue/10; i++;		
		}
    }
    return sTemp;
}

string cTranspoders::CharToStr(char cInput[100]) {
	string sTemp;
	int iLenght = strlen(cInput);
	for (int i=0; i < iLenght; i++) {
		sTemp = sTemp + cInput[i];
	}
	return sTemp;
}


int cTranspoders::StrToInt(string sInput) {
	char cTemp[100];
	int iStrLength=sInput.length();
	int iLenght=0;
	for (int i=0; i<iStrLength; i++) {
		cTemp[i] = sInput[i];
		iLenght = i;
	}
	cTemp[iLenght+1]='\0';
	return atoi(cTemp);
}

string cTranspoders::ReadIni(char cFile[100], string sCategory, string sField) {
	string sReturn="";
    char cTemp;
    string sInput="";
	string sValue="";
	int iInCategory=0;
	
	ifstream fin(cFile);
	while (!fin.eof()) {
		cTemp=fin.get();
		if (cTemp == '\n') {
			if (sInput[0] == '[') {
				if (sInput == sCategory) {
					iInCategory = 1;
				} else {
					iInCategory = 0;
				}
			} else {
				if (iInCategory == 1) {
					sValue=StrBeforeChar(sInput, '=');
					if(sValue == sField) {
						sValue=StrAfterChar(sInput, '=');
						sReturn = sValue;
					}
				}
			}
			sInput="";
		} else {
			if ((cTemp != '\n') && (cTemp != '\r')) {
				sInput=sInput+cTemp;
			}
		}
    }
    fin.close();
	return sReturn;
}

void cTranspoders::Reset(void) {
	cName[0] = '\0';
	iCount=0;
	for (int i=0; i<1000; i++) {
		iFrequency[i] = 0;
		cPolarization[i] = ' ';
		iSymbolrate[i] = 0;	
		
	}
}

void cTranspoders::GetTranspodersData(char cFile[100]) {
	string sField = "";
	string sTemp = "";
	// Reset the class structure
	Reset();
	// Sat name
        sTemp = ReadIni(cFile, "[SATTYPE]", "1");
        iSource = 0x8000 | (StrToInt(sTemp)>1800 ? 3600-StrToInt(sTemp) : StrToInt(sTemp) | 0x0800);
	sTemp = ReadIni(cFile, "[SATTYPE]", "2");
	int iLenght=sTemp.length();
	for(int i=0; i<iLenght; i++) {
		cName[i] = sTemp[i];
		cName[i+1] = '\0';
	}
	// Sat transpoders
	sTemp = ReadIni(cFile, "[DVB]", "0");
	iCount = StrToInt(sTemp);
	// Load all	transpoders of sat
	for (int i=0; i<iCount; i++) {
		sField = IntToStr(i+1);
		sTemp = ReadIni(cFile, "[DVB]", sField);
		// Load frequency
		string sFrequency = StrBeforeChar(sTemp,',');
		iFrequency[i] = StrToInt(StrBeforeChar(sFrequency,','));
		// Load Polarization
		string sPolarization = StrAfterChar(sTemp,',');
		cPolarization[i] = (char) StrBeforeChar(sPolarization,',')[0];
		// Load frequency
		string sSymbolrate = StrAfterChar(StrAfterChar(sTemp,','), ',');
		iSymbolrate[i] = StrToInt(StrBeforeChar(sSymbolrate,','));	
		//cout << i << " - " << iFrequency[i] << "-" << cPolarization[i] << "-" << iSymbolrate[i] << "\n";
	}
	return;
} 


int cTranspoders::openDir (char * path, char * cFilter) { 
	DIR *dir=opendir(path); 
	struct dirent *sDir; 
	int iArrCount=0;

	struct stat statbuf; 
	char fullpath[1024]; 

	if (!dir) return 1; 

	while ((sDir=readdir(dir)) != NULL) { 
		strcpy(fullpath,path); 
		strcat(fullpath,sDir->d_name); 
		if (stat(fullpath,&statbuf) == 0) {
			if ( S_ISDIR(statbuf.st_mode) == 0 ) {
				int i = strlen(fullpath);
				if ((fullpath[i] == cFilter[5]) && (fullpath[i-1] == cFilter[4]) && (fullpath[i-2] == cFilter[3]) && (fullpath[i-3] == cFilter[2])) {
					string sTemp = CharToStr(fullpath);
					//sTemp = StrAfterChar(sTemp, '/');
					//sTemp = StrAfterChar(sTemp, '/');
					sArrTranspodersFile[iArrCount] = sTemp;
					iArrTranspodersFile=iArrCount;
					iArrCount++;
				}
			} 
		} 
	} 
	closedir(dir); 
	return 0;
} 

void cTranspoders::LoadArrTranspoders(char * cPath) {
	openDir(cPath, "*.ini");
	for (int ii=0; ii<iArrTranspodersFile; ii++) {
		for (int i=0; i<iArrTranspodersFile; i++) {
			if (sArrTranspodersFile[i] > sArrTranspodersFile[i+1]) {
				string sTemp=sArrTranspodersFile[i];
				sArrTranspodersFile[i] = sArrTranspodersFile[i+1];
				sArrTranspodersFile[i+1] = sTemp;
			}
		}
	}
		return;
} 
