#ifndef __CDSTATUS_H                   
#define __CDSTATUS_H

#include <linux/cdrom.h>

#include <vdr/status.h>
#include <vdr/thread.h>
#include <vdr/status.h>

#include "setup.h"

enum eMediaStatus { mediaNoChange, mediaReqEject, mediaNew, mediaRemoval, mediaChange };
enum eCmd { cmdNop, cmdEject, cmdLoad };

class cCDStatus : public cThread, cStatus {
  private:
    bool running;
    bool mounted;
    bool playing;
    bool trayLocked;
    cCondVar newCmd;
    cMutex mutex;
    int fd;
    int m_isOpen;
    int err;
    eMediaStatus mediaStatus;
    eCmd cmd;
    cPlugin *pMountPlugin;
  protected:
    virtual void Action();
	virtual void Replaying(const cControl *Control, const char *Name);
	int WaitCmd(int fd, struct cdrom_generic_command *cgc, unsigned char *buffer,
      int len, int ddir, int timeout);
    int AllowRemoval(bool allow);
    int EjectScsi(int fd);
    int OpenTray(int fd);
    int CloseTray(int fd);
    int Umount(void);
    int GetMediaEvent(int fd);
  public:
    cCDStatus(cPlugin *plugin);
    ~cCDStatus();
    bool Start(void);
    int EjectRequest(void);
    int OpenCloseRequest(void);
    int StartDisc(void);
    int SetConfig(void);
    eMediaStatus GetMediaStatus(void);
};

#endif
