
//Big thanks to the author of "emm-g analyzer 2.0". I don' know who you are, but your program is excellent!
//09.11.2007
//last update : 12.11.2007
//V.

class N2AU {
private:
  BN_CTX *ctx;
  BIGNUM *s;
  BIGNUM *VAL0, *VAL1, *VAL2, *VAL88H, *VALFEH;
  typedef unsigned char byte; 
  typedef unsigned long uint;   
protected:
  void cMedio(BIGNUM *res, BIGNUM *p);
  void cR2(BIGNUM *res, BIGNUM *p);
  void MultMon(BIGNUM *res,BIGNUM * B, BIGNUM * A, BIGNUM * M);
  void ExpMon(BIGNUM *res, BIGNUM * X, BIGNUM * E, BIGNUM * M);
  void InveQ(BIGNUM *res,BIGNUM *A, BIGNUM *p);
  void SubtractMod(BIGNUM *res, BIGNUM * A, BIGNUM * B, BIGNUM * M);
  void SumMod(BIGNUM *res, BIGNUM * A, BIGNUM * B, BIGNUM * M);
  void Opposed(BIGNUM *res, BIGNUM * A, BIGNUM * M);
  void QPmon(BIGNUM * x1, BIGNUM * y1, BIGNUM * z1, BIGNUM * x2, BIGNUM * y2, BIGNUM * z2, BIGNUM * p,
          BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z);
  void Q2mon(BIGNUM * x, BIGNUM * y, BIGNUM * z, BIGNUM * a, BIGNUM * p,
          BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z );
  void kQmon(BIGNUM * k, BIGNUM * x, BIGNUM * y, BIGNUM * z, BIGNUM * a, BIGNUM * p,
          BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z);
  void kQ(BIGNUM *  k, BIGNUM *  x, BIGNUM *  y, BIGNUM *  z, BIGNUM *  a, BIGNUM *  p,
          BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z );
  void ToAfin(BIGNUM * x, BIGNUM * y, BIGNUM * z, BIGNUM * p,
          BIGNUM * res_x, BIGNUM * res_y);

  void dump(unsigned char *data,int len, char* lbl);
  void BN_dump(char* label, BIGNUM *p);
public:
  N2AU();
  ~N2AU();
  void MAP58(byte* p, byte* px, byte* py, byte* a, byte* k, byte* resX, byte* resY);
};

N2AU::N2AU()
{
  ctx=BN_CTX_new();
  s=BN_new();
  VAL0=BN_new();   BN_set_word(VAL0,0);
  VAL1=BN_new();   BN_set_word(VAL1,1);
  VAL2=BN_new();   BN_set_word(VAL2,2);
  VAL88H=BN_new(); BN_set_word(VAL88H,0x88);
  VALFEH=BN_new(); BN_set_word(VALFEH,0xfe);
}

N2AU::~N2AU()
{
  BN_free(s);
  BN_free(VAL0);
  BN_free(VAL1);
  BN_free(VAL2);
  BN_free(VAL88H);
  BN_free(VALFEH);
  BN_CTX_free(ctx);
}

void N2AU::dump(unsigned char *data,int len, char* lbl)
{
  printf("\n%s: ",lbl);
  for(int i =0; i<len ; i++) {
    if(i%16==0 && i!=0) printf("\n");
    printf("%02X ",data[i]);
  }
}

void N2AU::BN_dump(char* label, BIGNUM *p)
{
  int num = BN_num_bytes(p);
  if(num==0) return;
  //printf("\n\nBN_num_bytes->%d",num);
  unsigned char tmpdata[num];
  BN_bn2bin(p, tmpdata);        
  RotateBytes(tmpdata, num);
  dump(tmpdata,num,label);
}

/*
Test
MultMon B:42CA602E969B6D238D003B8EAF2D6960
MultMon A:42CA602E969B6D238D003B8EAF2D6960
MultMon M:63CCF5B5008D08075C45DA721FBBA35A
MultMon-->:55A4A1EF8A99A2071B17EF53E65740B0
*/
void N2AU::MultMon(BIGNUM *res,BIGNUM * B, BIGNUM * A, BIGNUM * M)
{
  //BN_dump("B",B);
  //BN_dump("A",A);
  //BN_dump("M",M);

  BIGNUM *x = BN_new();
  BIGNUM *s = BN_new();
  BIGNUM *J = BN_new();

  //cNprime(J,M);
  BN_sub(J,VAL0,M);
  BN_set_bit(J,0);
  BN_set_bit(x,64);
  BN_mod_inverse(J,J,x,ctx);

  int words=(BN_num_bytes(M)+7)>>3;
  for(int i=0; i<words; i++) {  
    BN_rshift(x,A,i<<6);
    BN_mask_bits(x,64);
    BN_mul(x,x,B,ctx);
    BN_add(s,s,x);

    BN_copy(x,s);
    BN_mask_bits(x,64);
    BN_mul(x,x,J,ctx);

    BN_mask_bits(x,64);
    BN_mul(x,x,M,ctx);
    BN_add(s,s,x);

    BN_rshift(s,s,64);
    if(BN_cmp(s,M)==1) {
      BN_copy(x,s);
      BN_sub(s,x,M);
      }
    }
  BN_copy(res,s);
  BN_free(s);
  BN_free(x);
  BN_free(J);
}

void N2AU::cMedio(BIGNUM *res, BIGNUM *p)
{
  BIGNUM *r=BN_new();
  cR2(r,p);
  BN_add(s,p,VAL1);
  BN_rshift(s,s,1);
  MultMon(res,r,s,p);
  BN_free(r);
}

/*
test:
p:63CCF5B5008D08075C45DA721FBBA35A
cR2:14FFBAD6BE106ECF8E126D41C6AE1E50
*/
void N2AU::cR2(BIGNUM *res, BIGNUM *p)
{
  //BN_dump("cR2 p:",p);
  BN_copy(s,VAL2);
  if(BN_cmp(p,VAL0)!=0) BN_mod_exp(s,s,VAL88H,p,ctx);
  //BN_dump("b",res);
  for(int i = 0; i < 4; i++) MultMon(s,s,s,p);
  BN_copy(res,s);
  //BN_dump("cR2",res);
}

/*
test
ExpMon:x:49258A1F5F3F38ADB1E02E71F30396AF
ExpMon:e:63CCF5B5008D08075C45DA721FBBA358
ExpMon:m:63CCF5B5008D08075C45DA721FBBA35A
ExpMon:res:17744A8979CFB4252D0B1850BF1B30F4
*/
void N2AU::ExpMon(BIGNUM *res, BIGNUM * X, BIGNUM * E, BIGNUM * M)
{
  //BN_dump("ExpMon:x",X);
  //BN_dump("ExpMon:e",E);
  //BN_dump("ExpMon:m",M);
  BN_copy(s,X);
  for(int i=BN_num_bits(E)-2; i>-1; i--) {
    MultMon(s, s, s, M);
    if (BN_is_bit_set(E, i)) MultMon(s, s, X, M);
    }
  MultMon(res, s, VAL1, M);
  //BN_dump("ExpMon:res",res);
}

/*
test
InveQ:A   : 49258A1F5F3F38ADB1E02E71F30396AF
InveQ:P   : 63CCF5B5008D08075C45DA721FBBA35A
InveQ:res : 17744A8979CFB4252D0B1850BF1B30F4
*/
void N2AU::InveQ(BIGNUM *res, BIGNUM *A, BIGNUM *p)
{
  //BN_dump("InveQ:A",A);
  //BN_dump("InveQ:p",p);
  BIGNUM *integer = BN_new();
  int num = BN_num_bytes(p);
  unsigned char tmpdata[num];
  BN_bn2bin(p,tmpdata);
  if(tmpdata[num-1]!=0) BN_sub(integer , p , VAL2);
  else                  BN_add(integer , p , VALFEH);
  ExpMon(res, A, integer, p);
  //BN_dump("InveQ:res",res);
  BN_free(integer);
}

void N2AU::SubtractMod(BIGNUM *res, BIGNUM * A, BIGNUM * B, BIGNUM * M)
{
  BN_sub(s , A , B);
  BN_add(s , s , M);
  BN_mod(res, s, M, ctx);       
}

void N2AU::SumMod(BIGNUM *res, BIGNUM * A, BIGNUM * B, BIGNUM * M)
{
  BN_add(s , A , B);
  BN_add(s , s , M);
  BN_mod(res, s, M, ctx);       
}

void N2AU::Opposed(BIGNUM *res, BIGNUM * A, BIGNUM * M)
{
  BN_sub(s, M, A);
  BN_mod(res, s, M, ctx);
}

/*
test
x1:4D85221E4A0C2D075FCBB6BB2C9DF2D3
y1:269FF0E2BEA9E5A4C790B054E6DB5B99
z1:51AAEBBF905453BE5823BADDC70B274B
x2:3830EAEDE26319D7804A73CC2C6B9881
y2:B88426B16B16F4E555D4CC4F8AA0EF7
z2:1093286F699463B71816B20D86DD047B
p:63CCF5B5008D08075C45DA721FBBA35A
>x:324A6063B43E58C835AC54D4B4CDD829
>y:2986B15089FBE483B2BDD076C095F424
>z:240846D1A5CD2AF5C7B5B911E81FC48A
*/
void N2AU::QPmon(BIGNUM * x1, BIGNUM * y1, BIGNUM * z1, BIGNUM * x2, BIGNUM * y2, BIGNUM * z2, BIGNUM * p,
                                 BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z)
{
  if(BN_cmp(p,VAL0)==0)
  {
          BN_copy(res_x, x1);
          BN_copy(res_y, y1);
          BN_copy(res_z, z1);
          return;
  }

  //BN_dump("x1",x1);
  //BN_dump("y1",y1);
  //BN_dump("z1",z1);
  //BN_dump("x2",x2);
  //BN_dump("y2",y2);
  //BN_dump("z2",z2);
  //BN_dump("p",p);

  BIGNUM *b = BN_new();
  BIGNUM *a = BN_new();
  BIGNUM *integer6 = BN_new();
  BIGNUM *integer7 =  BN_new();
  BIGNUM *integer3 =  BN_new();
  BIGNUM *integer8 =  BN_new();
  BIGNUM *integer9 =  BN_new();
  BIGNUM *integer =  BN_new();
  BIGNUM *r =  BN_new();
  BIGNUM *var1 =  BN_new();
  BIGNUM *var2 =  BN_new();
  BIGNUM *integer10 =  BN_new();
  BIGNUM *integer2 =  BN_new();

  MultMon(b, z2, z2, p);        
  MultMon(a, b, z2, p);
  MultMon(b, b, x1, p); 
  SubtractMod(integer6, x2, b, p);
  MultMon(a, y1, a, p); 
  SubtractMod(integer7,y2, a, p);    
  MultMon(integer3,integer6, z2, p);    
  MultMon(integer8,integer6, integer6, p);      
  SumMod(integer9, x2, b, p);
  MultMon(integer9, integer8, integer9, p);     
  MultMon(r, integer7, integer7, p);
  SubtractMod(integer, r , integer9, p);        
  SubtractMod(var1,integer9, integer, p);       
  SubtractMod(var2, var1, integer, p);
  MultMon(integer9,var2, integer7, p);
  SumMod(a, a, y2, p);
  MultMon(var2, integer6, integer8, p);
  MultMon(integer8, var2, a, p);
  SubtractMod(integer9, integer9, integer8, p); 
  cMedio(integer10, p); 
  MultMon(integer2, integer9, integer10, p);

  BN_copy(res_x, integer);
  BN_copy(res_y, integer2);
  BN_copy(res_z, integer3);

  //BN_dump(">x",res_x);
  //BN_dump(">y",res_y);
  //BN_dump(">z",res_z);

  BN_free(b);
  BN_free(a);
  BN_free(integer6);
  BN_free(integer7);
  BN_free(integer3);
  BN_free(integer8);
  BN_free(integer9);
  BN_free(integer);
  BN_free(r);
  BN_free(var1);
  BN_free(var2);
  BN_free(integer10);
  BN_free(integer2);
}

/*
test
x:4D85221E4A0C2D075FCBB6BB2C9DF2D3
y:269FF0E2BEA9E5A4C790B054E6DB5B99
z:51AAEBBF905453BE5823BADDC70B274B
a:E137437F1A9B3EAD097D4ED67BAA31
p:63CCF5B5008D08075C45DA721FBBA35A
>x:40747343491B02AF20BEA7EF88764B64
>y:4C09749A3F0565B002B99A6CC3737EE0
>z:0DE45770432B5B33A6556342AA078023
*/
void N2AU::Q2mon(BIGNUM * x, BIGNUM * y, BIGNUM * z, BIGNUM * a, BIGNUM * p,
                                 BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z )
{
  if(BN_cmp(z,VAL0)==0)
  {
          BN_copy(res_x, x);
          BN_copy(res_y, y);
          BN_copy(res_z, z);
          return;
  }

  if(BN_cmp(y,VAL0)==0)
  {
          BN_copy(res_x, VAL0);
          BN_copy(res_y, VAL1);
          BN_copy(res_z, VAL0);
          return;
  }

  //BN_dump("x",x);
  //BN_dump("y",y);
  //BN_dump("z",z);
  //BN_dump("a",a);
  //BN_dump("p",p);

  BIGNUM *b = BN_new();
  BIGNUM *gg = BN_new();
  BIGNUM *integer = BN_new();
  BIGNUM *integer2 = BN_new();
  BIGNUM *integer6 = BN_new();
  BIGNUM *integer5 = BN_new();
  BIGNUM *integer3 = BN_new();
  BIGNUM *ss = BN_new();
  BIGNUM *mm = BN_new();
  BIGNUM *kk = BN_new();

  MultMon(b, x, x, p);
  SumMod(gg, b, b, p);
  SumMod(integer6,gg, b, p);
  MultMon(b, z, z, p);
  SumMod(integer5, y, y, p);
  MultMon(integer3, integer5, z, p);
  MultMon(gg,integer5, integer5, p);
  MultMon(integer5, gg, x, p);
  MultMon(gg, b, b, p);
  MultMon(ss, gg, a, p);
  SumMod(b, ss, integer6, p);
  MultMon(mm, b, b, p);
  SubtractMod(kk, mm, integer5, p);
  SubtractMod(integer,kk, integer5, p);
  SubtractMod(gg,integer, integer5, p);
  MultMon(integer5,gg, b, p);
  MultMon(integer6, y, y, p);
  SumMod(integer6, integer6, integer6, p);
  MultMon(integer6, integer6, integer6, p);
  SumMod(gg, integer6, integer6, p);
  SumMod(kk, gg, integer5, p);
  Opposed(integer2, kk, p);

  BN_copy(res_x, integer);
  BN_copy(res_y, integer2);
  BN_copy(res_z, integer3);

  //BN_dump(">x",integer);
  //BN_dump(">y",integer2);
  //BN_dump(">z",integer3);

  BN_free(b);
  BN_free(gg);
  BN_free(integer);
  BN_free(integer2);
  BN_free(integer6);
  BN_free(integer5);
  BN_free(integer3);
  BN_free(ss);
  BN_free(mm);
  BN_free(kk);
}

/*
test:
kQmon>
k:888A818684071A9D9D9D0718052640A5
x:4D85221E4A0C2D075FCBB6BB2C9DF2D3
y:269FF0E2BEA9E5A4C790B054E6DB5B99
z:51AAEBBF905453BE5823BADDC70B274B
a:E137437F1A9B3EAD097D4ED67BAA31
p:63CCF5B5008D08075C45DA721FBBA35A
kQmon>x->:3EF0B836989E280D982810729299FD83
kQmon>y->:2D258D0C13C912094D27B949DB6C7032
kQmon>z->:6100FB359B62C12E1A2BC47020E00373
*/
void N2AU::kQmon(BIGNUM * k, BIGNUM * x, BIGNUM * y, BIGNUM * z, BIGNUM * a, BIGNUM * p,
                                 BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z)
{
  if (BN_cmp(k,VAL0)==0 || BN_cmp(z,VAL0)==0)
  {
          BN_copy(res_x, VAL0);
          BN_copy(res_y, VAL1);
          BN_copy(res_z, VAL0);
          return;
  }     

  BN_copy(res_x, x);
  BN_copy(res_y, y);
  BN_copy(res_z, z);

  //BN_dump("kQmon>k",k);
  //BN_dump("x",x);
  //BN_dump("y",y);
  //BN_dump("z",z);
  //BN_dump("a",a);
  //BN_dump("p",p);

  for (int i = BN_num_bits(k) - 2; i > -1; i--)
  {
          Q2mon(res_x, res_y, res_z, a, p, res_x, res_y, res_z);
          if (BN_is_bit_set(k,i))               
                  QPmon(x, y, z, res_x, res_y, res_z, p, res_x, res_y, res_z);          
  }

  //BN_dump("kQmon>>>x",res_x);
  //BN_dump("kQmon>>>y",res_y);
  //BN_dump("kQmon>>>z",res_z);
}

/*
test
x:E70DC68814070910050E4C010707A7AD
y:052004AA0407030C2002AA0B278440A5
z:1
a:B2AE70DC613AD888A0159CC03ADA7AD
p:63CCF5B5008D08075C45DA721FBBA35A
k:888A818684071A9D9D9D0718052640A5
:x:3EF0B836989E280D982810729299FD83
:y:2D258D0C13C912094D27B949DB6C7032
:z:6100FB359B62C12E1A2BC47020E00373
*/
void N2AU::kQ(BIGNUM *  k, BIGNUM *  x, BIGNUM *  y, BIGNUM *  z, BIGNUM *  a, BIGNUM *  p,
                          BIGNUM * res_x, BIGNUM * res_y, BIGNUM * res_z )
{
  if ( (BN_cmp(x,VAL0)==0 && BN_cmp(y,VAL0)==0 && BN_cmp(z,VAL0)==0) || (BN_num_bits(k) < 2))
  {
          BN_copy(res_x, x);
          BN_copy(res_y, y);
          BN_copy(res_z, z);
          return;
  }

  //BN_dump("x",x);
  //BN_dump("y",y);
  //BN_dump("z",z);
  //BN_dump("a",a);
  //BN_dump("p",p);
  //BN_dump("k",k);

  BIGNUM *integer = BN_new();
  BIGNUM *integer2 = BN_new();
  BIGNUM *integer3 = BN_new();
  BIGNUM *integer4 = BN_new();
  BIGNUM *integer5 = BN_new();

  cR2(integer,p);
  MultMon(integer2, a, integer, p);
  MultMon(integer3, integer, z, p);
  MultMon(integer4, integer, x, p);
  MultMon(integer5, integer, y, p);

  kQmon(k, integer4, integer5, integer3, integer2, p, res_x, res_y, res_z);

  //BN_dump("kporQ:x",res_x);
  //BN_dump("kporQ:y",res_y);
  //BN_dump("kporQ:z",res_z);

  BN_free(integer);
  BN_free(integer2);
  BN_free(integer3);
  BN_free(integer4);
  BN_free(integer5);
}

/*
test
x:3EF0B836989E280D982810729299FD83
y:2D258D0C13C912094D27B949DB6C7032
z:6100FB359B62C12E1A2BC47020E00373
p:63CCF5B5008D08075C45DA721FBBA35A
->x:2714FC6C9A31786C0E88F1958164FAE2
->y:30BDDDF86C94668EEF2A8E8413D3587A
*/
void N2AU::ToAfin(BIGNUM * x, BIGNUM * y, BIGNUM * z, BIGNUM * p,
                                  BIGNUM * res_x, BIGNUM * res_y)
{
  BIGNUM *gg = BN_new();
  BIGNUM *kk = BN_new();
  BIGNUM *ss = BN_new();
  BIGNUM *rr = BN_new();
  BIGNUM *b = BN_new();
  BIGNUM *uu = BN_new();
  BIGNUM *integer = BN_new();

  //BN_dump("ToAfin->x",x);
  //BN_dump("y",y);
  //BN_dump("z",z);
  //BN_dump("p",p);

  MultMon(gg, z, z, p);
  MultMon(kk, gg, z, p);
  MultMon(ss, kk, VAL1, p);
  InveQ(b, ss, p);

  MultMon(rr, b, z, p);
  MultMon(uu,rr, x, p);
  MultMon(integer,uu, VAL1, p);
  MultMon(kk, b, y, p);
  MultMon(b, kk, VAL1, p);

  BN_copy(res_x, integer);
  BN_copy(res_y, b);

  //BN_dump("ToAfin>>>x",res_x);
  //BN_dump("ToAfin>>>y",res_y);

  BN_free(gg);
  BN_free(kk);
  BN_free(ss);
  BN_free(rr);
  BN_free(b);
  BN_free(uu);
  BN_free(integer);     
}

void N2AU::MAP58(byte* p, byte* px, byte* py, byte* a, byte* k, byte* resX, byte* resY)
{
  BIGNUM *P = BN_new();
  BIGNUM *x = BN_new();
  BIGNUM *y = BN_new();
  BIGNUM *integer4 = BN_new();
  BIGNUM *integer5 = BN_new();
  BIGNUM *res_x = BN_new();
  BIGNUM *res_y = BN_new();
  BIGNUM *res_z = BN_new();
  BIGNUM *final_res_x = BN_new(); 
  BIGNUM *final_res_y = BN_new(); 

  RotateBytes(p, 0x10); BN_bin2bn(p, 0x10, P);
  RotateBytes(px, 0x10); BN_bin2bn(px, 0x10, x);
  RotateBytes(py, 0x10); BN_bin2bn(py, 0x10, y);
  RotateBytes(a, 0x10); BN_bin2bn(a, 0x10, integer4);
  RotateBytes(k, 0x10); BN_bin2bn(k, 0x10, integer5);           

  kQ(integer5, x, y, VAL1, integer4, P, res_x, res_y, res_z);

  ToAfin(res_x, res_y, res_z, P, final_res_x, final_res_y);

  BN_bn2bin(final_res_x, resX);
  RotateBytes(resX,BN_num_bytes(final_res_x));

  BN_bn2bin(final_res_y, resY);
  RotateBytes(resY,BN_num_bytes(final_res_y));

  BN_free(P);
  BN_free(x);
  BN_free(y);
  BN_free(integer4);
  BN_free(integer5);
  BN_free(res_x);
  BN_free(res_y);
  BN_free(res_z);
  BN_free(final_res_x); 
  BN_free(final_res_y); 
}
