/*
 * freeboxEPG.c: Electronic Program Guide for the VDR FreeboxTv plugin
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: freeboxEPG.c 6 2007-05-03 15:54:26Z odj $
 */

// General includes
#include <time.h>
#include <libxml++/libxml++.h>
#include <glibmm-2.4/glibmm/convert.h>

// VDR includes
#include <vdr/device.h>
#include <vdr/thread.h>
#include <vdr/epg.h>

// LiveMedia includes
#include "liveMedia.hh"
#include "BasicUsageEnvironment.hh"
#include "GroupsockHelper.hh"
#include "RTSPClient.hh"

#include "freeboxtv.h"

using namespace FreeboxTv;
using FreeboxTv::cFreeboxClient;
using FreeboxTv::cFreeboxEpg;

extern cFreeboxEpg *FreeboxEpg;

class cFreeboxChannel : public cListObject {
private:
  char *fbChannelEpgId;
  int fbChannelId;
  char *fbChannelUrl;
public:
  virtual ~cFreeboxChannel();
  tChannelID channelID;
  char* GetFbChannelEpgId() { return &fbChannelEpgId [0]; }
  int GetFbChannelId() { return fbChannelId; }
  char* GetFbUrl() { return &fbChannelUrl [0]; }
  bool Parse(const char *s);
  };

class cFreeboxChannels : public cConfig<cFreeboxChannel> {
public:
  cFreeboxChannel *GetFreeboxChannel(const cChannel *Channel);
  char *GetFreeboxUrl (int fbChannelId);
  int GetFreeboxEpgId (const char *xmltv_channel_name);
  };

extern cFreeboxChannels FreeboxChannels;


// --- cFreeboxEPG --------------------------------------------------

cFreeboxEpg::cFreeboxEpg() {
}

cFreeboxEpg::~cFreeboxEpg() {
}

bool cFreeboxEpg::Parse (const char* xmltv_filename) {
  const xmlpp::Node* node = NULL;
  const xmlpp::TextNode* nodeText;
  const xmlpp::Element* nodeElement;

  xmlpp::Node::NodeList list, list2, list3;
  xmlpp::Node::NodeList::iterator iter_node, iter_node2, iter_node3;
  xmlpp::Element::AttributeList::const_iterator iter_attr;

  xmlpp::DomParser parser;

  Glib::ustring nodename, attr, value;
  char *chaine = new char [30];
  char *resume = new char [2048];
  struct tm tm_debut, tm_fin;
  char *fbChId = new char [30];
  char *buf = new char [255];
  tEventID eventid = (tEventID)NULL;
  cEvent *Event = NULL;
  cSchedule *schedule = NULL;
  cSchedules *Schedules;
  bool ignore = false;

  try {

    cSchedulesLock SchedulesLock;
    Schedules = (cSchedules*) cSchedules::Schedules(SchedulesLock);

    parser.parse_file((Glib::ustring )xmltv_filename);

    if(parser)
    {
      node = parser.get_document()->get_root_node();
      list = node->get_children();
      for(iter_node = list.begin(); iter_node != list.end(); ++iter_node)
      {
        ignore = false;
        if ((*iter_node)->get_name() == "programme") {
          nodeElement = dynamic_cast<const xmlpp::Element*>(*iter_node);

          // Rcupration des attributs
          const xmlpp::Element::AttributeList& attributes = nodeElement->get_attributes();

          for(xmlpp::Element::AttributeList::const_iterator iter_attr = attributes.begin(); iter_attr != attributes.end(); ++iter_attr) {
            const xmlpp::Attribute* attribute = *iter_attr;
            attr = attribute->get_name();

            if (attr == "start") {
              value = attribute->get_value();
              strcpy (buf, value.data());
              strptime (buf, "%Y%m%d%H%M", &tm_debut);
              continue;
            }

            if (attr == "stop") {
              value = attribute->get_value();
              strcpy (buf, value.data());
              strptime (buf, "%Y%m%d%H%M", &tm_fin);
              continue;
            }

            if (attr == "showview") {
              eventid = atoi ((attribute->get_value()).data());
              continue;
            }

            if (attr == "channel") {
              value = attribute->get_value();
              strcpy (chaine, value.data());
              if (int idchaine = FreeboxChannels.GetFreeboxEpgId (chaine)) {
                // Rcupration depuis channels.conf.freebox du NID correspondant  la chane concerne
                sprintf (fbChId, "C-1-%d-1-0", idchaine);
                continue;
              }
              else {
                // Chaine ignore car absente dans channels.conf.freebox
                ignore = true;
              }
            }
          }

          if (!ignore) {
            // Ajout d'un programme pour la chane concerne
            tChannelID channelID = tChannelID::FromString (fbChId);
            if ((Schedules) && (channelID.Valid())) {
              schedule = Schedules->AddSchedule(channelID);
            }
            else
              break;

            // Ajout d'un vnement pour la programmation courante
            Event = new cEvent(eventid);
            if (Event) {
              Event->SetTableID(0);   // VDR n'y touchera pas...
              Event->SetShortText("");
              Event->SetDescription("");

              //Mise  jour des heures de dbut/fin du programme
              Event->SetStartTime(mktime (&tm_debut));
              Event->SetDuration(mktime (&tm_fin) - mktime (&tm_debut));
            }

            //Rcupration des enfants du programme
            list2 = (*iter_node)->get_children();
            for(iter_node2 = list2.begin(); iter_node2 != list2.end(); ++iter_node2)
            {
              nodename = (*iter_node2)->get_name();
              if ((nodename == "title") || (nodename == "desc")) {
                // Rcupration du contenu pour titre ou desc (i.e. le rsum)
                list3 = (*iter_node2)->get_children();
                for(iter_node3 = list3.begin(); iter_node3 != list3.end(); ++iter_node3)
                {
                  nodeText = dynamic_cast<const xmlpp::TextNode*>(*iter_node3);
                  if((nodeText))
                  {
                    // Lecture du rsum et conversion " la vole" de UTF-8 vers ISO-8859-1
                    strcpy (resume, (Glib::convert(nodeText->get_content(), "ISO-8859-1", "UTF-8")).data());
                    if (nodename == "title")
                      // Titre
                      Event->SetTitle (resume);
                    else {
                      // Description, i.e. resume court ou long
                      if (!strlen (Event->ShortText()) || (strlen (resume) < strlen (Event->ShortText())))
                      {
                        // Aucun rsum mmoris jusqu' prsent ou la valeur courante est plus courte
                        Event->SetDescription (Event->ShortText());
                        Event->SetShortText (resume);
                      }
                      else
                        Event->SetDescription (resume);
                    }
                  }
                }
              }
            }
            // S'il n' a pas de description longue, on met le rsum  la place
            if (!strlen (Event->Description ()))
              Event->SetDescription (Event->ShortText());

            // Ajout de l'vnement dans la liste du programme en cours
            schedule->AddEvent(Event);
          }
        }
      }
    }

    delete fbChId;
    delete buf;
    delete chaine;
    delete resume;

    return true;
  }

  catch(const std::exception& ex)
  {
    fprintf (stderr, "*** Erreur parsing fichier %s : %s\n", xmltv_filename, ex.what());
    return false;
  }
}

