<?php

# Importations des constantes php
include("constantes.php");

# Envoie l'indice de la valeur recherchée dans la tableau. 
function rech_corr($ch_rec,$tableau,$type,$col)
	{	
	# Type de recherche 
	# 0 : Recherche dans les categories
	# 1 : Recherche dans les chaines
	# 2 : Recherche dans les sous categories	
		
	if($type==0)
		{
		for($i=0;$i<count($tableau);$i++)
			if($tableau[$i]==$ch_rec)
				return ($i);
		}
	else if($type==1)
		{
		for($i=0;$i<count($tableau);$i++)
			if($tableau[$i][$col]==$ch_rec)
				return ($i);
		}
	else
		{
		if (!isset($tableau[$col][0])) return(-1);	
		
		for($i=0;$i<count($tableau[$col]);$i++)
			if($tableau[$col][$i]==$ch_rec)
				return ($i);
		}
			
	return(-1);		
	}

# Lecture des différents fichiers
if (!($fp = fopen(TVGUIDE_XML, "r"))) {
    die("Impossible d'ouvrir le fichier ".TVGUIDE_XML);
}
$data = fread($fp, filesize(TVGUIDE_XML));
fclose($fp);

# Pour recuperer le numero de la chaine correspondant a la trans
if (!($fp = fopen(CHANNELS_CONF, "r"))) {
    die("Impossible d'ouvrir le fichier ".CHANNELS_CONF);
}
$data_ch_str = fread($fp, filesize(CHANNELS_CONF));
fclose($fp);

# Convertie le string en tableau
$data_ch_tmp = explode("\n",$data_ch_str);

# Pour realiser la correspondance entre le nom de la chaine Kazer et celui de VDR
if (!($fp = fopen(KAZER_TNT_TRANS, "r"))) {
    die("Impossible d'ouvrir le fichier ".KAZER_TNT_TRANS);
}
$data_trans_str = fread($fp, filesize(KAZER_TNT_TRANS));
fclose($fp);

# Mise en forme du tableau de chaines
$data_ch=array(); 
for ($i=0;$i<count($data_ch_tmp);$i++)
	{
	$ch_tmp=split('[;:]', $data_ch_tmp[$i],2);	
	if (strlen($ch_tmp[0])>1) $data_ch[]=$ch_tmp[0];
	}
unset($ch_tmp);	
unset($data_ch_tmp);	

# Convertie le string en tableau
$data_trans = explode("\n",$data_trans_str);
#print_r ($data_trans);

# Ouverture de la base de données
$connex = mysql_connect("localhost",USER,PASSWORD) Or Die ("Connexion impossible au serveur Mysql");
mysql_select_db(NOM_BASE,$connex) or die ("Connexion impossible à la base");

# Vide les tables avant d'integrer les données
$req_sel ="delete from categorie";
$req = mysql_query($req_sel,$connex) OR die('Pb suppression des categories '.mysql_error()); 

$req_sel ="delete from sous_categorie";
$req = mysql_query($req_sel,$connex) OR die('Pb suppression des sous_categories '.mysql_error()); 

$req_sel ="delete from descriptions";
$req = mysql_query($req_sel,$connex) OR die('Pb suppression des descriptions '.mysql_error()); 

$req_sel ="delete from informations";
$req = mysql_query($req_sel,$connex) OR die('Pb suppression des informations '.mysql_error()); 

$req_sel ="delete from epg";
$req = mysql_query($req_sel,$connex) OR die('Pb suppression des epg '.mysql_error()); 

# Creation et initialisation du parser xml
$xml_parser = xml_parser_create();
xml_parse_into_struct($xml_parser, $data, $vals, $index);
xml_parser_free($xml_parser);



# Indice indiquant dans un premier temps le n° chaine traitée.
#                  dans un deuxime temp, pas de signification particuliere.
$indice = 0;

# Variables d'indice
$num_prog = 0;		# Numero de programme
$num_cat = 0;		# Numero de la categorie
$num_sous_cat = 0;	# Numero de la sous-categorie
$num_info = 0;		# Numero de l'information
$ordre = 0;			# Numero d'ordre dans lequel apparait l'information pour chaque emission
$num_info= 0;		# Numero correspondant a l'indice de l'information pour un même libelle (ex:ACTOR)

# Tableaux
$tab_cat = array();
$tab_sous_cat = array();
$chaines = array();			# Tableau des chaines avec sa correspondance

# Drapeau
$flag_channel = true;		# Determine le type de traitement : Chaines ou Programmes
$flag_categorie=true;		# Permet de differencier la catégorie de la sous categorie
$flag_sous_branche=False;

$libelle_old = "";
$num_ligne=0; 
foreach ($vals as $xml_elem) 
	{

	# Fin de traitement pour les chaines et debut traitement pour les programmes
	if ($xml_elem['tag'] == 'PROGRAMME' && $flag_channel) 
		{
		$flag_channel = false;
		
		# Pour chaque chaine, je recherche sa transformation
		$indice = 0;
		foreach ($chaines as $chaine)
			{
			for($i=0;$i<count($data_trans);$i++)
				{
				# Ne prends pas les lignes qui commencent par # ou de longueur < 2
				if((substr($data_trans[$i],0,1)!='#')&&(strlen($data_trans[$i])>2))
					{
					#print "-> ".$data_trans[$i]."\n";
						
					list($ch_channel, $ch_xml) = split(':', $data_trans[$i]);	
					if ($chaines[$indice][1] == $ch_xml)
						$chaines[$indice][2] = $ch_channel;
					}
				}
			$indice = $indice +1;
			}
		
		# Recopie la chaine de XML comme chaine de reférence
		for($i=0;$i<count($chaines);$i++)
			{
			#print count($chaines[$i]);
			if (count($chaines[$i])<3) $chaines[$i][2] = $chaines[$i][1];
			}	
		#print_r ($chaines);		
		}
	
	# Traitement des chaines que l'on met dans un tableau
	if ($flag_channel)
		{
		if ($xml_elem['tag']=='CHANNEL')
			if ($xml_elem['type']== 'open')
				$chaines[$indice][0]=$xml_elem['attributes']['ID'];
			else if ($xml_elem['type']== 'close')
				$indice = $indice +1 ;
			
		if ($xml_elem['tag']=='DISPLAY-NAME')
			$chaines[$indice][1]=$xml_elem['value'];
		}
	
	else
		{
		if ($xml_elem['tag']=='PROGRAMME')
			if ($xml_elem['type']== 'open')
				{
				$flag_categorie = True;
				$num_info=0;
				$ordre=0;	
				$debut = $xml_elem['attributes']['START'];
				
				#print "Numero de programme : ".$num_prog." ".$debut."\n";
			
				$jour=substr($debut,0,4)."-".substr($debut,4,2)."-".substr($debut,6,2);
				$heure_debut=substr($debut,8,4);
				$heure_fin=substr($xml_elem['attributes']['STOP'],8,4);
				
				# Recherche la correspondance entre le nom Kazer et le Trans
				$indice=rech_corr($xml_elem['attributes']['CHANNEL'],$chaines,1,0);				
				$chaine=$chaines[$indice][2];
				
				# Recherche l'indice de la chaine Trans dans le channels.conf
				$num_chaine=rech_corr($chaine,$data_ch,0,0);

				if($num_chaine==-1)
					{
					print "Il manque une correspondance pour la chaine ".$chaine."\n";
					
					/*
					On devrait sortir pour une gestion normale du programme
					mais en ne sortant pas pour ce type de problème alors
					on peut visualiser des programmes d'emision sans pouvoir les enregistrer
					
					mysql_close();	
					exit();
					*/ 
					}				
				else $num_chaine++;
				}
			else if ($xml_elem['type']== 'close')
				{
				$req_sel ="INSERT INTO epg VALUES ('$num_prog','$num_chaine','$chaine','$jour','$heure_debut','$heure_fin','$num_cat','$num_sous_cat')";
				$req = mysql_query($req_sel,$connex) OR die('Pb Insertion des epg '.$req_sel." ".mysql_error()); 				

				$num_prog++;
				#print("\n___________________________________________________________________________\n\n");
				}

		if ($xml_elem['type']== 'complete')
			{
			if($xml_elem['tag']=='CATEGORY')
				{
				$value = $xml_elem['value'];
	
				# Differencie la categorie de la sous categorie	
				if($flag_categorie)
					{
					# Traitement de la categorie
					#print "Categorie = ".$value." ";
					$categorie=$value;
					
					# Recherche si la catégorie existe ou pas
					$num_cat=rech_corr($value,$tab_cat,0,0);
					if($num_cat==-1)
						{
						$tab_cat[]=$value;
						$num_cat=count($tab_cat)-1;
						$req_sel ="INSERT INTO categorie VALUES ('$num_cat','$value')";
						$req = mysql_query($req_sel,$connex) OR die('Pb Insertion des categories '.mysql_error()); 
						}
					}	
				else
					{
					$value=str_replace("'","\'",$value);	
						
					# Traitement de la sous categorie					
					$num_cat=rech_corr($categorie,$tab_cat,0,0);
					
					$num_sous_cat=rech_corr($value,$tab_sous_cat,2,$num_cat);
					if ($num_sous_cat==-1)
						{						
						$tab_sous_cat[$num_cat][]=$value;
						$num_sous_cat=count($tab_sous_cat[$num_cat])-1;
						$req_sel ="INSERT INTO sous_categorie VALUES ('$num_cat','$num_sous_cat','$value')";
						$req = mysql_query($req_sel,$connex) OR die('Pb Insertion des sous_categories '.mysql_error()); 
						}
					#print "Cat et sous cat " .$num_cat." ".$num_sous_cat;
	
					}
				# Permutte la valeur du flag
				$flag_categorie = ! $flag_categorie;
				}
			else if($xml_elem['tag']=='DESC')
				{
				$value = $xml_elem['value'];				

				# Decoupage de la description en morceaux de 100 caractères
				$indice=0;	
				foreach (str_split($value,100) as $ligne)
					{
					# Remplace ' par \' dans la ligne afin de contourner l'erreur SQL	
					$ligne=str_replace("'","\'",$ligne);	
					$req_sel ="INSERT INTO descriptions VALUES ('$num_prog','$indice','$ligne')";
					$req = mysql_query($req_sel,$connex) OR die('Pb Insertion des descriptions '.mysql_error()); 
					$indice++;
					}
				}	
			else
				{	
				if (array_key_exists ('value',$xml_elem))
					{	
					# Permet d'incrementer num_info	
					$libelle = $xml_elem['tag'];
					if($libelle==$libelle_old)
						$num_info++;
					$libelle_old=$libelle;	
					
					$value = $xml_elem['value'];

					# Affectation de la bonne valeur du libelle dans la base
					$libelle_base=$libelle;
					if($flag_sous_branche)
						{
						#print "Change le ".$libelle." par ".$libelle_sauve." pour la valeur ".$value."\n";
						$libelle_base=$libelle_sauve;
						}
										
					# Remplace ' et " par ' ' dans la ligne afin de contourner les erreurs de decoupage	
					$value=str_replace("'"," ",$value);
					$value=str_replace("\""," ",$value);
					
					# Decoupage de l'information en morceaux de 16 caractères
					$indice=0;					
					foreach (str_split($value,16) as $ligne)
						{
						$req_sel ="INSERT INTO informations VALUES ('$num_prog','$ordre','$libelle_base','$num_info','$indice','$ligne')";
						$req = mysql_query($req_sel,$connex) OR die('Pb Insertion des informations '.$req_sel." ".mysql_error()); 
						$indice++;
						}
					$ordre++;
					}					
				}
				
			}
		# Gestion particuliere pour les informations specifiques : AUDIO, VIDEO, ...	
		else if($xml_elem['tag']!='PROGRAMME' && $xml_elem['tag']!='CREDITS' && $xml_elem['tag']!='TV' && $xml_elem['type']!='cdata')
			{
			#print $xml_elem['tag']."  ".$xml_elem['type']."\n";
			
			$flag_sous_branche=True;
			# Sauvegarde du libelle pour 
			if($xml_elem['type']=='open') 
				$libelle_sauve=$xml_elem['tag'];
			else $flag_sous_branche=False;
			}				
		}
	$num_ligne++;
	}

# Fermeture de la base de données.

mysql_close();
print "\n\nNombre d'emissions incorporées : ".$num_prog."\n";
?>
