/*
 * vod.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#include <vdr/plugin.h>

#include "config.h"
#include "menu.h"
#include "setup.h"
#include "parser.h"
#include "src_rss.h"
//#include "i18n.h"

static const char *VERSION        = "0.0.1";
static const char *DESCRIPTION    = "Watch videos from the internet";
static const char *MAINMENUENTRY  = "Video On Demand";

// Playable items
cItems Items;
cRssItems RssItems;

class cPluginVod : public cPlugin {
private:
  // Add any member variables or functions you may need here.
public:
  cPluginVod(void);
  virtual ~cPluginVod();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return DESCRIPTION; }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void);
  virtual bool Start(void);
  virtual void Stop(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void) { return MAINMENUENTRY; }
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  virtual bool Service(const char *Id, void *Data = NULL);
  virtual const char **SVDRPHelpPages(void);
  virtual cString SVDRPCommand(const char *Command, const char *Option, int &ReplyCode);
  };

cPluginVod::cPluginVod(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
  config.red=50;
  config.green=50;
  config.blue=50;
}

cPluginVod::~cPluginVod()
{
  // Clean up after yourself!
}

const char *cPluginVod::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginVod::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginVod::Initialize(void)
{
  // Initialize any background activities the plugin shall perform.
  return true;
}

bool cPluginVod::Start(void)
{
  // Start any background activities the plugin shall perform.
  return true;
}

void cPluginVod::Stop(void)
{
  // Stop any background activities the plugin shall perform.
}

void cPluginVod::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

cOsdObject *cPluginVod::MainMenuAction(void)
{
  // Perform the action when selected from the main VDR menu.
  if(!RssItems.Load(AddDirectory(ConfigDirectory(),"rss.conf"), false)) {
    // File load failed
    dsyslog("rss.conf file not found");
  }
  return new cVodMenu;
}

cMenuSetupPage *cPluginVod::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cVodSetup;
}

bool cPluginVod::SetupParse(const char *Name, const char *Value)
{
  // Parse your own setup parameters and store their values.
  if      (!strcasecmp(Name, "Red"))        config.red = atoi(Value);
  else if (!strcasecmp(Name, "Green"))      config.green = atoi(Value);
  else if (!strcasecmp(Name, "Blue"))       config.blue = atoi(Value);
  else
     return false;
  
  return true;
}

bool cPluginVod::Service(const char *Id, void *Data)
{
  // Handle custom service requests from other plugins
  return false;
}

const char **cPluginVod::SVDRPHelpPages(void)
{
  // Return help text for SVDRP commands this plugin implements
  return NULL;
}

cString cPluginVod::SVDRPCommand(const char *Command, const char *Option, int &ReplyCode)
{
  // Process SVDRP commands this plugin implements
  return NULL;
}

sVodConfig config;

VDRPLUGINCREATOR(cPluginVod); // Don't touch this!
