#ifndef __SRC_RSS_H
#define __SRC_RSS_H

#include <vdr/plugin.h>
#include <vdr/channels.h>
#include "defines.h"

class cRssItem : public cListObject {
private:
  char target[MAXTEXTLENLONG];
public:
  bool Parse(char *s);
  void SetTarget(const char *s) { dsyslog ("vod/src_rss: Target: '%s'\n", s); strncpy(target, s, MAXTEXTLENLONG); }
  char *GetTarget(void)         { return target; }
};

class cRssItems : public cConfig<cRssItem> {
private:
  const char *FileName_;
public:
  virtual bool Load(const char *filename, bool dummy);
};

#endif //__SRC_RSS_H

