/*
 * menu.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */
 
#include <vdr/plugin.h>

#include "menu.h"
#include "config.h"
#include "i18n.h"
#include "parser.h"
#include "src_rss.h"

extern cItems Items;
extern cRssItems RssItems;

#if VDRVERSNUM >= 10334
  #define OSDSELECTABLE_TRUE ,true
  #define OSDSELECTABLE_FALSE ,false
#else
  #define OSDSELECTABLE_TRUE 
  #define OSDSELECTABLE_FALSE 
#endif

// Menus are:
// cVodMenu             -> Choose VOD type
//   cRssMenu           -> Choose RSS type
//     cItemsMenu       -> Browse items and choose
//   cVideoSearchMenu   -> Video search

// Go through items
//  for (cItem *Item = Items.First(); Item; Item = Items.Next(Item))
//      itemDescriptions[Item->Index()] = Item->Description();

// --- cItemsMenu ---------------------------------------------------------
cItemsMenu::cItemsMenu(void):
		cOsdMenu(tr("Items Menu")) {
  SetTitle(tr("Select an item to play"));
  char s[MAXMULTILINELONG];
  dsyslog("DEBUG Creating menu");
  for (cItem *Item = Items.First(); Item; Item = Items.Next(Item)) {
    //snprintf(s, MAXMULTILINELONG, "%s\n%s", Item->GetTitle(), Item->GetDesc());
    snprintf(s, MAXMULTILINELONG, "%s", Item->GetTitle());
    AddMultiLineItem(s);
    
  }
  Display();
}

void cItemsMenu::AddMultiLineItem(const char *s)
{
  bool first = true;
  while (s && *s) {
    const char *p = strchr(s, '\n');
    int l = p ? p - s : strlen(s);
    cOsdItem *item = new cOsdItem;
    if (first) {
      first = false;
    } else {
      item->SetSelectable(false);
    }
    item->SetText(strndup(s, l), false);
    Add(item);
    s = p ? p + 1 : p;
  }
}

eOSState cItemsMenu::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);
  if (state == osUnknown) {
   switch (Key) {
    case kOk: Play();
      // TODO: after play, go back to the same menu
      return osEnd;
      break;
    default:
      break;
   }
  }
  return state;
}

void cItemsMenu::Play(void)
{
  // FIXME: When several lines will exist (summary + details) the /2 will not work anymore
  cItem *i = (cItem *)Items.Get(Current());
  if (i) {
    // Skins.Message(mtInfo, "Caching video...");
    dsyslog("Title to play: '%s'", i->GetTarget());
    cPlugin *Plugin = cPluginManager::GetPlugin("mplayer");
    if (Plugin) {
      char *target;
      target = strdup(i->GetTarget());
      target = strreplace(target, "//", "#");
      if (!Plugin->Service("Mplayer-play-v1.0", target))
        Skins.Message(mtError, "MPlayer plugin does not support service interface!");
      free (target);
    } else {
      Skins.Message(mtError, "MPlayer plugin not found!");
    }
  }
}

// --- cRssMenu ---------------------------------------------------------
cRssMenu::cRssMenu(void):
		cOsdMenu(tr("RSS Menu")) {
  SetTitle(tr("Select an RSS feed"));
  for (cRssItem *Item = RssItems.First(); Item; Item = RssItems.Next(Item)) {
    Add(new cOsdItem(Item->GetTarget()));
  }
  Display();
}

eOSState cRssMenu::Select(void)
{
  cRssItem *i = (cRssItem *)RssItems.Get(Current());
  if (i) {
    dsyslog("vod/menu: RSS to parse: '%s'", i->GetTarget());
    if ((dl_page(i->GetTarget())) &&
        (rss_parser("/tmp/vodfile"))) {
      return AddSubMenu(new cItemsMenu);
    } else {
      return osBack;
    }
  }
  return osEnd;
}

eOSState cRssMenu::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);
  if (state == osUnknown) {
   switch (Key) {
    case kOk:
      return Select();
      break;
    default:
      break;
   }
  }
  return state;
}

// --- cVodMenu ---------------------------------------------------------
cVodMenu::cVodMenu(void):
		cOsdMenu(tr("VOD Menu")) {
  SetTitle(tr("Select a VOD source"));
  Add(new cOsdItem(hk(tr("RSS feed")), osUser1 OSDSELECTABLE_TRUE));
  Add(new cOsdItem(hk(tr("Yahoo video search")), osUser2 OSDSELECTABLE_TRUE));
  Display();
}

eOSState cVodMenu::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);

  switch (state) {
    case osUser1: return AddSubMenu(new cRssMenu);
    case osUser2: Skins.Message(mtWarning, "Not yet supported!"); return state;
    default: ;
  }
  return state;
}



  /*
  char FileToPlay[512];
  strcpy (FileToPlay, "siou.free.fr/Detailled/Images/Parapente/Video/Dv/Coupe%20Icare%202005.wmv");
  cPlugin *Plugin = cPluginManager::GetPlugin("mplayer");
  if (Plugin) {
    Plugin->Service("Mplayer-play-v1.0", FileToPlay);
  }
  */

