#ifndef MENU_H
#define MENU_H
#include "diseqc.h"
#include "filter.h"
#include <vdr/plugin.h>

#define LINE '|'
#define BLANK ' '

class config {
public:
  int ActualSource;
  int fd_frontend;
  int DvbCard;
  int AByte;
  int repeat;
  int Lat;
  int Long;
  int SN;
  int EW;
  int UseGotoX;
  int UseGotoPos;
  int card[4];
  int ShowInfo;
  config() {ActualSource=0; DvbCard=0; AByte=49; repeat=false; Lat=0; Long=0; SN=false; EW=true; UseGotoX=false; UseGotoPos=false; card[0]=1; card[1]=1; card[2]=1; card[3]=1;  ShowInfo=false;};
};

class cRotorPos : public cListObject {
private:
  int code;
  int pos;
  int e_code;
  char *description;
public:
  cRotorPos(int Code = 0, int Pos = 0);
  ~cRotorPos();
  int Code(void) { return e_code; }
  int R_Code(void) { return code; }
  int Pos(void) { return pos; }
  void SetCode(int Code) { e_code=Code; }
  void SetPos(int Pos) { pos=Pos; }
  int GetCode();
  int GetPos();
  bool Parse(const char *s);
  bool Save(FILE *f);
  void AddDescription(const char *s);
  const char* Description() { return description; }
};

class cRotorPositions : public cConfig<cRotorPos> {
public:
  cRotorPos *GetfromSource(int Code);
  cRotorPos *GetfromPos(int Pos);
};

extern cRotorPositions RotorPositions;


class cMenuSetupRotor : public cMenuSetupPage {
private:
  int newDvbCard;
  int achsw;
  const char* texts[3];
  void Setup(void);
protected:
  virtual void Store(void);
public:
  cMenuSetupRotor(void);
  virtual eOSState ProcessKey(eKeys Key);
};

class cSubMenuSetupRotor : public cMenuSetupPage {
private:
  int cp;
protected:
  virtual void Store(void) {};
public:
  cSubMenuSetupRotor(void);
  ~cSubMenuSetupRotor(void);
  virtual eOSState ProcessKey(eKeys Key);
};

class cMainMenuRotor : public cOsdMenu, public cThread {
private:
  int oldupdate,Position,Frequenz,Symbolrate,edw;
  cRotorPos *RotorPos;
  char Pol;
  cChannel *OldChannel;
  bool m_Active,HasSwitched,assign;
  char SS[700];
  char SNR[700];
  bool Signal(int Frequenz, char Pol, int Symbolrate);
  void AddMenuItems();
//  cFont::tPixelData CharData[256*35];
protected:
  virtual void Action(void);
public:
  cMainMenuRotor(void);
  ~cMainMenuRotor();
  virtual eOSState ProcessKey(eKeys Key);
};

class PatFilter;
class SdtFilter;

/*
class cMenuScan : public cOsdMenu {
private:
  int num;
  cChannel Channel[64];
  PatFilter *PFilter;
  SdtFilter *SFilter;
  cOsdItem* n[64];
public:
  cMenuScan();
  ~cMenuScan();
  virtual eOSState ProcessKey(eKeys Key);
  void AddChannel(int Num);
  void NewChannel(const cChannel *Transponder, const char *Name, const char *ShortName, const char *Provider, int Nid, int Tid, int Sid);
  void SetPids(int Sid,int Vpid, int Ppid, int *Apids, char ALangs[][MAXLANGCODE2], int *Dpids, char DLangs[][MAXLANGCODE2], int Tpid);
  void SetCaIds(int Sid,const int *CaIds);
  void SetCaDescriptors(int Sid,int Level);
  cChannel* GetChannel(int Sid);
  void display(int num);
};
*/

extern config data;

#endif
