/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2005 Andreas Brachold <anbr at users.berlios.de>
 * based on (C) 2003 Kai Tobias Burwieck <kai -at- burwieck.net>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "data-image.h"
#include "data.h"
#include "setup-image.h"

cFileSources ImageSources;

// --- cImage -------------------------------------------------------------

cImage::cImage(const char *szName, cFileSource * pSource)
: m_pSource(pSource)
, m_szFileName(NULL)
{
  if(szName) {
    m_szFileName = m_pSource->BuildName(szName);
  }
  m_pSource->Block();

}

cImage::~cImage()
{
  Clear();
  m_pSource->Unblock();
}


bool UnlinkFile(const char *szFile)
{
    struct stat st;
    if(0 == stat(szFile,&st) && S_ISREG(st.st_mode) && 0 != unlink(szFile))
    {
        char szErr[128];
        int nErr = errno;
        szErr[sizeof(szErr)-1] = '\0';
        if(!nErr || 0 != strerror_r(nErr,szErr,sizeof(szErr)-1)) {
            szErr[0] = '\0';
        } 
        esyslog("picselshow: Can't remove temporary file %s, because: %s.",szFile,szErr[0] != '\0'?szErr:"unknown");
        return false;
    }
    return true;
}


void cImage::Clear(void)
{
  if(m_szFileName)
  {
    free(m_szFileName);
    m_szFileName = NULL;
  }
}

bool cImage::CompareBaseDir(const cFileSource * pSource) const
{
  return 0 == strcmp(m_pSource->BaseDir(),pSource->BaseDir());

}
// -- cSlideShow --------------------------------------------------------------

cSlideShow::cSlideShow(cDirItem * Item)
: m_szFirstImageName(NULL)
, m_DirItem(Item->Source, Item->Subdir, Item->Name, Item->Type)
{
    
}

cSlideShow::~cSlideShow()
{
  if(m_szFirstImageName)
    free(m_szFirstImageName);
}

bool cSlideShow::Load(void)
{
  bool res = false;
  Clear();
  switch (m_DirItem.Type)
	{
	case itFile:
    {
    dsyslog("picselshow: SlideShow: file %s\n", m_DirItem.Name);
		const char *path = m_DirItem.Subdir;
		res =
		    ScanDir(m_DirItem.Source, path, stFile, m_DirItem.Source->Include(),
			    0, true);
        if(res)
        {
               m_szFirstImageName = strdup(m_DirItem.Name); 
        }
        else
        {
             DoItem(m_DirItem.Source, m_DirItem.Subdir, m_DirItem.Name);
             res = true;
        }
		break;
        }
	case itDir:
	    {
		dsyslog("picselshow: SlideShow: dir name:%s\n", m_DirItem.Name);
		char *path = m_DirItem.Path();
		res =
		    ScanDir(m_DirItem.Source, path, stFile, m_DirItem.Source->Include(),
			    0, true);
 		free(path);
		break;
	    }
	case itBase:
	    dsyslog("picselshow: SlideShow: base\n");
	    res =
		ScanDir(m_DirItem.Source, 0, stFile, m_DirItem.Source->Include(), 0,
			true);
	    break;
	default:
	    break;
	}
  return res;
}

void cSlideShow::DoItem(cFileSource * src, const char *subdir,
			 const char *name)
{
  char *path = (char *)name;
  if(subdir)
    path = AddPath(subdir, name);
  Add(new cImage(path, src));
  if(subdir)
    free(path);
}
