#include <string>

#include <vdr/interface.h>
#include <vdr/menu.h>
#include <vdr/status.h>
#include <vdr/plugin.h>

#include "commands.h"
#include "setup-image.h"
#include "control-image.h"

#define M3U_EXT "*.m3u"
#define FINDCMD "cd '%s' && find '%s' -maxdepth 1 -iname '%s' -printf '%%p\n' | sort -f"

// ------------ cMP3ListItem ----------------------------------------------------------------------------------------------- //

class cMP3ListItem : public cOsdItem {
private:
  cFileObjItem *item;
  virtual void Set(void);
  int idx;
public:
  cMP3ListItem(cFileObjItem *Item, int index);
  cFileObjItem *Item(void) {return item;}
  ~cMP3ListItem();
};


cMP3ListItem::cMP3ListItem(cFileObjItem *Item, int index) {
  idx = index; 
  item = Item;
  Set();  
}

cMP3ListItem::~cMP3ListItem(){
}

void cMP3ListItem::Set(void) {
  char *Name;
  asprintf(&Name,"%s", item->Name());
  SetText(Name,false);
}


// ------------ cMenuMP3Playlist ---------------------------------------------------------------------------------------------- //



cMenuMP3Playlist::cMenuMP3Playlist(void)
:cOsdMenu(tr("Music for slideshow"),4)
{
  LoadMusicFiles();
  SetHelp();

  Display();
}

void cMenuMP3Playlist::SetHelp() {
  cOsdMenu::SetHelp(tr("Parent"),NULL,NULL,NULL);
}


void cMenuMP3Playlist::LoadMusicFiles()
{
  int count = 0;

  char *cmd = NULL;
  cReadLine reader;

  std::string plugindir;
  std::string themename;
  std::string themefile;
  std::string Base;

  plugindir = ImageSetup.MusicDir;
  plugindir = plugindir + "/";

  int  len2 = plugindir.length()+1;

   
  asprintf(&cmd, FINDCMD, plugindir.c_str(), plugindir.c_str(), M3U_EXT);

  FILE *p = popen(cmd, "r");

  if(p) {
    char *s;
    while ((s = reader.Read(p)) != NULL) {
      count++;
      themefile = s;
      int len = themefile.length();
      std::string::size_type pos = themefile.rfind('/',len);
      if(pos!=std::string::npos) {
        // Filename
        themename = themefile.substr(pos+1,len);
        // Basedir
        int sublen = len - len2 - themename.length()-1;
        Base = themefile.substr(len2,sublen);
      }
                                //FileSource , Name , Type
      newitem = new cFileObjItem(plugindir.c_str(), themename.c_str(), itFile);
      if(newitem && newitem->Type()==itFile) {
        Add(new cMP3ListItem(newitem, count));
      }
    }
    pclose(p);
  }
  else
    Skins.Message(mtError, "ERROR: Cant find any playlists!");
    
  free(cmd);
}          
      
cFileObjItem *cMenuMP3Playlist::CurrentFileObjItem(void) {
  cMP3ListItem *item = (cMP3ListItem *)Get(Current());
  return item ? item->Item():0;
}  

  
eOSState cMenuMP3Playlist::SetMusic(void) {

  std::string plugindir;
  plugindir = ImageSetup.MusicDir;
  plugindir = plugindir + "/";


  cFileObjItem *item=CurrentFileObjItem();

  if(item && item->Type()==itFile) {
    char *buffer;
    
    ServiceID="MP3ng-Play-v1";
    ServiceAvailable=cPluginManager::CallFirstService(*ServiceID, NULL);

    if(!ServiceAvailable) {
      return AddSubMenu(new cMenuText(tr("Error:"), tr("ERROR: Could not load playlist !"), fontFix));
      }
    else {

      MP3ServiceData ServiceData;
      asprintf(&buffer, "%s%s",plugindir.c_str(),item->Name() );
      ServiceData.data.filename=buffer;

      if(cPluginManager::CallFirstService(ServiceID, &ServiceData)) {
        if(ServiceData.result)  return osBack;
        }    
      else {
        Skins.Message(mtError, tr("ERROR: Could not load playlist !"));
      }
      free(buffer);
      buffer=0;
    }
  }
  else    
    return AddSubMenu(new cMenuText(tr("Error:"), tr("ERROR: Could not load playlist !"), fontFix));

  return osContinue;
  
}


eOSState cMenuMP3Playlist::ProcessKey(eKeys Key)
{
  eOSState state = cOsdMenu::ProcessKey(Key);

  if(state==osUnknown) {
     switch(Key) {
       case kOk:
          state = SetMusic();
	  break;     
       case kBlue:
       case kGreen:
       case kYellow:
       case kRed: return osBack;
       default: return osContinue;;
       }
     }
  return state;
}
