/*
 * See the README file for copyright information and how to reach the author.
 */

#include <string>
#include <locale.h>
#include <langinfo.h>
#include <math.h>
#include <vdr/menu.h>
#include <vdr/status.h>
#include "mywhatsonitem.h"

// --- Icons ------------------------------------------------------------------
class Icons
{
  private:
    static bool IsUTF8;
  public:
    static void InitCharSet();
    static const char* Continue(){return IsUTF8?"\ue000":"\x80";}
    static const char* DVD(){return IsUTF8?"\ue001":"\x81";}
    static const char* Directory(){return IsUTF8?"\ue002":"\x82";}
    static const char* FixedBlank(){return IsUTF8?"\ue003":"\x83";}
    static const char* Scissor(){return IsUTF8?"\ue004":"\x84";}
    static const char* MovingRecording(){return IsUTF8?"\ue005":"\x85";}
    static const char* MovingDirectory(){return IsUTF8?"\ue006":"\x86";}
    static const char* ProgressStart(){return IsUTF8?"\ue007":"\x87";}
    static const char* ProgressFilled(){return IsUTF8?"\ue008":"\x88";}
    static const char* ProgressEmpty(){return IsUTF8?"\ue009":"\x89";}
    static const char* ProgressEnd(){return IsUTF8?"\ue00a":"\x8a";}
    static const char* Recording(){return IsUTF8?"\ue00b":"\x8b";}
    static const char* AlarmClock(){return IsUTF8?"\ue00c":"\x8c";}
    static const char* TVScrambled(){return IsUTF8?"\ue00d":"\x8d";}
    static const char* Radio(){return IsUTF8?"\ue00e":"\x8e";}
    static const char* TV(){return IsUTF8?"\ue00f":"\x8f";}
    static const char* New(){return IsUTF8?"\ue010":"\x90";}
    static const char* Repititive_timer(){return IsUTF8?"\ue011":"\x91";}
    static const char* Running(){return IsUTF8?"\ue012":"\x92";}
};

bool Icons::IsUTF8=false;

void Icons::InitCharSet()
{
  // Taken from VDR's vdr.c
  char *CodeSet=NULL;
  if(setlocale(LC_CTYPE, ""))
    CodeSet=nl_langinfo(CODESET);
  else
  {
    char *LangEnv=getenv("LANG"); // last resort in case locale stuff isn't installed
    if(LangEnv)
    {
      CodeSet=strchr(LangEnv,'.');
      if(CodeSet)
        CodeSet++; // skip the dot
    }
  }

  if(CodeSet && strcasestr(CodeSet,"UTF-8")!=0)
    IsUTF8=true;
}

// --- myWhatsOnItem ----------------------------------------------------------
myWhatsOnItem::myWhatsOnItem(const cEvent *Event,cChannel *Channel,bool Next)
{
 event=Event;
 channel=Channel;
 next=Next;
 
 Set();
}

void myWhatsOnItem::Set()
{
 int i;
 char *buffer=NULL,m=' ';
 
 // look for timers
 for(cTimer *ti=Timers.First();ti;ti=Timers.Next(ti))
 {
  if(ti->Matches(t)&&(ti->Channel()==channel))
  {
   timer=ti;
   m=timer->Recording()?char(128):char(129);
  }
 }

 if(event)
 {
  // calculate progress bar
  int progress=(int)roundf((float)(time(NULL)-event->StartTime())/(float)(event->Duration())*10.0);

  if(progress<0)
    progress=0;
  else if(progress>9)
    progress=9;
  
  std::string ProgressBar;
  for(i=0;i < 10;i++)
  {
    if(i == 0 && progress > 0)
      ProgressBar+=Icons::ProgressFilled();
    else
      ProgressBar+=Icons::ProgressStart();
    
    if(i > 0 && i < 9)
    {
      if(i < progress)
        ProgressBar+=Icons::ProgressFilled();
      else
        ProgressBar+=Icons::ProgressEmpty();
    }
    
    if(i == 9 && progress == 9)
      ProgressBar+=Icons::ProgressFilled();
    else
      ProgressBar+=Icons::ProgressEnd();
  }
    
  if(showchannelnumbers)
    asprintf(&buffer,"%c\t%d\t%-10s\t %s\t%s",m,channel->Number(),channel->ShortName(true),(!(event->RunningStatus()==4)&&next)?*event->GetTimeString():ProgressBar.c_str(),event->Title());
  else
    asprintf(&buffer,"%c\t%-10s\t %s\t%s",m,channel->ShortName(true),(!(event->RunningStatus()==4)&&next)?*event->GetTimeString():ProgressBar.c_str(),event->Title());
 }
 else
 {
   if(showchannelnumbers)
     asprintf(&buffer,"%c\t%d\t%-10s\t \t(%s)",m,channel->Number(),channel->ShortName(true),tr("no info"));
   else
     asprintf(&buffer,"%c\t%-10s\t \t(%s)",m,channel->ShortName(true),tr("no info"));
 }

 SetText(buffer,false);
}
