#!/usr/bin/python
# -*- coding: utf-8 -*-
#
#  (c) 2004-2008 The Music Player Daemon Project
#  http://www.musicpd.org/
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#
# Load lyrics from leoslyrics.com
#

from os import system
from sys import argv, exit
from string import replace
from urllib import urlencode, urlopen
from xml.sax import make_parser, SAXException
from xml.sax.handler import ContentHandler

#Variables
ARTIST=argv[1]
TITLE=argv[2]
LYRICSDIR="/tmp/"
debug=1

class SearchContentHandler(ContentHandler):
    def __init__(self):
        self.code = None
        self.hid = None

    def startElement(self, name, attrs):
        if name == 'response':
            self.code = int(attrs['code'])
        elif name == 'result':
            if self.hid is None or attrs['exactMatch'] == 'true':
                self.hid = attrs['hid']

def search(artist, title):
    query = urlencode({'auth': 'ncmpc',
                       'artist': artist,
                       'songtitle': title})
    url = "http://api.leoslyrics.com/api_search.php?" + query
    f = urlopen(url)
    handler = SearchContentHandler()
    parser = make_parser()
    parser.setContentHandler(handler)
    parser.parse(f)
    return handler.hid

class LyricsContentHandler(ContentHandler):
    def __init__(self):
        self.code = None
        self.is_text = False
        self.text = None

    def startElement(self, name, attrs):
        if name == 'text':
            self.text = ''
            self.is_text = True
        else:
            self.is_text = False

    def characters(self, chars):
        if self.is_text:
            self.text += chars

def lyrics(hid):
    query = urlencode({'auth': 'ncmpc',
                       'hid': hid})
    url = "http://api.leoslyrics.com/api_lyrics.php?" + query
    f = urlopen(url)
    handler = LyricsContentHandler()
    parser = make_parser()
    parser.setContentHandler(handler)
    parser.parse(f)
    return handler.text

hid = search(argv[1], argv[2])
if hid is None:
    f = open (LYRICSDIR+"temp.lyrics","w")
    f.write ("FEHLER: Kein Liedtext gefunden..\noder Download inkorrekt\nARTIST: "+ARTIST+"\nTITEL: "+TITLE)
    f.close ()
    exit(2)
else:
#    final=string.replace(hid,"<br/>","")
#    final=string.replace(hid,"&ouml;","ö")
#    final=string.replace(hid,"&auml;","ä")
#    final=string.replace(hid,"&uuml;","ü")
#    final=string.replace(hid,"&Ouml;","Ö")
#    final=string.replace(hid,"&Auml;","Ä")
#    final=string.replace(hid,"&Uuml;","Ü")
#    final=string.replace(hid,"&#039;","'")
#    final=string.replace(hid,"&acute;","'")
#    final=string.replace(hid,"&quot;","\"")
#    final=string.replace(hid,"&szlig;","ß")
    print "ARTIST: "+ARTIST+"\nTITEL: "+TITLE+"\n\n"+lyrics(hid).encode('utf-8')
    f = open (LYRICSDIR+"temp.lyrics","w")
    f.write ("ARTIST: "+ARTIST+"\nTITEL: "+TITLE+"\n\n"+lyrics(hid).encode('utf-8'))
    f.close ()
    system("dos2unix "+LYRICSDIR+"temp.lyrics")
