/*
 * mosaicsetup.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */
 

#include "mosaicsetup.h"
#include "config.h"

cMosaicSetup::cMosaicSetup(void)
{

  Top         = config.top;
  Left        = config.left;
  Right       = config.right;
  Originx     = config.originx;
  Originy     = config.originy;
  Width       = config.width;
  Height      = config.height;
  Bottom      = config.bottom;
  Showlogos   = config.showlogos;
  Mosaic1     = config.mosaic1;
  Mosaic2     = config.mosaic2;
  Mosaic3     = config.mosaic3;
  Mosaic4     = config.mosaic4;
  Mosaic5     = config.mosaic5;
  
  Add(new cMenuEditIntItem(tr("Origin X"),             &Originx, 0, 768));
  Add(new cMenuEditIntItem(tr("Origin Y"),             &Originy, 0, 576));
  Add(new cMenuEditIntItem(tr("Width"),                &Width, 0, 768));
  Add(new cMenuEditIntItem(tr("Height"),               &Height, 0, 768));
  Add(new cMenuEditIntItem(tr("Left"),                 &Left, 0, 255));
  Add(new cMenuEditIntItem(tr("Right"),                &Right, 0, 255));
  Add(new cMenuEditIntItem(tr("Top"),                  &Top, 0, 255));
  Add(new cMenuEditIntItem(tr("Bottom"),               &Bottom, 0, 768));
  Add(new cMenuEditBoolItem(tr("Show channel logos"),  &Showlogos));
  Add(new cMenuEditChanItem(tr("Mosaic channel 1"),    &Mosaic1, "0"));
  Add(new cMenuEditChanItem(tr("Mosaic channel 2"),    &Mosaic2, "0"));
  Add(new cMenuEditChanItem(tr("Mosaic channel 3"),    &Mosaic3, "0"));
  Add(new cMenuEditChanItem(tr("Mosaic channel 4"),    &Mosaic4, "0"));
  Add(new cMenuEditChanItem(tr("Mosaic channel 5"),    &Mosaic5, "0"));
  Add(new cMenuEditBoolItem(tr("Hide MainMenuEntry"),  &Hidemenu));
}

void cMosaicSetup::Store(void)
{
  SetupStore("Top",         config.top = Top);
  SetupStore("Left",        config.left = Left);
  SetupStore("Right",       config.right = Right);
  SetupStore("OriginX",     config.originx = Originx);
  SetupStore("OriginY",     config.originy = Originy);
  SetupStore("Width",       config.width = Width);
  SetupStore("Height",      config.height = Height);
  SetupStore("Bottom",      config.bottom = Bottom);
  SetupStore("Showlogos",   config.showlogos = Showlogos);
  SetupStore("Mosaic1",     config.mosaic1 = Mosaic1);
  SetupStore("Mosaic2",     config.mosaic2 = Mosaic2);
  SetupStore("Mosaic3",     config.mosaic3 = Mosaic3);
  SetupStore("Mosaic4",     config.mosaic4 = Mosaic4);
  SetupStore("Mosaic5",     config.mosaic5 = Mosaic5);
  SetupStore("Hidemenu",    config.hidemenu = Hidemenu);
}


