#ifndef _CPUMON_OSD_H_
#define _CPUMON_OSD_H_

#include <vdr/plugin.h>
#include <vdr/thread.h>
#include <vdr/status.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include "cpumonfetcher.h"
#include "parms.h"

#define DMODE_POINTS 0
#define DMODE_LINES  1
#define DMODE_SOLID  2


class cCpuMonOsd: public cThread, public cOsdObject
{
private:
  cOsd *osd;
  cParameters *parms;
  cCpuMonFetcher *Fetcher;
  cCondWait timer;
  static cCpuMonOsd *pInstance;
  tColor bgcolor,
         arrowcolor,
	 gridcolor,
	 legendcolor,
	 legendcolor_en,
	 rulercolor,
	 functioncolor[4];

  unsigned int get_next_value(tMeasured* act_val,
                              unsigned int rank);
  void show_functions();
  void drawBoard();
  void drawLegend();
  void deleteLegend();
  void Reset();
  void DrawLine(unsigned int x1,
                unsigned int y1,
		unsigned int x2,
		unsigned int y2,
		unsigned int lw,
		tColor lcolor);

protected:
  cCpuMonOsd();
  
public:
  static cCpuMonOsd *Instance(cCpuMonFetcher *pFetcher,
                              cParameters *pparms);
  ~cCpuMonOsd(void);
  virtual void Action();
  virtual void Show(void);
  virtual eOSState ProcessKey(eKeys Key);
};

#endif
